/*
 * Decompiled with CFR 0.152.
 */
package com.clarkparsia.pellet.rules;

import com.clarkparsia.pellet.rules.model.AtomDVariable;
import com.clarkparsia.pellet.rules.model.AtomIVariable;
import com.clarkparsia.pellet.rules.model.AtomObject;
import com.clarkparsia.pellet.rules.model.AtomVariable;
import com.clarkparsia.pellet.rules.model.DefaultAtomObjectVisitor;
import com.clarkparsia.pellet.rules.model.RuleAtom;
import java.util.Collection;
import java.util.HashSet;

public class VariableUtils {
    public static Collection<AtomDVariable> getDVars(RuleAtom atom) {
        VisitingDCollector collector = new VisitingDCollector();
        for (AtomObject atomObject : atom.getAllArguments()) {
            atomObject.accept(collector);
        }
        return collector.getVariables();
    }

    public static Collection<AtomIVariable> getIVars(RuleAtom atom) {
        VisitingICollector collector = new VisitingICollector();
        for (AtomObject atomObject : atom.getAllArguments()) {
            atomObject.accept(collector);
        }
        return collector.getVariables();
    }

    public static Collection<AtomVariable> getVars(RuleAtom atom) {
        VisitingCollector collector = new VisitingCollector();
        for (AtomObject atomObject : atom.getAllArguments()) {
            atomObject.accept(collector);
        }
        return collector.getVariables();
    }

    public static boolean isVariable(AtomObject obj) {
        VisitingCollector collector = new VisitingCollector();
        obj.accept(collector);
        return collector.getVariables().size() == 1;
    }

    private static class VisitingICollector
    extends DefaultAtomObjectVisitor {
        private Collection<AtomIVariable> variables = new HashSet<AtomIVariable>();

        public Collection<AtomIVariable> getVariables() {
            return this.variables;
        }

        @Override
        public void visit(AtomIVariable var) {
            this.variables.add(var);
        }
    }

    private static class VisitingDCollector
    extends DefaultAtomObjectVisitor {
        private Collection<AtomDVariable> variables = new HashSet<AtomDVariable>();

        public Collection<AtomDVariable> getVariables() {
            return this.variables;
        }

        @Override
        public void visit(AtomDVariable var) {
            this.variables.add(var);
        }
    }

    private static class VisitingCollector
    extends DefaultAtomObjectVisitor {
        private Collection<AtomVariable> variables = new HashSet<AtomVariable>();

        public Collection<AtomVariable> getVariables() {
            return this.variables;
        }

        @Override
        public void visit(AtomDVariable var) {
            this.variables.add(var);
        }

        @Override
        public void visit(AtomIVariable var) {
            this.variables.add(var);
        }
    }
}

