/*
 * Decompiled with CFR 0.152.
 */
package org.mindswap.pellet.utils;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;

public class StatisticsTable<ROW, COL> {
    private static final Logger log = Logger.getLogger(StatisticsTable.class.getName());
    private Map<COL, Map<ROW, Number>> statistics = new HashMap<COL, Map<ROW, Number>>();
    private List<COL> cols = new ArrayList<COL>();
    private List<ROW> rows = new ArrayList<ROW>();
    private int firstColumnSize = 10;

    public void add(ROW row, COL col, Number stat) {
        Number getStat;
        Map<ROW, Number> getCol = this.statistics.get(col);
        if (getCol == null) {
            getCol = new HashMap<ROW, Number>();
            this.statistics.put(col, getCol);
            this.cols.add(col);
        }
        if ((getStat = getCol.get(row)) != null) {
            log.warning("Overwriting [" + row + " : " + col + "].");
        } else if (!this.rows.contains(row)) {
            if (this.firstColumnSize < row.toString().length()) {
                this.firstColumnSize = row.toString().length();
            }
            this.rows.add(row);
        }
        getCol.put(row, stat);
    }

    public void add(COL col, Map<ROW, ? extends Number> stat) {
        for (Map.Entry<ROW, Number> entry : stat.entrySet()) {
            this.add(entry.getKey(), col, entry.getValue());
        }
    }

    public String toString() {
        String s = "";
        ArrayList<Integer> colSizes = new ArrayList<Integer>();
        for (COL col : this.cols) {
            colSizes.add(col.toString().length() + 2);
        }
        String firstCol = "| %1$-" + (this.firstColumnSize + 2) + "s ";
        StringBuffer lineFormat = new StringBuffer();
        int i = 1;
        while (i < colSizes.size() + 1) {
            lineFormat.append("| %").append(i).append("$-10.10s ");
            ++i;
        }
        lineFormat.append("|\n");
        char[] a = new char[String.format(lineFormat.toString(), this.cols.toArray()).length() + String.format(firstCol, "").length()];
        Arrays.fill(a, '=');
        String separator = new String(a);
        s = String.valueOf(s) + separator + "\n";
        s = String.valueOf(s) + String.format(firstCol, "") + String.format(lineFormat.toString(), this.cols.toArray());
        s = String.valueOf(s) + separator + "\n";
        for (ROW row : this.rows) {
            ArrayList<Number> rowData = new ArrayList<Number>();
            for (COL col : this.cols) {
                Map<ROW, Number> map = this.statistics.get(col);
                Number stat = map.get(row);
                if (stat == null) {
                    rowData.add(Double.POSITIVE_INFINITY);
                    continue;
                }
                rowData.add(stat);
            }
            String rowName = row.toString();
            s = String.valueOf(s) + String.format(firstCol, rowName) + String.format(lineFormat.toString(), rowData.toArray());
        }
        s = String.valueOf(s) + separator + "\n";
        return s;
    }
}

