/*
 * Decompiled with CFR 0.152.
 */
package org.mindswap.pellet.utils;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import org.mindswap.pellet.utils.AlphaNumericComparator;

public class FileUtils {
    public static boolean exists(String file) {
        return new File(file).exists();
    }

    public static String readURL(URL fileURL) throws IOException {
        return FileUtils.readAll(new InputStreamReader(fileURL.openStream()));
    }

    public static String readFile(File file) throws FileNotFoundException, IOException {
        return FileUtils.readAll(new FileReader(file));
    }

    public static String readFile(String fileName) throws FileNotFoundException, IOException {
        return FileUtils.readAll(new FileReader(fileName));
    }

    public static String readAll(Reader reader) throws IOException {
        int ch;
        StringBuffer buffer = new StringBuffer();
        BufferedReader in = new BufferedReader(reader);
        while ((ch = in.read()) > -1) {
            buffer.append((char)ch);
        }
        in.close();
        return buffer.toString();
    }

    public static String toURI(String fileName) {
        if (com.hp.hpl.jena.util.FileUtils.isURI((String)fileName)) {
            return fileName;
        }
        File localFile = new File(fileName);
        if (!localFile.exists()) {
            throw new RuntimeException(new FileNotFoundException(localFile.getAbsolutePath()));
        }
        try {
            return localFile.toURI().toURL().toExternalForm();
        }
        catch (MalformedURLException e) {
            throw new RuntimeException(String.valueOf(fileName) + " is not a valid URI");
        }
    }

    public static Collection<String> getFileURIsFromRegex(String ... fileNameRegexList) {
        ArrayList<String> uris = new ArrayList<String>();
        String[] stringArray = fileNameRegexList;
        int n = fileNameRegexList.length;
        int n2 = 0;
        while (n2 < n) {
            String fileNameRegex = stringArray[n2];
            File file = new File(fileNameRegex);
            File dir = file.getParentFile();
            if (dir != null && dir.exists()) {
                final String filter = file.getName();
                File[] files = dir.listFiles(new FilenameFilter(){

                    @Override
                    public boolean accept(File dir, String name) {
                        return dir != null && name.matches(filter);
                    }
                });
                if (files.length == 0) {
                    throw new RuntimeException("File not found: " + fileNameRegex);
                }
                Arrays.sort(files, AlphaNumericComparator.CASE_INSENSITIVE);
                File[] fileArray = files;
                int n3 = files.length;
                int n4 = 0;
                while (n4 < n3) {
                    File f = fileArray[n4];
                    uris.add(f.toURI().toString());
                    ++n4;
                }
            } else if (file.exists()) {
                uris.add(file.toURI().toString());
            } else {
                if (URI.create(fileNameRegex) == null) {
                    throw new RuntimeException(new FileNotFoundException(fileNameRegex));
                }
                uris.add(fileNameRegex);
            }
            ++n2;
        }
        return uris;
    }

    public static Collection<String> getFileURIs(String ... fileNameList) {
        ArrayList<String> uris = new ArrayList<String>();
        String[] stringArray = fileNameList;
        int n = fileNameList.length;
        int n2 = 0;
        while (n2 < n) {
            String fileName = stringArray[n2];
            uris.add(FileUtils.getFileURI(fileName));
            ++n2;
        }
        return uris;
    }

    public static String getFileURI(String fileName) {
        File file = new File(fileName);
        File dir = file.getParentFile();
        if (file.exists()) {
            return file.toURI().toString();
        }
        if (dir != null && dir.exists()) {
            throw new RuntimeException(new FileNotFoundException(fileName));
        }
        if (URI.create(fileName) == null) {
            throw new RuntimeException(new FileNotFoundException(fileName));
        }
        return fileName;
    }
}

