/*
 * Decompiled with CFR 0.152.
 */
package org.mindswap.pellet.utils;

import java.util.Comparator;

public class AlphaNumericComparator
implements Comparator<Object> {
    public static final AlphaNumericComparator CASE_SENSITIVE = new AlphaNumericComparator(true);
    public static final AlphaNumericComparator CASE_INSENSITIVE = new AlphaNumericComparator(false);
    private boolean caseSensitive;

    public AlphaNumericComparator() {
        this.caseSensitive = true;
    }

    public AlphaNumericComparator(boolean caseSensitive) {
        this.caseSensitive = caseSensitive;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public int compare(Object o1, Object o2) {
        String s1 = o1.toString();
        String s2 = o2.toString();
        int n1 = s1.length();
        int n2 = s2.length();
        int i1 = 0;
        int i2 = 0;
        while (i1 < n1 && i2 < n2) {
            char c2;
            char c1 = s1.charAt(i1);
            if (c1 != (c2 = s2.charAt(i2))) {
                if (Character.isDigit(c1)) {
                    if (!Character.isDigit(c2)) return 1;
                    int value1 = 0;
                    int value2 = 0;
                    while (i1 < n1 && Character.isDigit(c1 = s1.charAt(i1++))) {
                        value1 = 10 * value1 + (c1 - 48);
                    }
                    while (i2 < n2 && Character.isDigit(c2 = s2.charAt(i2++))) {
                        value2 = 10 * value2 + (c2 - 48);
                    }
                    if (value1 != value2) {
                        return value1 - value2;
                    }
                } else {
                    if (Character.isDigit(c2)) {
                        return -1;
                    }
                    if (this.caseSensitive) return c1 - c2;
                    if ((c1 = Character.toUpperCase(c1)) != (c2 = Character.toUpperCase(c2)) && (c1 = Character.toLowerCase(c1)) != (c2 = Character.toLowerCase(c2))) {
                        return c1 - c2;
                    }
                }
            }
            ++i1;
            ++i2;
        }
        return n1 - n2;
    }
}

