/*
 * Decompiled with CFR 0.152.
 */
package org.mindswap.pellet.tbox.impl;

import aterm.ATerm;
import aterm.ATermAppl;
import aterm.ATermList;
import com.clarkparsia.pellet.utils.CollectionUtils;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import org.mindswap.pellet.PelletOptions;
import org.mindswap.pellet.tbox.impl.TBoxBase;
import org.mindswap.pellet.tbox.impl.TBoxExpImpl;
import org.mindswap.pellet.tbox.impl.TermDefinition;
import org.mindswap.pellet.tbox.impl.Unfolding;
import org.mindswap.pellet.utils.ATermUtils;

public class TuBox
extends TBoxBase {
    private Map<ATermAppl, List<Unfolding>> unfoldingMap;
    private Collection<ATermAppl> termsToNormalize = null;

    public TuBox(TBoxExpImpl tbox) {
        super(tbox);
    }

    @Override
    public boolean addDef(ATermAppl axiom) {
        boolean added = false;
        ATermAppl name = (ATermAppl)axiom.getArgument(0);
        TermDefinition td = this.getTD((ATerm)name);
        if (td == null) {
            td = new TermDefinition();
            this.termhash.put(name, td);
        }
        if ((added = td.addDef(axiom)) && this.termsToNormalize != null) {
            this.termsToNormalize.add(name);
        }
        return added;
    }

    @Override
    public boolean removeDef(ATermAppl axiom) {
        boolean removed = super.removeDef(axiom);
        if (removed && this.termsToNormalize != null) {
            this.termsToNormalize.add((ATermAppl)axiom.getArgument(0));
        }
        return removed;
    }

    public void updateDef(ATermAppl axiom) {
        ATermAppl c = (ATermAppl)axiom.getArgument(0);
        if (ATermUtils.isPrimitive(c)) {
            this.termsToNormalize.add(c);
        }
    }

    public List<Unfolding> unfold(ATermAppl c) {
        List<Unfolding> list = this.unfoldingMap.get(c);
        return list != null ? list : Collections.emptyList();
    }

    public void normalize() {
        if (this.termsToNormalize == null) {
            this.termsToNormalize = this.termhash.keySet();
            this.unfoldingMap = CollectionUtils.makeIdentityMap();
        } else if (log.isLoggable(Level.FINE)) {
            log.fine("Normalizing " + this.termsToNormalize);
        }
        for (ATermAppl c : this.termsToNormalize) {
            TermDefinition td = (TermDefinition)this.termhash.get(c);
            td.clearDependencies();
            ATermAppl notC = ATermUtils.makeNot((ATerm)c);
            ArrayList<Unfolding> unfoldC = new ArrayList<Unfolding>();
            if (!td.getEqClassAxioms().isEmpty()) {
                ArrayList<Unfolding> unfoldNotC = new ArrayList<Unfolding>();
                for (ATermAppl eqClassAxiom : td.getEqClassAxioms()) {
                    ATermAppl unfolded = (ATermAppl)eqClassAxiom.getArgument(1);
                    Set<ATermAppl> ds = this.tbox.getAxiomExplanation(eqClassAxiom);
                    ATermAppl normalized = ATermUtils.normalize(unfolded);
                    ATermAppl normalizedNot = ATermUtils.negate(normalized);
                    unfoldC.add(Unfolding.create(normalized, ds));
                    unfoldNotC.add(Unfolding.create(normalizedNot, ds));
                }
                this.unfoldingMap.put(notC, unfoldNotC);
            } else {
                this.unfoldingMap.remove(notC);
            }
            for (ATermAppl subClassAxiom : td.getSubClassAxioms()) {
                ATermAppl unfolded = (ATermAppl)subClassAxiom.getArgument(1);
                Set<ATermAppl> ds = this.tbox.getAxiomExplanation(subClassAxiom);
                ATermAppl normalized = ATermUtils.normalize(unfolded);
                unfoldC.add(Unfolding.create(normalized, ds));
            }
            if (!unfoldC.isEmpty()) {
                this.unfoldingMap.put(c, unfoldC);
                continue;
            }
            this.unfoldingMap.remove(c);
        }
        this.termsToNormalize = new HashSet<ATermAppl>();
        if (PelletOptions.USE_ROLE_ABSORPTION) {
            this.absorbRanges(this.tbox);
        }
    }

    private void absorbRanges(TBoxExpImpl tbox) {
        List<Unfolding> unfoldTop = this.unfoldingMap.get(ATermUtils.TOP);
        if (unfoldTop == null) {
            return;
        }
        ArrayList<Unfolding> newUnfoldTop = new ArrayList<Unfolding>();
        for (Unfolding unfolding : unfoldTop) {
            ATermAppl unfolded = unfolding.getResult();
            Set<ATermAppl> explain = unfolding.getExplanation();
            if (ATermUtils.isAllValues(unfolded)) {
                ATerm r = unfolded.getArgument(0);
                ATermAppl range = (ATermAppl)unfolded.getArgument(1);
                this.kb.addRange(r, range, explain);
                tbox.getAbsorbedAxioms().addAll(explain);
                continue;
            }
            if (ATermUtils.isAnd(unfolded)) {
                ATermList l = (ATermList)unfolded.getArgument(0);
                ATermList newList = ATermUtils.EMPTY_LIST;
                while (!l.isEmpty()) {
                    ATermAppl term = (ATermAppl)l.getFirst();
                    if (term.getAFun().equals((Object)ATermUtils.ALLFUN)) {
                        ATerm r = term.getArgument(0);
                        ATermAppl range = (ATermAppl)term.getArgument(1);
                        this.kb.addRange(r, range, explain);
                        tbox.getAbsorbedAxioms().addAll(explain);
                    } else {
                        newList = newList.insert((ATerm)term);
                    }
                    l = l.getNext();
                }
                if (newList.isEmpty()) continue;
                newUnfoldTop.add(Unfolding.create(ATermUtils.makeAnd(newList), explain));
                continue;
            }
            newUnfoldTop.add(unfolding);
        }
        if (newUnfoldTop.isEmpty()) {
            this.unfoldingMap.remove(ATermUtils.TOP);
        }
    }

    public boolean addIfUnfoldable(ATermAppl term) {
        ATermAppl name = (ATermAppl)term.getArgument(0);
        ATermAppl body = (ATermAppl)term.getArgument(1);
        TermDefinition td = this.getTD((ATerm)name);
        if (!ATermUtils.isPrimitive(name)) {
            return false;
        }
        if (td == null) {
            td = new TermDefinition();
        }
        if (!td.isUnique(term)) {
            return false;
        }
        Set<ATermAppl> dependencies = ATermUtils.findPrimitives(body);
        HashSet<ATermAppl> seen = new HashSet<ATermAppl>();
        if (!td.getDependencies().containsAll(dependencies)) {
            for (ATermAppl current : dependencies) {
                boolean result = this.findTarget(current, name, seen);
                if (!result) continue;
                return false;
            }
        }
        boolean added = this.addDef(term);
        return added;
    }

    protected boolean findTarget(ATermAppl term, ATermAppl target, Set<ATermAppl> seen) {
        ArrayList<ATermAppl> queue = new ArrayList<ATermAppl>();
        queue.add(term);
        while (!queue.isEmpty()) {
            this.kb.timers.checkTimer("preprocessing");
            ATermAppl current = (ATermAppl)queue.remove(queue.size() - 1);
            if (!seen.add(current)) continue;
            if (current.equals((Object)target)) {
                return true;
            }
            TermDefinition td = this.getTD((ATerm)current);
            if (td == null) continue;
            if (td.getDependencies().contains(target)) {
                return true;
            }
            queue.addAll(td.getDependencies());
        }
        return false;
    }

    public void print(Appendable out) {
        try {
            out.append("Tu: [\n");
            for (ATermAppl c : this.unfoldingMap.keySet()) {
                List<Unfolding> unfoldedList = this.unfold(c);
                if (unfoldedList.isEmpty()) continue;
                out.append(ATermUtils.toString(c)).append(" -> ");
                for (Unfolding unf : unfoldedList) {
                    out.append(ATermUtils.toString(unf.getResult())).append(", ");
                }
                out.append("\n");
            }
            out.append("]\n");
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void print() {
        this.print(System.out);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        this.print(sb);
        return sb.toString();
    }
}

