/*
 * Decompiled with CFR 0.152.
 */
package org.mindswap.pellet.tbox.impl;

import aterm.ATermAppl;
import com.clarkparsia.pellet.utils.CollectionUtils;
import com.clarkparsia.pellet.utils.TermFactory;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.mindswap.pellet.tbox.impl.Unfolding;
import org.mindswap.pellet.utils.ATermUtils;
import org.mindswap.pellet.utils.iterator.IteratorUtils;

public class PrimitiveTBox {
    public static final Logger log = Logger.getLogger(PrimitiveTBox.class.getName());
    private Map<ATermAppl, Unfolding> definitions = CollectionUtils.makeIdentityMap();
    private Map<ATermAppl, Set<ATermAppl>> dependencies = CollectionUtils.makeIdentityMap();

    public boolean contains(ATermAppl concept) {
        return this.definitions.containsKey(concept);
    }

    public Unfolding getDefinition(ATermAppl concept) {
        return this.definitions.get(concept);
    }

    public boolean add(ATermAppl concept, ATermAppl definition, Set<ATermAppl> explanation) {
        if (!ATermUtils.isPrimitive(concept) || this.contains(concept)) {
            return false;
        }
        Set<ATermAppl> deps = ATermUtils.findPrimitives(definition);
        HashSet<ATermAppl> seen = new HashSet<ATermAppl>();
        for (ATermAppl current : deps) {
            boolean result = this.findTarget(current, concept, seen);
            if (!result) continue;
            return false;
        }
        this.addDefinition(concept, definition, explanation);
        this.addDefinition(TermFactory.not(concept), TermFactory.not(definition), explanation);
        this.dependencies.put(concept, deps);
        return true;
    }

    protected void addDefinition(ATermAppl concept, ATermAppl definition, Set<ATermAppl> explanation) {
        definition = ATermUtils.normalize(definition);
        if (log.isLoggable(Level.FINE)) {
            log.fine("Def: " + ATermUtils.toString(concept) + " = " + ATermUtils.toString(definition));
        }
        this.definitions.put(concept, Unfolding.create(definition, explanation));
    }

    protected boolean findTarget(ATermAppl term, ATermAppl target, Set<ATermAppl> seen) {
        ArrayList<ATermAppl> queue = new ArrayList<ATermAppl>();
        queue.add(term);
        while (!queue.isEmpty()) {
            ATermAppl current = (ATermAppl)queue.remove(queue.size() - 1);
            if (!seen.add(current)) continue;
            if (current.equals((Object)target)) {
                return true;
            }
            Set<ATermAppl> deps = this.dependencies.get(current);
            if (deps == null) continue;
            if (deps.contains(target)) {
                return true;
            }
            queue.addAll(deps);
        }
        return false;
    }

    public boolean remove(ATermAppl axiom) {
        return false;
    }

    public Iterator<Unfolding> unfold(ATermAppl concept) {
        Unfolding unfolding = this.definitions.get(concept);
        return unfolding == null ? IteratorUtils.emptyIterator() : IteratorUtils.singletonIterator(unfolding);
    }

    public void print(Appendable out) throws IOException {
        for (Map.Entry<ATermAppl, Unfolding> e : this.definitions.entrySet()) {
            out.append(ATermUtils.toString(e.getKey()));
            out.append(" = ");
            out.append(e.getValue().toString());
            out.append("\n");
        }
    }
}

