/*
 * Decompiled with CFR 0.152.
 */
package org.mindswap.pellet.tableau.completion.rule;

import aterm.ATerm;
import aterm.ATermAppl;
import aterm.ATermInt;
import java.util.List;
import org.mindswap.pellet.DependencySet;
import org.mindswap.pellet.Edge;
import org.mindswap.pellet.EdgeList;
import org.mindswap.pellet.Individual;
import org.mindswap.pellet.Role;
import org.mindswap.pellet.tableau.branch.GuessBranch;
import org.mindswap.pellet.tableau.completion.CompletionStrategy;
import org.mindswap.pellet.tableau.completion.queue.NodeSelector;
import org.mindswap.pellet.tableau.completion.rule.AbstractTableauRule;
import org.mindswap.pellet.utils.ATermUtils;

public class GuessRule
extends AbstractTableauRule {
    public GuessRule(CompletionStrategy strategy) {
        super(strategy, NodeSelector.GUESS, AbstractTableauRule.BlockingType.NONE);
    }

    @Override
    public void apply(Individual x) {
        if (x.isBlockable()) {
            return;
        }
        List<ATermAppl> types = x.getTypes(5);
        int size = types.size();
        int j = 0;
        while (j < size) {
            ATermAppl mc = types.get(j);
            this.applyGuessingRule(x, mc);
            if (this.strategy.getABox().isClosed()) {
                return;
            }
            ++j;
        }
    }

    private void applyGuessingRule(Individual x, ATermAppl mc) {
        ATermAppl max = (ATermAppl)mc.getArgument(0);
        Role r = this.strategy.getABox().getRole(max.getArgument(0));
        int n = ((ATermInt)max.getArgument(1)).getInt() - 1;
        ATermAppl c = (ATermAppl)max.getArgument(2);
        if (r.isDatatypeRole()) {
            return;
        }
        boolean apply = false;
        EdgeList edges = x.getRPredecessorEdges(r.getInverse());
        int e = 0;
        while (e < edges.size()) {
            Edge edge = edges.edgeAt(e);
            Individual pred = edge.getFrom();
            if (pred.isBlockable()) {
                apply = true;
                break;
            }
            ++e;
        }
        if (!apply) {
            return;
        }
        if (x.getMaxCard(r) < n) {
            return;
        }
        if (x.hasDistinctRNeighborsForMin(r, n, ATermUtils.TOP, true)) {
            return;
        }
        int guessMin = x.getMinCard(r, c);
        if (guessMin == 0) {
            guessMin = 1;
        }
        DependencySet ds = x.getDepends((ATerm)mc);
        edges = x.getRNeighborEdges(r);
        int e2 = 0;
        while (e2 < edges.size()) {
            Edge edge = edges.edgeAt(e2);
            ds = ds.union(edge.getDepends(), this.strategy.getABox().doExplanation());
            ++e2;
        }
        GuessBranch newBranch = new GuessBranch(this.strategy.getABox(), this.strategy, x, r, guessMin, n, c, ds);
        this.strategy.addBranch(newBranch);
        newBranch.tryNext();
    }
}

