/*
 * Decompiled with CFR 0.152.
 */
package org.mindswap.pellet.tableau.completion.rule;

import com.clarkparsia.pellet.datatypes.exceptions.DatatypeReasonerException;
import com.clarkparsia.pellet.datatypes.exceptions.InvalidLiteralException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Set;
import org.mindswap.pellet.Clash;
import org.mindswap.pellet.DependencySet;
import org.mindswap.pellet.Edge;
import org.mindswap.pellet.Individual;
import org.mindswap.pellet.Literal;
import org.mindswap.pellet.Node;
import org.mindswap.pellet.PelletOptions;
import org.mindswap.pellet.Role;
import org.mindswap.pellet.exceptions.InternalReasonerException;
import org.mindswap.pellet.tableau.completion.CompletionStrategy;
import org.mindswap.pellet.tableau.completion.queue.NodeSelector;
import org.mindswap.pellet.tableau.completion.rule.AbstractTableauRule;

public class DataSatisfiabilityRule
extends AbstractTableauRule {
    public DataSatisfiabilityRule(CompletionStrategy strategy) {
        super(strategy, NodeSelector.DATATYPE, AbstractTableauRule.BlockingType.NONE);
    }

    /*
     * Could not resolve type clashes
     * Unable to fully structure code
     */
    @Override
    public void apply(Individual ind) {
        block18: {
            nodes = new HashSet<Literal>();
            pending = new LinkedList<Literal>();
            ne = new HashMap<Literal, Set<Literal>>();
            ds = DependencySet.EMPTY;
            nePresent = false;
            for (Edge e : ind.getOutEdges()) {
                r = e.getRole();
                if (!r.isDatatypeRole()) continue;
                ds = ds.union(e.getDepends(), this.strategy.getABox().doExplanation());
                l = (Literal)e.getTo();
                pending.add(l);
                disj = (HashSet<Literal>)ne.get(l);
                for (Role s : r.getDisjointRoles()) {
                    for (Edge f : ind.getOutEdges().getEdges(s)) {
                        k = (Literal)f.getTo();
                        if (disj == null) {
                            disj = new HashSet<Literal>();
                            ne.put(l, disj);
                            nePresent = true;
                        }
                        disj.add(k);
                    }
                }
            }
            while (!pending.isEmpty()) {
                l = (Literal)pending.removeFirst();
                if (!nodes.add(l)) continue;
                disj = (Set)ne.get(l);
                for (Node n : l.getDifferents()) {
                    if (n.isLiteral()) {
                        k = (Literal)n;
                        pending.add(k);
                        if (disj == null) {
                            disj = new HashSet<Literal>();
                            ne.put(l, disj);
                            nePresent = true;
                        }
                        disj.add(k);
                        ds = ds.union(l.getDifferenceDependency(n), this.strategy.getABox().doExplanation());
                        continue;
                    }
                    throw new IllegalStateException();
                }
            }
            if (nePresent) {
                block17: {
                    try {
                        if (!this.strategy.getABox().getDatatypeReasoner().isSatisfiable(nodes, ne)) {
                            for (Node n : nodes) {
                                for (DependencySet typeDep : n.getDepends().values()) {
                                    ds = ds.union(typeDep, this.strategy.getABox().doExplanation());
                                }
                            }
                            this.strategy.getABox().setClash(Clash.unexplained(ind, ds));
                        }
                    }
                    catch (InvalidLiteralException e) {
                        msg = "Invalid literal encountered during satisfiability check: " + e.getMessage();
                        if (!PelletOptions.INVALID_LITERAL_AS_INCONSISTENCY) break block17;
                        DataSatisfiabilityRule.log.fine(msg);
                        ** for (n : nodes)
                    }
lbl-1000:
                    // 2 sources

                    {
                        for (DependencySet typeDep : n.getDepends().values()) {
                            ds = ds.union(typeDep, this.strategy.getABox().doExplanation());
                        }
                        continue;
                    }
lbl66:
                    // 1 sources

                    this.strategy.getABox().setClash(Clash.invalidLiteral(ind, ds));
                    break block18;
                }
                DataSatisfiabilityRule.log.severe(msg);
                throw new InternalReasonerException(msg, e);
                catch (DatatypeReasonerException e) {
                    msg = "Unexpected datatype reasoner exception: " + e.getMessage();
                    DataSatisfiabilityRule.log.severe(msg);
                    throw new InternalReasonerException(msg, e);
                }
            }
        }
    }
}

