/*
 * Decompiled with CFR 0.152.
 */
package org.mindswap.pellet.tableau.completion.queue;

import aterm.ATerm;
import aterm.ATermAppl;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.mindswap.pellet.ABox;
import org.mindswap.pellet.Individual;
import org.mindswap.pellet.Node;
import org.mindswap.pellet.tableau.completion.queue.CompletionQueue;
import org.mindswap.pellet.tableau.completion.queue.NodeSelector;
import org.mindswap.pellet.tableau.completion.queue.QueueElement;

public class BasicCompletionQueue
extends CompletionQueue {
    protected List<ATermAppl> queue = new ArrayList<ATermAppl>();
    protected Set<ATermAppl> newQueue = new HashSet<ATermAppl>();
    protected List<ATermAppl> newQueueList = new ArrayList<ATermAppl>();
    protected int current = 0;
    protected int end = 0;
    protected int cutOff = 0;
    protected boolean backtracked = false;

    public BasicCompletionQueue(ABox abox) {
        super(abox);
    }

    @Override
    protected void findNext(int type) {
        while (this.current < this.cutOff) {
            Node node = this.abox.getNode((ATerm)this.queue.get(this.current));
            if (node != null && ((node = node.getSame()).isLiteral() && this.allowLiterals() || node.isIndividual() && !this.allowLiterals()) && !node.isPruned()) break;
            ++this.current;
        }
    }

    @Override
    public boolean hasNext() {
        this.findNext(-1);
        return this.current < this.cutOff;
    }

    @Override
    public void restore(int branch) {
        this.queue.addAll(this.newQueueList);
        this.newQueue.clear();
        this.newQueueList.clear();
        this.end = this.queue.size();
        this.current = 0;
        this.cutOff = this.end;
        this.backtracked = true;
    }

    @Override
    public Individual next() {
        this.findNext(-1);
        Individual ind = this.abox.getIndividual((ATerm)this.queue.get(this.current));
        ind = ind.getSame();
        ++this.current;
        return ind;
    }

    @Override
    public Node nextLiteral() {
        this.findNext(-1);
        Node node = this.abox.getNode((ATerm)this.queue.get(this.current));
        node = node.getSame();
        ++this.current;
        return node;
    }

    @Override
    public void add(QueueElement x, NodeSelector s) {
        this.add(x);
    }

    @Override
    public void add(QueueElement x) {
        if (!this.newQueue.contains(x.getNode())) {
            this.newQueue.add(x.getNode());
            this.newQueueList.add(x.getNode());
        }
    }

    @Override
    public void reset(NodeSelector s) {
        this.cutOff = this.end;
        this.current = 0;
    }

    @Override
    public void incrementBranch(int branch) {
    }

    @Override
    public BasicCompletionQueue copy() {
        BasicCompletionQueue copy = new BasicCompletionQueue(this.abox);
        copy.queue = new ArrayList<ATermAppl>(this.queue);
        copy.newQueue = new HashSet<ATermAppl>(this.newQueue);
        copy.newQueueList = new ArrayList<ATermAppl>(this.newQueueList);
        copy.current = this.current;
        copy.cutOff = this.cutOff;
        copy.backtracked = this.backtracked;
        copy.end = this.end;
        copy.setAllowLiterals(this.allowLiterals());
        return copy;
    }

    @Override
    public void setABox(ABox ab) {
        this.abox = ab;
    }

    @Override
    public void print(int type) {
        System.out.println("Queue: " + this.queue);
    }

    @Override
    public void print() {
        System.out.println("Queue: " + this.queue);
    }

    @Override
    public void remove() {
        throw new RuntimeException("Remove is not supported");
    }

    @Override
    public void flushQueue() {
        if (!this.backtracked && !this.closed) {
            this.queue.clear();
        } else if (this.closed && !this.abox.isClosed()) {
            this.closed = false;
        }
        this.queue.addAll(this.newQueueList);
        this.newQueue.clear();
        this.newQueueList.clear();
        this.end = this.queue.size();
        this.backtracked = false;
    }

    @Override
    protected void flushQueue(NodeSelector s) {
    }

    @Override
    public void clearQueue(NodeSelector s) {
    }
}

