/*
 * Decompiled with CFR 0.152.
 */
package org.mindswap.pellet.tableau.branch;

import aterm.ATerm;
import aterm.ATermAppl;
import java.util.HashSet;
import java.util.logging.Level;
import org.mindswap.pellet.ABox;
import org.mindswap.pellet.Clash;
import org.mindswap.pellet.DependencySet;
import org.mindswap.pellet.Individual;
import org.mindswap.pellet.Node;
import org.mindswap.pellet.PelletOptions;
import org.mindswap.pellet.exceptions.InternalReasonerException;
import org.mindswap.pellet.tableau.branch.Branch;
import org.mindswap.pellet.tableau.completion.CompletionStrategy;
import org.mindswap.pellet.utils.ATermUtils;

public class DisjunctionBranch
extends Branch {
    protected Node node;
    protected ATermAppl disjunction;
    private ATermAppl[] disj;
    protected DependencySet[] prevDS;
    protected int[] order;

    public DisjunctionBranch(ABox abox, CompletionStrategy completion, Node node, ATermAppl disjunction, DependencySet ds, ATermAppl[] disj) {
        super(abox, completion, ds, disj.length);
        this.node = node;
        this.disjunction = disjunction;
        this.setDisj(disj);
        this.prevDS = new DependencySet[disj.length];
        this.order = new int[disj.length];
        int i = 0;
        while (i < disj.length) {
            this.order[i] = i;
            ++i;
        }
    }

    @Override
    public Node getNode() {
        return this.node;
    }

    protected String getDebugMsg() {
        return "DISJ: Branch (" + this.getBranch() + ") try (" + (this.getTryNext() + 1) + "/" + this.getTryCount() + ") " + this.node + " " + ATermUtils.toString(this.disj[this.getTryNext()]) + " " + ATermUtils.toString(this.disjunction);
    }

    @Override
    public DisjunctionBranch copyTo(ABox abox) {
        Node n = abox.getNode((ATerm)this.node.getName());
        DisjunctionBranch b = new DisjunctionBranch(abox, null, n, this.disjunction, this.getTermDepends(), this.disj);
        b.setAnonCount(this.anonCount);
        b.setNodeCount(this.nodeCount);
        b.setBranch(this.branch);
        b.setStrategy(this.strategy);
        b.setTryNext(this.tryNext);
        b.prevDS = new DependencySet[this.disj.length];
        System.arraycopy(this.prevDS, 0, b.prevDS, 0, this.disj.length);
        b.order = new int[this.disj.length];
        System.arraycopy(this.order, 0, b.order, 0, this.disj.length);
        return b;
    }

    private int preferredDisjunct() {
        if (this.disj.length != 2) {
            return -1;
        }
        if (ATermUtils.isPrimitive(this.disj[0]) && ATermUtils.isAllValues(this.disj[1]) && ATermUtils.isNot((ATermAppl)this.disj[1].getArgument(1))) {
            return 1;
        }
        if (ATermUtils.isPrimitive(this.disj[1]) && ATermUtils.isAllValues(this.disj[0]) && ATermUtils.isNot((ATermAppl)this.disj[0].getArgument(1))) {
            return 0;
        }
        return -1;
    }

    @Override
    public void setLastClash(DependencySet ds) {
        super.setLastClash(ds);
        if (this.getTryNext() >= 0) {
            this.prevDS[this.getTryNext()] = ds;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    protected void tryBranch() {
        this.abox.incrementBranch();
        int[] stats = null;
        if (PelletOptions.USE_DISJUNCT_SORTING) {
            stats = this.abox.getDisjBranchStats().get(this.disjunction);
            if (stats == null) {
                int preference = this.preferredDisjunct();
                stats = new int[this.disj.length];
                int i = 0;
                while (i < this.disj.length) {
                    stats[i] = i != preference ? 0 : Integer.MIN_VALUE;
                    ++i;
                }
                this.abox.getDisjBranchStats().put(this.disjunction, stats);
            }
            if (this.getTryNext() > 0) {
                int n = this.order[this.getTryNext() - 1];
                stats[n] = stats[n] + 1;
            }
            if (stats != null) {
                int minIndex = this.getTryNext();
                int minValue = stats[this.getTryNext()];
                int i = this.getTryNext() + 1;
                while (i < stats.length) {
                    boolean tryEarlier;
                    boolean bl = tryEarlier = stats[i] < minValue;
                    if (tryEarlier) {
                        minIndex = i;
                        minValue = stats[i];
                    }
                    ++i;
                }
                if (minIndex != this.getTryNext()) {
                    ATermAppl selDisj = this.disj[minIndex];
                    this.disj[minIndex] = this.disj[this.getTryNext()];
                    this.disj[this.getTryNext()] = selDisj;
                    this.order[minIndex] = this.getTryNext();
                    this.order[this.getTryNext()] = minIndex;
                }
            }
        }
        Node node = this.node.getSame();
        while (this.getTryNext() < this.getTryCount()) {
            DependencySet clashDepends;
            ATermAppl d = this.disj[this.getTryNext()];
            if (PelletOptions.USE_SEMANTIC_BRANCHING) {
                int m = 0;
                while (m < this.getTryNext()) {
                    this.strategy.addType(node, ATermUtils.negate(this.disj[m]), this.prevDS[m]);
                    ++m;
                }
            }
            DependencySet ds = null;
            if (this.getTryNext() == this.getTryCount() - 1 && !PelletOptions.SATURATE_TABLEAU) {
                ds = this.getTermDepends();
                int m = 0;
                while (m < this.getTryNext()) {
                    ds = ds.union(this.prevDS[m], this.abox.doExplanation());
                    ++m;
                }
                if (PelletOptions.USE_INCREMENTAL_DELETION) {
                    ds.setExplain(this.getTermDepends().getExplain());
                } else {
                    ds.remove(this.getBranch());
                }
            } else if (PelletOptions.USE_INCREMENTAL_DELETION) {
                ds = this.getTermDepends().union(new DependencySet(this.getBranch()), this.abox.doExplanation());
            } else {
                ds = new DependencySet(this.getBranch());
                HashSet<ATermAppl> explain = new HashSet<ATermAppl>();
                explain.addAll(this.getTermDepends().getExplain());
                ds.setExplain(explain);
            }
            if (log.isLoggable(Level.FINE)) {
                log.fine(this.getDebugMsg());
            }
            ATermAppl notD = ATermUtils.negate(d);
            DependencySet dependencySet = clashDepends = PelletOptions.SATURATE_TABLEAU ? null : node.getDepends((ATerm)notD);
            if (clashDepends == null) {
                this.strategy.addType(node, d, ds);
                if (this.abox.isClosed()) {
                    clashDepends = this.abox.getClash().getDepends();
                }
            } else {
                clashDepends = clashDepends.union(ds, this.abox.doExplanation());
            }
            if (clashDepends == null) return;
            if (log.isLoggable(Level.FINE)) {
                Clash clash = this.abox.isClosed() ? this.abox.getClash() : Clash.atomic(node, clashDepends, d);
                log.fine("CLASH: Branch " + this.getBranch() + " " + clash + "!" + " " + clashDepends.getExplain());
            }
            if (PelletOptions.USE_DISJUNCT_SORTING) {
                if (stats == null) {
                    stats = new int[this.disj.length];
                    int i = 0;
                    while (i < this.disj.length) {
                        stats[i] = 0;
                        ++i;
                    }
                    this.abox.getDisjBranchStats().put(this.disjunction, stats);
                }
                int n = this.order[this.getTryNext()];
                stats[n] = stats[n] + 1;
            }
            if (this.getTryNext() < this.getTryCount() - 1 && clashDepends.contains(this.getBranch())) {
                if (this.abox.isClosed()) {
                    if (node.isLiteral()) {
                        this.abox.setClash(null);
                        node.restore(this.branch);
                    } else {
                        this.strategy.restoreLocal((Individual)node, this);
                        this.abox.incrementBranch();
                    }
                }
            } else {
                if (this.abox.doExplanation()) {
                    ATermAppl positive = ATermUtils.isNot(notD) ? d : notD;
                    this.abox.setClash(Clash.atomic(node, clashDepends.union(ds, this.abox.doExplanation()), positive));
                } else {
                    this.abox.setClash(Clash.atomic(node, clashDepends.union(ds, this.abox.doExplanation())));
                }
                if (!PelletOptions.USE_INCREMENTAL_DELETION) return;
                this.abox.getKB().getDependencyIndex().addCloseBranchDependency(this, this.abox.getClash().getDepends());
                return;
            }
            this.setLastClash(clashDepends);
            ++this.tryNext;
        }
        throw new InternalReasonerException("This exception should not be thrown!");
    }

    @Override
    public void shiftTryNext(int openIndex) {
        ATermAppl dis = this.disj[openIndex];
        int i = openIndex;
        while (i < this.disj.length - 1) {
            this.disj[i] = this.disj[i + 1];
            this.prevDS[i] = this.prevDS[i + 1];
            this.order[i] = this.order[i];
            ++i;
        }
        this.disj[this.disj.length - 1] = dis;
        this.prevDS[this.disj.length - 1] = null;
        this.order[this.disj.length - 1] = this.disj.length - 1;
        this.setTryNext(this.getTryNext() - 1);
    }

    public void printLong() {
        int i = 0;
        while (i < this.disj.length) {
            System.out.println("Disj[" + i + "] " + this.disj[i]);
            System.out.println("prevDS[" + i + "] " + this.prevDS[i]);
            System.out.println("order[" + i + "] " + this.order[i]);
            ++i;
        }
        System.out.println("trynext: " + this.getTryNext());
    }

    public void setDisj(ATermAppl[] disj) {
        this.disj = disj;
    }

    public ATermAppl getDisjunct(int i) {
        return this.disj[i];
    }
}

