/*
 * Decompiled with CFR 0.152.
 */
package org.mindswap.pellet.output;

import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;

public class TableData {
    Collection data;
    List colNames;
    boolean[] rightAligned;
    int[] colWidths = null;
    String colSep = " | ";

    public TableData(Collection data, List colNames) {
        this.data = data;
        this.colNames = colNames;
        int cols = colNames.size();
        this.colWidths = new int[cols];
        this.rightAligned = new boolean[cols];
    }

    public TableData(List colNames) {
        this.data = new ArrayList();
        this.colNames = colNames;
        int cols = colNames.size();
        this.colWidths = new int[cols];
        this.rightAligned = new boolean[cols];
    }

    public TableData(String[] colNames) {
        this(Arrays.asList(colNames));
    }

    public void setAlignment(boolean[] rightAligned) {
        if (rightAligned.length != this.colNames.size()) {
            throw new IllegalArgumentException("Alignment has " + rightAligned.length + " elements but table has " + this.colNames.size() + " columns");
        }
        this.rightAligned = rightAligned;
    }

    public void setrightAligned(int colIndex, boolean rightAligned) {
        this.rightAligned[colIndex] = rightAligned;
    }

    public void addRow(List row) {
        this.add(row);
    }

    public void add(List row) {
        if (row.size() != this.colNames.size()) {
            throw new IllegalArgumentException("Row has " + row.size() + " elements but table has " + this.colNames.size() + " columns");
        }
        this.data.add(row);
    }

    public void print(OutputStream writer) {
        this.print(new PrintWriter(writer));
    }

    public void print(PrintWriter out) {
        this.printText(out);
    }

    public void print(Writer writer) {
        this.printText(writer);
    }

    private void printText(Writer writer) {
        PrintWriter pw = writer instanceof PrintWriter ? (PrintWriter)writer : new PrintWriter(writer);
        this.computeHeaderWidths();
        this.computeRowWidths();
        int lineWidth = this.computeLineWidth();
        int numCols = this.colNames.size();
        String[] row = new String[numCols];
        int col = 0;
        while (col < row.length) {
            row[col] = this.colNames.get(col).toString();
            ++col;
        }
        this.printRow(pw, row);
        int i = 0;
        while (i < lineWidth) {
            pw.print('=');
            ++i;
        }
        pw.println();
        for (Collection rowData : this.data) {
            Iterator j = rowData.iterator();
            int col2 = 0;
            while (j.hasNext()) {
                Object value = j.next();
                row[col2] = value == null ? "<null>" : value.toString();
                ++col2;
            }
            this.printRow(pw, row);
        }
        pw.flush();
    }

    private void printRow(PrintWriter pw, String[] row) {
        int col = 0;
        while (col < row.length) {
            String s = row[col];
            int pad = this.colWidths[col];
            StringBuffer sbuff = new StringBuffer(120);
            if (col > 0) {
                sbuff.append(this.colSep);
            }
            if (!this.rightAligned[col]) {
                sbuff.append(s);
            }
            int j = 0;
            while (j < pad - s.length()) {
                sbuff.append(' ');
                ++j;
            }
            if (this.rightAligned[col]) {
                sbuff.append(s);
            }
            pw.print(sbuff);
            ++col;
        }
        pw.println();
    }

    private int computeLineWidth() {
        int numCols = this.colWidths.length;
        int lineWidth = 0;
        int i = 0;
        while (i < numCols) {
            lineWidth += this.colWidths[i];
            ++i;
        }
        return lineWidth += (numCols - 1) * this.colSep.length();
    }

    private void computeHeaderWidths() {
        Iterator k = this.colNames.iterator();
        int col = 0;
        while (k.hasNext()) {
            Object value = k.next();
            String str = value == null ? "<null>" : value.toString();
            this.colWidths[col] = str.length();
            ++col;
        }
    }

    private void computeRowWidths() {
        for (Collection rowData : this.data) {
            Iterator j = rowData.iterator();
            int col = 0;
            while (j.hasNext()) {
                String str;
                Object value = j.next();
                String string = str = value == null ? "<null>" : value.toString();
                if (this.colWidths[col] < str.length()) {
                    this.colWidths[col] = str.length();
                }
                ++col;
            }
        }
    }

    public int getRowCount() {
        return this.data.size();
    }

    public int getColCount() {
        return this.colNames.size();
    }

    public void sort(String colName) {
        this.sort(this.colNames.indexOf(colName));
    }

    public void sort(final int col) {
        Object[] a = this.data.toArray();
        Arrays.sort(a, new Comparator(){

            public int compare(Object l1, Object l2) {
                return ((Comparable)((List)l1).get(col)).compareTo(((List)l2).get(col));
            }
        });
        this.data = Arrays.asList(a);
    }

    public void sort(final int col, final Comparator c) {
        Object[] a = this.data.toArray();
        Arrays.sort(a, new Comparator(){

            public int compare(Object l1, Object l2) {
                return c.compare(((List)l1).get(col), ((List)l2).get(col));
            }
        });
        this.data = Arrays.asList(a);
    }

    public String toString() {
        StringWriter sw = new StringWriter();
        this.printText(sw);
        return sw.toString();
    }
}

