/*
 * Decompiled with CFR 0.152.
 */
package org.mindswap.pellet.output;

import aterm.ATermAppl;
import aterm.ATermInt;
import aterm.ATermList;
import com.clarkparsia.pellet.datatypes.Facet;
import com.clarkparsia.pellet.datatypes.types.floating.XSDFloat;
import com.clarkparsia.pellet.datatypes.types.real.XSDDecimal;
import com.clarkparsia.pellet.datatypes.types.real.XSDInteger;
import java.util.HashMap;
import java.util.Map;
import org.mindswap.pellet.output.ATermBaseRenderer;
import org.mindswap.pellet.utils.ATermUtils;

public class ATermManchesterSyntaxRenderer
extends ATermBaseRenderer {
    public static final Map<ATermAppl, String> FACETS = new HashMap<ATermAppl, String>();

    static {
        FACETS.put(Facet.XSD.LENGTH.getName(), "length");
        FACETS.put(Facet.XSD.MIN_LENGTH.getName(), "minLength");
        FACETS.put(Facet.XSD.MAX_LENGTH.getName(), "maxLength");
        FACETS.put(Facet.XSD.PATTERN.getName(), "pattern");
        FACETS.put(Facet.XSD.MIN_INCLUSIVE.getName(), ">=");
        FACETS.put(Facet.XSD.MIN_EXCLUSIVE.getName(), ">");
        FACETS.put(Facet.XSD.MAX_INCLUSIVE.getName(), "<=");
        FACETS.put(Facet.XSD.MAX_EXCLUSIVE.getName(), "<");
    }

    @Override
    public void visitAll(ATermAppl term) {
        this.out.print("(");
        this.visit((ATermAppl)term.getArgument(0));
        this.out.print(" only ");
        this.visit((ATermAppl)term.getArgument(1));
        this.out.print(")");
    }

    @Override
    public void visitAnd(ATermAppl term) {
        this.out.print("(");
        this.visitList((ATermList)term.getArgument(0), "and");
        this.out.print(")");
    }

    @Override
    public void visitCard(ATermAppl term) {
        this.out.print("(");
        this.visit((ATermAppl)term.getArgument(0));
        this.out.print(" exactly " + ((ATermInt)term.getArgument(1)).getInt());
        this.out.print(")");
    }

    @Override
    public void visitHasValue(ATermAppl term) {
        this.out.print("(");
        this.visit((ATermAppl)term.getArgument(0));
        this.out.print(" value ");
        ATermAppl value = (ATermAppl)((ATermAppl)term.getArgument(1)).getArgument(0);
        if (value.getArity() == 0) {
            this.visitTerm(value);
        } else {
            this.visitLiteral(value);
        }
        this.out.print(")");
    }

    @Override
    public void visitInverse(ATermAppl p) {
        this.out.print("inverse ");
        this.visit((ATermAppl)p.getArgument(0));
    }

    @Override
    public void visitLiteral(ATermAppl term) {
        ATermAppl lexicalValue = (ATermAppl)term.getArgument(0);
        ATermAppl lang = (ATermAppl)term.getArgument(1);
        ATermAppl datatypeURI = (ATermAppl)term.getArgument(2);
        if (datatypeURI.equals((Object)XSDInteger.getInstance().getName()) || datatypeURI.equals((Object)XSDDecimal.getInstance().getName())) {
            this.out.print(lexicalValue.getName());
        } else if (datatypeURI.equals((Object)XSDFloat.getInstance().getName())) {
            this.out.print(lexicalValue.getName());
            this.out.print("f");
        } else if (!datatypeURI.equals((Object)ATermUtils.PLAIN_LITERAL_DATATYPE)) {
            this.out.print(lexicalValue.getName());
            this.out.print("^^");
            this.out.print(datatypeURI.getName());
        } else {
            this.out.print("\"" + lexicalValue.getName() + "\"");
            if (!lang.equals((Object)ATermUtils.EMPTY)) {
                this.out.print("@" + lang);
            }
        }
    }

    @Override
    public void visitMax(ATermAppl term) {
        this.out.print("(");
        this.visit((ATermAppl)term.getArgument(0));
        this.out.print(" max " + ((ATermInt)term.getArgument(1)).getInt() + " ");
        this.visit((ATermAppl)term.getArgument(2));
        this.out.print(")");
    }

    @Override
    public void visitMin(ATermAppl term) {
        this.out.print("(");
        this.visit((ATermAppl)term.getArgument(0));
        this.out.print(" min " + ((ATermInt)term.getArgument(1)).getInt() + " ");
        this.visit((ATermAppl)term.getArgument(2));
        this.out.print(")");
    }

    @Override
    public void visitNot(ATermAppl term) {
        this.out.print("not ");
        this.visit((ATermAppl)term.getArgument(0));
    }

    @Override
    public void visitOneOf(ATermAppl term) {
        this.out.print("{");
        ATermList list = (ATermList)term.getArgument(0);
        while (!list.isEmpty()) {
            ATermAppl value = (ATermAppl)list.getFirst();
            this.visit((ATermAppl)value.getArgument(0));
            list = list.getNext();
            if (list.isEmpty()) continue;
            this.out.print(" ");
        }
        this.out.print("}");
    }

    @Override
    public void visitOr(ATermAppl term) {
        this.out.print("(");
        this.visitList((ATermList)term.getArgument(0), "or");
        this.out.print(")");
    }

    @Override
    public void visitSelf(ATermAppl term) {
        this.out.print("(");
        this.visit((ATermAppl)term.getArgument(0));
        this.out.print(" Self)");
    }

    @Override
    public void visitSome(ATermAppl term) {
        this.out.print("(");
        this.visit((ATermAppl)term.getArgument(0));
        this.out.print(" some ");
        this.visit((ATermAppl)term.getArgument(1));
        this.out.print(")");
    }

    @Override
    public void visitValue(ATermAppl term) {
        this.out.print("(");
        this.visit((ATermAppl)term.getArgument(0));
        this.out.print(")");
    }

    public void visitList(ATermList list, String op) {
        while (!list.isEmpty()) {
            ATermAppl term = (ATermAppl)list.getFirst();
            this.visit(term);
            list = list.getNext();
            if (list.isEmpty()) continue;
            this.out.print(" " + op + " ");
        }
    }

    @Override
    public void visitRestrictedDatatype(ATermAppl dt) {
        this.out.print("");
        this.visit((ATermAppl)dt.getArgument(0));
        this.out.print("[");
        ATermList list = (ATermList)dt.getArgument(1);
        while (!list.isEmpty()) {
            ATermAppl facet = (ATermAppl)list.getFirst();
            this.out.print(FACETS.get(facet.getArgument(0)));
            this.out.print(" ");
            this.visit((ATermAppl)facet.getArgument(1));
            list = list.getNext();
            if (list.isEmpty()) continue;
            this.out.print(", ");
        }
        this.out.print("]");
    }
}

