/*
 * Decompiled with CFR 0.152.
 */
package org.mindswap.pellet.output;

import aterm.ATermAppl;
import aterm.ATermInt;
import aterm.ATermList;
import org.mindswap.pellet.output.ATermBaseRenderer;
import org.mindswap.pellet.output.ATermRenderer;

public class ATermAbstractSyntaxRenderer
extends ATermBaseRenderer
implements ATermRenderer {
    @Override
    public void visitAnd(ATermAppl term) {
        this.out.print("intersectionOf(");
        this.visitList((ATermList)term.getArgument(0));
        this.out.print(")");
    }

    @Override
    public void visitOr(ATermAppl term) {
        this.out.print("unionOf(");
        this.visitList((ATermList)term.getArgument(0));
        this.out.print(")");
    }

    @Override
    public void visitNot(ATermAppl term) {
        this.out.print("complementOf(");
        this.visit((ATermAppl)term.getArgument(0));
        this.out.print(")");
    }

    @Override
    public void visitSome(ATermAppl term) {
        this.out.print("restriction(");
        this.visit((ATermAppl)term.getArgument(0));
        this.out.print(" someValuesFrom(");
        this.visit((ATermAppl)term.getArgument(1));
        this.out.print("))");
    }

    @Override
    public void visitAll(ATermAppl term) {
        this.out.print("restriction(");
        this.visit((ATermAppl)term.getArgument(0));
        this.out.print(" allValuesFrom(");
        this.visit((ATermAppl)term.getArgument(1));
        this.out.print("))");
    }

    @Override
    public void visitMin(ATermAppl term) {
        this.out.print("restriction(");
        this.visit((ATermAppl)term.getArgument(0));
        this.out.print(" minCardinality(" + ((ATermInt)term.getArgument(1)).getInt() + ")");
        this.out.print(")");
    }

    @Override
    public void visitMax(ATermAppl term) {
        this.out.print("restriction(");
        this.visit((ATermAppl)term.getArgument(0));
        this.out.print(" maxCardinality(" + ((ATermInt)term.getArgument(1)).getInt() + ")");
        this.out.print(")");
    }

    @Override
    public void visitCard(ATermAppl term) {
        this.out.print("restriction(");
        this.visit((ATermAppl)term.getArgument(0));
        this.out.print(" cardinality(" + ((ATermInt)term.getArgument(1)).getInt() + ")");
        this.out.print(")");
    }

    @Override
    public void visitLiteral(ATermAppl lit) {
        String lexicalValue = ((ATermAppl)lit.getArgument(0)).getName();
        String lang = ((ATermAppl)lit.getArgument(1)).getName();
        String datatypeURI = ((ATermAppl)lit.getArgument(2)).getName();
        this.out.print("\"" + lexicalValue + "\"");
        if (!lang.equals("")) {
            this.out.print("@" + lang);
        } else if (!datatypeURI.equals("")) {
            this.out.print("^^");
            this.out.print(datatypeURI);
        }
    }

    @Override
    public void visitOneOf(ATermAppl term) {
        this.out.print("oneOf(");
        ATermList list = (ATermList)term.getArgument(0);
        while (!list.isEmpty()) {
            ATermAppl value = (ATermAppl)list.getFirst();
            this.visit((ATermAppl)value.getArgument(0));
            list = list.getNext();
            if (list.isEmpty()) continue;
            this.out.print(" ");
        }
        this.out.print(")");
    }

    @Override
    public void visitHasValue(ATermAppl term) {
        this.out.print("restriction(");
        this.visit((ATermAppl)term.getArgument(0));
        this.out.print(" value(");
        ATermAppl value = (ATermAppl)((ATermAppl)term.getArgument(1)).getArgument(0);
        if (value.getArity() == 0) {
            this.visitTerm(value);
        } else {
            this.visitLiteral(value);
        }
        this.out.print("))");
    }

    @Override
    public void visitValue(ATermAppl term) {
        this.out.print("oneOf(");
        this.visit((ATermAppl)term.getArgument(0));
        this.out.print(")");
    }

    @Override
    public void visitList(ATermList list) {
        while (!list.isEmpty()) {
            ATermAppl term = (ATermAppl)list.getFirst();
            this.visit(term);
            list = list.getNext();
            if (list.isEmpty()) continue;
            this.out.print(" ");
        }
    }

    @Override
    public void visitSelf(ATermAppl term) {
        this.out.print("restriction(");
        this.visit((ATermAppl)term.getArgument(0));
        this.out.print(" self)");
    }

    public void visitSubClass(ATermAppl term) {
        this.out.print("SubClassOf(");
        this.visitList(term.getArguments());
        this.out.print(")");
    }

    @Override
    public void visitInverse(ATermAppl p) {
        this.out.print("Inv(");
        this.visit((ATermAppl)p.getArgument(0));
        this.out.print(")");
    }

    @Override
    public void visitRestrictedDatatype(ATermAppl dt) {
        this.out.print("datatypeRestriction(");
        this.visit((ATermAppl)dt.getArgument(0));
        this.out.print(" ");
        ATermList list = (ATermList)dt.getArgument(1);
        while (!list.isEmpty()) {
            ATermAppl facet = (ATermAppl)list.getFirst();
            this.out.print("(");
            this.visit((ATermAppl)facet.getArgument(0));
            this.out.print(" ");
            this.visit((ATermAppl)facet.getArgument(1));
            this.out.print(")");
            list = list.getNext();
            if (list.isEmpty()) continue;
            this.out.print(" ");
        }
        this.out.print(" )");
    }
}

