/*
 * Decompiled with CFR 0.152.
 */
package org.mindswap.pellet;

import aterm.ATerm;
import aterm.ATermAppl;
import com.clarkparsia.pellet.utils.TermFactory;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.mindswap.pellet.PropertyType;
import org.mindswap.pellet.RBox;
import org.mindswap.pellet.Role;
import org.mindswap.pellet.taxonomy.Taxonomy;
import org.mindswap.pellet.taxonomy.TaxonomyNode;
import org.mindswap.pellet.utils.ATermUtils;

public class RoleTaxonomyBuilder {
    protected static Logger log = Logger.getLogger(Taxonomy.class.getName());
    public static final ATermAppl TOP_ANNOTATION_PROPERTY = ATermUtils.makeTermAppl("_TOP_ANNOTATION_PROPERTY_");
    public static final ATermAppl BOTTOM_ANNOTATION_PROPERTY = ATermUtils.makeTermAppl("_BOTTOM_ANNOTATION_PROPERTY_");
    protected Collection<Role> properties;
    protected Taxonomy<ATermAppl> taxonomy;
    protected RBox rbox;
    protected Role topRole;
    protected Role bottomRole;
    protected PropertyType propertyType;
    int count = 0;

    public RoleTaxonomyBuilder(RBox rbox, PropertyType type) {
        this.rbox = rbox;
        this.propertyType = type;
        this.properties = rbox.getRoles();
        switch (this.propertyType) {
            case OBJECT: {
                this.taxonomy = new Taxonomy<ATermAppl>(null, TermFactory.TOP_OBJECT_PROPERTY, TermFactory.BOTTOM_OBJECT_PROPERTY);
                break;
            }
            case DATATYPE: {
                this.taxonomy = new Taxonomy<ATermAppl>(null, TermFactory.TOP_DATA_PROPERTY, TermFactory.BOTTOM_DATA_PROPERTY);
                break;
            }
            case ANNOTATION: {
                this.taxonomy = new Taxonomy<ATermAppl>(null, TOP_ANNOTATION_PROPERTY, BOTTOM_ANNOTATION_PROPERTY);
                this.taxonomy.getTop().setHidden(true);
                this.taxonomy.getBottom().setHidden(true);
                break;
            }
            default: {
                throw new AssertionError((Object)("Unknown property type: " + (Object)((Object)this.propertyType)));
            }
        }
        this.topRole = rbox.getRole((ATerm)this.taxonomy.getTop().getName());
        this.bottomRole = rbox.getRole((ATerm)this.taxonomy.getBottom().getName());
    }

    public RoleTaxonomyBuilder(RBox rbox, boolean objectRoles) {
        this.rbox = rbox;
        this.properties = rbox.getRoles();
        this.taxonomy = objectRoles ? new Taxonomy<ATermAppl>(null, TermFactory.TOP_OBJECT_PROPERTY, TermFactory.BOTTOM_OBJECT_PROPERTY) : new Taxonomy<ATermAppl>(null, TermFactory.TOP_DATA_PROPERTY, TermFactory.BOTTOM_DATA_PROPERTY);
        this.topRole = rbox.getRole((ATerm)this.taxonomy.getTop().getName());
        this.bottomRole = rbox.getRole((ATerm)this.taxonomy.getBottom().getName());
    }

    public Taxonomy<ATermAppl> classify() {
        if (log.isLoggable(Level.FINE)) {
            log.fine("Properties: " + this.properties.size());
        }
        for (Role r : this.properties) {
            if (this.propertyType != r.getType()) continue;
            this.classify(r);
        }
        return this.taxonomy;
    }

    private void classify(Role c) {
        TaxonomyNode<ATermAppl> sup;
        if (this.taxonomy.contains(c.getName())) {
            return;
        }
        if (log.isLoggable(Level.FINER)) {
            log.finer("Property (" + ++this.count + ") " + c + "...");
        }
        if (c.getSubRoles().contains(this.topRole)) {
            this.taxonomy.getTop().addEquivalent(c.getName());
            return;
        }
        if (c.getSuperRoles().contains(this.bottomRole)) {
            this.taxonomy.getBottom().addEquivalent(c.getName());
            return;
        }
        HashMap<TaxonomyNode<Object>, Boolean> marked = new HashMap<TaxonomyNode<ATermAppl>, Boolean>();
        this.mark(this.taxonomy.getTop(), marked, Boolean.TRUE, Propagate.NONE);
        this.mark(this.taxonomy.getBottom(), marked, Boolean.FALSE, Propagate.NONE);
        Collection<TaxonomyNode<ATermAppl>> superNodes = this.search(true, c, this.taxonomy.getTop(), new HashSet<TaxonomyNode<ATermAppl>>(), new ArrayList<TaxonomyNode<ATermAppl>>(), marked);
        marked = new HashMap();
        this.mark(this.taxonomy.getTop(), marked, Boolean.FALSE, Propagate.NONE);
        this.mark(this.taxonomy.getBottom(), marked, Boolean.TRUE, Propagate.NONE);
        if (superNodes.size() == 1 && this.subsumed(sup = superNodes.iterator().next(), c, marked)) {
            if (log.isLoggable(Level.FINER)) {
                log.finer(String.valueOf(ATermUtils.toString(c.getName())) + " = " + ATermUtils.toString(sup.getName()));
            }
            this.taxonomy.addEquivalentNode(c.getName(), sup);
            return;
        }
        Collection<TaxonomyNode<ATermAppl>> subNodes = this.search(false, c, this.taxonomy.getBottom(), new HashSet<TaxonomyNode<ATermAppl>>(), new ArrayList<TaxonomyNode<ATermAppl>>(), marked);
        ArrayList<ATermAppl> supers = new ArrayList<ATermAppl>();
        for (TaxonomyNode<ATermAppl> n : superNodes) {
            supers.add(n.getName());
        }
        ArrayList<ATermAppl> subs = new ArrayList<ATermAppl>();
        for (TaxonomyNode<ATermAppl> n : subNodes) {
            subs.add(n.getName());
        }
        this.taxonomy.addNode(Collections.singleton(c.getName()), supers, subs, false);
    }

    private Collection<TaxonomyNode<ATermAppl>> search(boolean topSearch, Role c, TaxonomyNode<ATermAppl> x, Set<TaxonomyNode<ATermAppl>> visited, List<TaxonomyNode<ATermAppl>> result, Map<TaxonomyNode<ATermAppl>, Boolean> marked) {
        ArrayList<TaxonomyNode<ATermAppl>> posSucc = new ArrayList<TaxonomyNode<ATermAppl>>();
        visited.add(x);
        Collection<TaxonomyNode<ATermAppl>> list = topSearch ? x.getSubs() : x.getSupers();
        for (TaxonomyNode<ATermAppl> taxonomyNode : list) {
            if (topSearch) {
                if (!this.subsumes(taxonomyNode, c, marked)) continue;
                posSucc.add(taxonomyNode);
                continue;
            }
            if (!this.subsumed(taxonomyNode, c, marked)) continue;
            posSucc.add(taxonomyNode);
        }
        if (posSucc.isEmpty()) {
            result.add(x);
        } else {
            for (TaxonomyNode<Object> taxonomyNode : posSucc) {
                if (visited.contains(taxonomyNode)) continue;
                this.search(topSearch, c, taxonomyNode, visited, result, marked);
            }
        }
        return result;
    }

    private boolean subsumes(TaxonomyNode<ATermAppl> node, Role c, Map<TaxonomyNode<ATermAppl>, Boolean> marked) {
        Boolean cached = marked.get(node);
        if (cached != null) {
            return cached;
        }
        boolean subsumes = this.subsumes(this.rbox.getRole((ATerm)node.getName()), c);
        Boolean value = subsumes ? Boolean.TRUE : Boolean.FALSE;
        Propagate propagate = subsumes ? Propagate.NONE : Propagate.DOWN;
        this.mark(node, marked, value, propagate);
        return subsumes;
    }

    private boolean subsumed(TaxonomyNode<ATermAppl> node, Role c, Map<TaxonomyNode<ATermAppl>, Boolean> marked) {
        Boolean cached = marked.get(node);
        if (cached != null) {
            return cached;
        }
        boolean subsumed = this.subsumes(c, this.rbox.getRole((ATerm)node.getName()));
        Boolean value = subsumed ? Boolean.TRUE : Boolean.FALSE;
        Propagate propagate = subsumed ? Propagate.NONE : Propagate.UP;
        this.mark(node, marked, value, propagate);
        return subsumed;
    }

    private void mark(TaxonomyNode<ATermAppl> node, Map<TaxonomyNode<ATermAppl>, Boolean> marked, Boolean value, Propagate propagate) {
        Boolean exists = marked.get(node);
        if (exists != null) {
            if (!exists.equals(value)) {
                throw new RuntimeException("Inconsistent classification result " + node.getName() + " " + exists + " " + value);
            }
            return;
        }
        marked.put(node, value);
        if (propagate != Propagate.NONE) {
            Collection<TaxonomyNode<ATermAppl>> others = propagate == Propagate.UP ? node.getSupers() : node.getSubs();
            for (TaxonomyNode<ATermAppl> next : others) {
                this.mark(next, marked, value, propagate);
            }
        }
    }

    private boolean subsumes(Role sup, Role sub) {
        boolean result = sup.isSuperRoleOf(sub);
        ATermUtils.assertTrue(sub.isSubRoleOf(sup) == result);
        return result;
    }

    private static enum Propagate {
        UP,
        DOWN,
        NONE;

    }
}

