/*
 * Decompiled with CFR 0.152.
 */
package com.clarkparsia.pellet.rules.rete;

import com.clarkparsia.pellet.rules.rete.WME;
import java.util.Arrays;
import org.mindswap.pellet.DependencySet;

public abstract class Token {
    public abstract WME get(int var1);

    public abstract DependencySet getDepends(boolean var1);

    public abstract boolean dependsOn(int var1);

    public static Token create(WME wme, Token token) {
        return new ArrayToken(wme, (ArrayToken)token);
    }

    private static class ArrayToken
    extends Token {
        private WME[] wmes;

        public ArrayToken(WME wme, ArrayToken tok) {
            int l = tok == null ? 0 : tok.wmes.length;
            this.wmes = tok == null ? new WME[1] : Arrays.copyOf(tok.wmes, l + 1);
            this.wmes[l] = wme;
        }

        @Override
        public WME get(int index) {
            if (index >= this.wmes.length) {
                throw new ArrayIndexOutOfBoundsException();
            }
            return this.wmes[index];
        }

        @Override
        public DependencySet getDepends(boolean doExplanation) {
            DependencySet ds = DependencySet.INDEPENDENT;
            WME[] wMEArray = this.wmes;
            int n = this.wmes.length;
            int n2 = 0;
            while (n2 < n) {
                WME wme = wMEArray[n2];
                ds = ds.union(wme.getDepends(), doExplanation);
                ++n2;
            }
            return ds;
        }

        @Override
        public boolean dependsOn(int branch) {
            WME[] wMEArray = this.wmes;
            int n = this.wmes.length;
            int n2 = 0;
            while (n2 < n) {
                WME wme = wMEArray[n2];
                if (wme.dependsOn(branch)) {
                    return true;
                }
                ++n2;
            }
            return false;
        }

        public String toString() {
            return Arrays.toString(this.wmes);
        }
    }

    private static class ListToken
    extends Token {
        private ListToken next;
        private WME wme;
        private int index;

        public ListToken(WME wme, ListToken tok) {
            this.wme = wme;
            this.next = tok;
            this.index = tok == null ? 0 : tok.index + 1;
        }

        @Override
        public WME get(int index) {
            ListToken t = this;
            while (t != null) {
                if (t.index == index) {
                    return t.wme;
                }
                t = t.next;
            }
            throw new IndexOutOfBoundsException(String.valueOf(index) + " > " + this.index);
        }

        @Override
        public DependencySet getDepends(boolean doExplanation) {
            DependencySet ds = DependencySet.INDEPENDENT;
            ListToken t = this;
            while (t != null) {
                ds = ds.union(t.wme.getDepends(), doExplanation);
                t = t.next;
            }
            return ds;
        }

        @Override
        public boolean dependsOn(int branch) {
            ListToken t = this;
            while (t != null) {
                if (t.wme.dependsOn(branch)) {
                    return true;
                }
                t = t.next;
            }
            return false;
        }

        public String toString() {
            StringBuilder sb = new StringBuilder();
            sb.append('[');
            ListToken t = this;
            while (t != null) {
                sb.append(t.wme.toString());
                sb.append(',');
                t = t.next;
            }
            sb.setCharAt(sb.length() - 1, ']');
            return sb.toString();
        }
    }
}

