/*
 * Decompiled with CFR 0.152.
 */
package com.clarkparsia.pellet.rules.rete;

import com.clarkparsia.pellet.rules.rete.Token;
import com.clarkparsia.pellet.rules.rete.WME;
import org.mindswap.pellet.Node;
import org.mindswap.pellet.utils.ATermUtils;

public abstract class NodeProvider {
    public abstract Node getNode(WME var1, Token var2);

    public static class ConstantNodeProvider
    extends NodeProvider {
        private final Node node;

        public ConstantNodeProvider(Node node) {
            this.node = node;
        }

        @Override
        public Node getNode(WME wme, Token token) {
            return this.node;
        }

        public int hashCode() {
            return this.node.getName().hashCode();
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof ConstantNodeProvider)) {
                return false;
            }
            ConstantNodeProvider other = (ConstantNodeProvider)obj;
            return this.node.getName().equals((Object)other.node.getName());
        }

        public String toString() {
            return ATermUtils.toString(this.node.getName());
        }
    }

    public static class TokenNodeProvider
    extends NodeProvider {
        private final int indexWME;
        private final int indexArg;

        public TokenNodeProvider(int indexWME, int indexArg) {
            this.indexWME = indexWME;
            this.indexArg = indexArg;
        }

        @Override
        public Node getNode(WME wme, Token token) {
            return token.get(this.indexWME).getArg(this.indexArg);
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + this.indexArg;
            result = 31 * result + this.indexWME;
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof TokenNodeProvider)) {
                return false;
            }
            TokenNodeProvider other = (TokenNodeProvider)obj;
            return this.indexArg != other.indexArg && this.indexWME != other.indexWME;
        }

        public String toString() {
            return "token[" + this.indexWME + "]." + this.indexArg;
        }
    }

    public static class WMENodeProvider
    extends NodeProvider {
        private final int indexArg;

        public WMENodeProvider(int indexArg) {
            this.indexArg = indexArg;
        }

        @Override
        public Node getNode(WME wme, Token token) {
            return wme.getArg(this.indexArg);
        }

        public int getIndexArg() {
            return this.indexArg;
        }

        public int hashCode() {
            return this.indexArg;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof WMENodeProvider)) {
                return false;
            }
            WMENodeProvider other = (WMENodeProvider)obj;
            return this.indexArg == other.indexArg;
        }

        public String toString() {
            return "wme." + this.indexArg;
        }
    }
}

