/*
 * Decompiled with CFR 0.152.
 */
package com.clarkparsia.pellet.rules.rete;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.mindswap.pellet.utils.Pair;

public class Index<S, T>
implements Iterable<T> {
    private int size;
    private IndexNode<S, T> root;

    public Index() {
        this.clear();
    }

    public boolean add(List<S> key, T obj) {
        if (this.root.add(key, obj)) {
            ++this.size;
            return true;
        }
        return false;
    }

    public void clear() {
        this.root = new IndexNode();
        this.size = 0;
    }

    @Override
    public Iterator<T> iterator() {
        return ((IndexNode)this.root).getAllLeaves().iterator();
    }

    public <U> Collection<Pair<T, U>> join(Index<S, U> index, int shared) {
        ArrayList<Pair<T, U>> results = new ArrayList<Pair<T, U>>();
        this.root.join(index.root, shared, results);
        return results;
    }

    public Collection<T> match(List<S> key) {
        ArrayList results = new ArrayList();
        this.root.match(key, results);
        return results;
    }

    public boolean remove(List<S> key, T obj) {
        if (this.root.remove(key, obj)) {
            --this.size;
            return true;
        }
        return false;
    }

    public int size() {
        return this.size;
    }

    public String toString() {
        StringBuilder buffer = new StringBuilder("Index ");
        this.root.print(buffer, "");
        return buffer.toString();
    }

    private static class IndexNode<I, J> {
        private Map<I, IndexNode<I, J>> children = new HashMap<I, IndexNode<I, J>>();
        private Collection<J> leaves = new HashSet<J>();

        public boolean add(List<I> key, J obj) {
            if (key.size() == 0) {
                return this.leaves.add(obj);
            }
            I pivot = key.get(0);
            IndexNode<I, J> child = this.children.get(pivot);
            if (child == null) {
                child = new IndexNode<I, J>();
                this.children.put(pivot, child);
            }
            return child.add(key.subList(1, key.size()), obj);
        }

        private Collection<J> getAllLeaves() {
            ArrayList results = new ArrayList();
            this.getAllLeaves(results);
            return results;
        }

        private void getAllLeaves(Collection<J> result) {
            result.addAll(this.leaves);
            for (IndexNode<I, J> child : this.children.values()) {
                super.getAllLeaves(result);
            }
        }

        public <V> void join(IndexNode<I, V> node, int shared, Collection<Pair<J, V>> results) {
            if (shared > 0) {
                for (Map.Entry<I, IndexNode<I, J>> entry : this.children.entrySet()) {
                    if (entry.getKey() != null) {
                        IndexNode<I, J> nullNodeChild;
                        IndexNode<I, J> nodeChild = node.children.get(entry.getKey());
                        if (nodeChild != null) {
                            entry.getValue().join(nodeChild, shared - 1, results);
                        }
                        if ((nullNodeChild = node.children.get(null)) == null) continue;
                        entry.getValue().join(nullNodeChild, shared - 1, results);
                        continue;
                    }
                    for (IndexNode<I, J> child : node.children.values()) {
                        entry.getValue().join(child, shared - 1, results);
                    }
                }
            } else {
                for (J leaf : this.getAllLeaves()) {
                    for (V joinLeaf : super.getAllLeaves()) {
                        results.add(new Pair<J, V>(leaf, joinLeaf));
                    }
                }
            }
        }

        public void match(List<I> key, Collection<J> results) {
            if (key.size() == 0) {
                results.addAll(this.leaves);
            } else {
                IndexNode<I, J> nullChild;
                List<I> subKey = key.subList(1, key.size());
                IndexNode<I, J> pivotChild = this.children.get(key.get(0));
                if (pivotChild != null) {
                    pivotChild.match(subKey, results);
                }
                if ((nullChild = this.children.get(null)) != null) {
                    nullChild.match(subKey, results);
                }
            }
        }

        public void print(StringBuilder buffer, String prefix) {
            if (this.leaves.size() > 0) {
                buffer.append(this.leaves.toString());
            }
            buffer.append(":\n");
            prefix = String.valueOf(prefix) + " ";
            for (Map.Entry<I, IndexNode<I, J>> entry : this.children.entrySet()) {
                buffer.append(prefix).append(entry.getKey()).append(" ");
                entry.getValue().print(buffer, prefix);
            }
        }

        public boolean remove(List<I> key, J obj) {
            if (key.size() == 0) {
                return this.leaves.remove(obj);
            }
            I pivot = key.get(0);
            IndexNode<I, J> child = this.children.get(pivot);
            if (child == null) {
                return false;
            }
            boolean result = child.remove(key.subList(1, key.size()), obj);
            if (result && child.leaves.isEmpty()) {
                this.children.remove(child);
            }
            return result;
        }

        public String toString() {
            StringBuilder result = new StringBuilder("Index Node ");
            this.print(result, "");
            return result.toString();
        }
    }
}

