/*
 * Decompiled with CFR 0.152.
 */
package com.clarkparsia.pellet.rules.rete;

import aterm.ATerm;
import aterm.ATermAppl;
import com.clarkparsia.pellet.datatypes.exceptions.InvalidLiteralException;
import com.clarkparsia.pellet.datatypes.exceptions.UnrecognizedDatatypeException;
import com.clarkparsia.pellet.rules.BindingHelper;
import com.clarkparsia.pellet.rules.ContinuousRulesStrategy;
import com.clarkparsia.pellet.rules.VariableUtils;
import com.clarkparsia.pellet.rules.builtins.BuiltIn;
import com.clarkparsia.pellet.rules.builtins.BuiltInRegistry;
import com.clarkparsia.pellet.rules.model.AtomDConstant;
import com.clarkparsia.pellet.rules.model.AtomDObject;
import com.clarkparsia.pellet.rules.model.AtomDVariable;
import com.clarkparsia.pellet.rules.model.AtomIConstant;
import com.clarkparsia.pellet.rules.model.AtomIVariable;
import com.clarkparsia.pellet.rules.model.AtomObject;
import com.clarkparsia.pellet.rules.model.AtomObjectVisitor;
import com.clarkparsia.pellet.rules.model.AtomVariable;
import com.clarkparsia.pellet.rules.model.BuiltInAtom;
import com.clarkparsia.pellet.rules.model.ClassAtom;
import com.clarkparsia.pellet.rules.model.DataRangeAtom;
import com.clarkparsia.pellet.rules.model.DatavaluedPropertyAtom;
import com.clarkparsia.pellet.rules.model.DifferentIndividualsAtom;
import com.clarkparsia.pellet.rules.model.IndividualPropertyAtom;
import com.clarkparsia.pellet.rules.model.Rule;
import com.clarkparsia.pellet.rules.model.RuleAtom;
import com.clarkparsia.pellet.rules.model.RuleAtomVisitor;
import com.clarkparsia.pellet.rules.model.SameIndividualAtom;
import com.clarkparsia.pellet.rules.rete.AlphaNetwork;
import com.clarkparsia.pellet.rules.rete.AlphaNode;
import com.clarkparsia.pellet.rules.rete.BetaBuiltinNode;
import com.clarkparsia.pellet.rules.rete.BetaMemoryNode;
import com.clarkparsia.pellet.rules.rete.BetaNode;
import com.clarkparsia.pellet.rules.rete.BetaTopNode;
import com.clarkparsia.pellet.rules.rete.BuiltInCondition;
import com.clarkparsia.pellet.rules.rete.FilterCondition;
import com.clarkparsia.pellet.rules.rete.JoinCondition;
import com.clarkparsia.pellet.rules.rete.NodeProvider;
import com.clarkparsia.pellet.rules.rete.ProductionNode;
import com.clarkparsia.pellet.rules.rete.ReteNode;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.mindswap.pellet.ABox;
import org.mindswap.pellet.DependencySet;
import org.mindswap.pellet.Individual;
import org.mindswap.pellet.PelletOptions;
import org.mindswap.pellet.Role;
import org.mindswap.pellet.exceptions.InternalReasonerException;
import org.mindswap.pellet.utils.SetUtils;

public class Compiler {
    protected ContinuousRulesStrategy strategy;
    private ABox abox;
    private AlphaNetwork alphaNet;
    private SafetyChecker safetyChecker = new SafetyChecker();

    public Compiler(ContinuousRulesStrategy strategy) {
        this.strategy = strategy;
        this.abox = strategy.getABox();
        this.alphaNet = new AlphaNetwork(this.abox);
    }

    public AlphaNetwork getAlphaNet() {
        return this.alphaNet;
    }

    private RuleAtom pickNextAtom(List<RuleAtom> atoms, Set<AtomVariable> bound) {
        int index = 0;
        if (bound.isEmpty()) {
            int i = 0;
            while (i < atoms.size()) {
                RuleAtom atom = atoms.get(i);
                if (this.safetyChecker.isSafe(atom)) {
                    return atoms.remove(i);
                }
                ++i;
            }
        } else {
            int i = 0;
            while (i < atoms.size()) {
                RuleAtom atom = atoms.get(i);
                if (SetUtils.intersects(bound, atom.getAllArguments())) {
                    index = i;
                    if (this.safetyChecker.isSafe(atom)) break;
                }
                ++i;
            }
        }
        return atoms.remove(index);
    }

    /*
     * WARNING - void declaration
     */
    public void compile(Rule rule, Set<ATermAppl> explain) {
        ArrayList<RuleAtom> atoms = new ArrayList<RuleAtom>();
        ArrayList<BuiltInCall> builtins = new ArrayList<BuiltInCall>();
        for (RuleAtom ruleAtom : rule.getBody()) {
            if (ruleAtom instanceof BuiltInAtom) {
                builtins.add(new BuiltInCall(this.abox, (BuiltInAtom)ruleAtom));
                continue;
            }
            if (ruleAtom instanceof DataRangeAtom) continue;
            atoms.add(ruleAtom);
        }
        HashSet<AtomVariable> hashSet = new HashSet<AtomVariable>();
        ArrayList<RuleAtom> processed = new ArrayList<RuleAtom>();
        int lastSafe = -1;
        ReteNode lastSafeBeta = null;
        boolean canReuseBeta = false;
        RuleAtom atom = null;
        ReteNode node = null;
        while (!atoms.isEmpty()) {
            Object provider;
            atom = this.pickNextAtom(atoms, hashSet);
            if (!this.safetyChecker.isSafe(atom)) {
                lastSafe = processed.size();
                lastSafeBeta = node;
            }
            AlphaNode alpha = this.alphaNet.addNode(atom);
            List<? extends AtomObject> list = atom.getAllArguments();
            ArrayList<FilterCondition> arrayList = new ArrayList<FilterCondition>();
            if (!processed.isEmpty()) {
                int i = 0;
                int n = list.size();
                while (i < n) {
                    AtomObject arg = list.get(i);
                    if (arg instanceof AtomVariable && (provider = Compiler.createNodeProvider((AtomVariable)arg, processed)) != null) {
                        arrayList.add(new JoinCondition(new NodeProvider.WMENodeProvider(i), (NodeProvider.TokenNodeProvider)provider));
                    }
                    ++i;
                }
            }
            processed.add(atom);
            hashSet.addAll(VariableUtils.getVars(atom));
            Iterator i = builtins.iterator();
            while (i.hasNext()) {
                Collection<? extends AtomVariable> bindableVars;
                BuiltInCall call = (BuiltInCall)i.next();
                if (!hashSet.containsAll(call.getPrerequisitesVars(hashSet)) || !(bindableVars = call.getBindableVars(hashSet)).isEmpty() && !hashSet.containsAll(bindableVars)) continue;
                arrayList.add(call.createCondition(processed));
                i.remove();
            }
            boolean firstBeta = node == null;
            BetaNode newBeta = null;
            if (canReuseBeta) {
                if (firstBeta) {
                    provider = alpha.getBetas().iterator();
                    while (provider.hasNext()) {
                        BetaNode existingBeta = (BetaNode)provider.next();
                        if (!existingBeta.isTop()) continue;
                        newBeta = existingBeta;
                        break;
                    }
                } else {
                    Set<BetaNode> sharedBetas = SetUtils.intersection(alpha.getBetas(), node.getBetas());
                    for (BetaNode existingBeta : sharedBetas) {
                        BetaMemoryNode existingBetaMem;
                        if (!(existingBeta instanceof BetaMemoryNode) || !(existingBetaMem = (BetaMemoryNode)existingBeta).getConditions().equals(arrayList)) continue;
                        newBeta = existingBeta;
                        break;
                    }
                }
            }
            if (newBeta == null) {
                newBeta = firstBeta ? new BetaTopNode(alpha) : new BetaMemoryNode(alpha, arrayList);
                canReuseBeta = false;
            }
            alpha.addChild(newBeta);
            if (!firstBeta) {
                node.addChild(newBeta);
            }
            node = newBeta;
            int bindingCount = -1;
            while (!builtins.isEmpty() && bindingCount != hashSet.size()) {
                bindingCount = hashSet.size();
                Iterator i2 = builtins.iterator();
                while (i2.hasNext()) {
                    BuiltInCall call = (BuiltInCall)i2.next();
                    if (!hashSet.containsAll(call.getPrerequisitesVars(hashSet))) continue;
                    newBeta = call.createBeta(processed);
                    node.addChild(newBeta);
                    node = newBeta;
                    processed.add(call.atom);
                    hashSet.addAll(call.getBindableVars(hashSet));
                    canReuseBeta = false;
                    i2.remove();
                }
            }
        }
        if (!builtins.isEmpty()) {
            throw new UnsupportedOperationException("Builtin using unsafe variables: " + builtins);
        }
        if (lastSafe == 0) {
            this.strategy.addUnsafeRule(rule, explain);
        } else if (lastSafe > 0) {
            void var13_16;
            HashMap<AtomVariable, NodeProvider> args = new HashMap<AtomVariable, NodeProvider>();
            boolean bl = false;
            while (var13_16 < lastSafe) {
                for (AtomObject atomObject : ((RuleAtom)processed.get((int)var13_16)).getAllArguments()) {
                    if (!(atomObject instanceof AtomVariable) || args.containsKey(atomObject)) continue;
                    args.put((AtomVariable)atomObject, Compiler.createNodeProvider((AtomVariable)atomObject, processed));
                }
                ++var13_16;
            }
            lastSafeBeta.addChild(new ProductionNode.ProduceBinding(this.strategy, explain, rule, args));
        }
        if (rule.getHead().isEmpty()) {
            node.addChild(new ProductionNode.Inconsistency(this.strategy, explain));
        } else {
            ProductionNodeCreator creator = new ProductionNodeCreator(processed, explain);
            for (RuleAtom ruleAtom : rule.getHead()) {
                node.addChild(creator.create(ruleAtom));
            }
        }
    }

    private static NodeProvider.TokenNodeProvider createNodeProvider(AtomVariable arg, List<RuleAtom> processed) {
        return (NodeProvider.TokenNodeProvider)Compiler.createNodeProvider(arg, processed, false);
    }

    private static NodeProvider createNodeProvider(AtomVariable arg, List<RuleAtom> processed, boolean lastWME) {
        int index = 0;
        int n = processed.size();
        while (index < n) {
            RuleAtom sharedAtom = processed.get(index);
            int indexArg = sharedAtom.getAllArguments().indexOf(arg);
            if (indexArg != -1) {
                if (lastWME && index == n - 1) {
                    return new NodeProvider.WMENodeProvider(indexArg);
                }
                return new NodeProvider.TokenNodeProvider(index, indexArg);
            }
            ++index;
        }
        return null;
    }

    private static class AtomObjectTranslator
    implements AtomObjectVisitor {
        private DependencySet dependency = DependencySet.INDEPENDENT;
        private NodeProvider result = null;
        private final ABox abox;
        private final List<RuleAtom> processed;
        private final boolean lastWME;

        public AtomObjectTranslator(ABox abox, List<RuleAtom> processed, boolean lastWME) {
            this.abox = abox;
            this.processed = processed;
            this.lastWME = lastWME;
        }

        public DependencySet getDependency() {
            return this.dependency;
        }

        public NodeProvider translateObject(AtomObject obj) {
            return this.translateObject(obj, false);
        }

        public NodeProvider translateObject(AtomObject obj, boolean allowNull) {
            this.dependency = DependencySet.INDEPENDENT;
            obj.accept(this);
            if (this.result == null && !allowNull) {
                throw new UnsupportedOperationException();
            }
            return this.result;
        }

        @Override
        public void visit(AtomDConstant constant) {
            ATermAppl canonical;
            ATermAppl literal = constant.getValue();
            try {
                canonical = this.abox.getKB().getDatatypeReasoner().getCanonicalRepresentation(literal);
            }
            catch (InvalidLiteralException e) {
                String msg = String.format("Invalid literal (%s) in SWRL data constant: %s", literal, e.getMessage());
                if (PelletOptions.INVALID_LITERAL_AS_INCONSISTENCY) {
                    canonical = literal;
                }
                throw new InternalReasonerException(msg, e);
            }
            catch (UnrecognizedDatatypeException e) {
                String msg = String.format("Unrecognized datatype in literal appearing (%s) in SWRL data constant: %s", literal, e.getMessage());
                throw new InternalReasonerException(msg, e);
            }
            this.result = new NodeProvider.ConstantNodeProvider(this.abox.addLiteral(canonical));
        }

        @Override
        public void visit(AtomDVariable variable) {
            this.result = Compiler.createNodeProvider(variable, this.processed, this.lastWME);
        }

        @Override
        public void visit(AtomIConstant constant) {
            this.abox.copyOnWrite();
            Individual individual = this.abox.getIndividual((ATerm)constant.getValue());
            this.result = new NodeProvider.ConstantNodeProvider(individual);
        }

        @Override
        public void visit(AtomIVariable variable) {
            this.result = Compiler.createNodeProvider(variable, this.processed, this.lastWME);
        }
    }

    private static class BuiltInCall {
        private ABox abox;
        private BuiltInAtom atom;
        private BuiltIn builtin;
        private BindingHelper helper;

        public BuiltInCall(ABox abox, BuiltInAtom atom) {
            this.abox = abox;
            this.atom = atom;
            this.builtin = BuiltInRegistry.instance.getBuiltIn((String)atom.getPredicate());
            this.helper = this.builtin.createHelper(atom);
        }

        public BetaBuiltinNode createBeta(List<RuleAtom> processed) {
            return new BetaBuiltinNode(this.abox, (String)this.atom.getPredicate(), this.builtin, this.createProviders(processed, false));
        }

        public FilterCondition createCondition(List<RuleAtom> processed) {
            return new BuiltInCondition(this.abox, (String)this.atom.getPredicate(), this.builtin, this.createProviders(processed, true));
        }

        private NodeProvider[] createProviders(List<RuleAtom> processed, boolean lastWME) {
            List<AtomDObject> args = this.atom.getAllArguments();
            NodeProvider[] providers = new NodeProvider[args.size()];
            AtomObjectTranslator translator = new AtomObjectTranslator(this.abox, processed, lastWME);
            int i = 0;
            while (i < providers.length) {
                providers[i] = translator.translateObject(args.get(i), true);
                ++i;
            }
            return providers;
        }

        public Collection<? extends AtomVariable> getPrerequisitesVars(Collection<AtomVariable> bound) {
            return this.helper.getPrerequisiteVars(bound);
        }

        public Collection<? extends AtomVariable> getBindableVars(Collection<AtomVariable> bound) {
            return this.helper.getBindableVars(bound);
        }

        public String toString() {
            return this.atom.toString();
        }
    }

    private class ProductionNodeCreator
    implements RuleAtomVisitor {
        private final AtomObjectTranslator translator;
        private Set<ATermAppl> explain;
        private ProductionNode node;

        public ProductionNodeCreator(List<RuleAtom> processed, Set<ATermAppl> explain) {
            this.translator = new AtomObjectTranslator(Compiler.this.abox, processed, false);
            this.explain = explain;
        }

        private ProductionNode create(RuleAtom atom) {
            this.node = null;
            atom.accept(this);
            if (this.node == null) {
                throw new UnsupportedOperationException("Not supported " + atom);
            }
            return this.node;
        }

        @Override
        public void visit(SameIndividualAtom atom) {
            NodeProvider s = this.translator.translateObject((AtomObject)atom.getArgument1());
            NodeProvider o = this.translator.translateObject((AtomObject)atom.getArgument2());
            this.node = new ProductionNode.SameAs(Compiler.this.strategy, this.explain, s, o);
        }

        @Override
        public void visit(IndividualPropertyAtom atom) {
            NodeProvider s = this.translator.translateObject((AtomObject)atom.getArgument1());
            NodeProvider o = this.translator.translateObject((AtomObject)atom.getArgument2());
            Role r = Compiler.this.abox.getRole((ATerm)atom.getPredicate());
            this.node = new ProductionNode.Edge(Compiler.this.strategy, this.explain, s, r, o);
        }

        @Override
        public void visit(DifferentIndividualsAtom atom) {
            NodeProvider s = this.translator.translateObject((AtomObject)atom.getArgument1());
            NodeProvider o = this.translator.translateObject((AtomObject)atom.getArgument2());
            this.node = new ProductionNode.DiffFrom(Compiler.this.strategy, this.explain, s, o);
        }

        @Override
        public void visit(DatavaluedPropertyAtom atom) {
            NodeProvider s = this.translator.translateObject((AtomObject)atom.getArgument1());
            NodeProvider o = this.translator.translateObject((AtomObject)atom.getArgument2());
            Role r = Compiler.this.abox.getRole((ATerm)atom.getPredicate());
            this.node = new ProductionNode.Edge(Compiler.this.strategy, this.explain, s, r, o);
        }

        @Override
        public void visit(DataRangeAtom atom) {
        }

        @Override
        public void visit(ClassAtom atom) {
            NodeProvider s = this.translator.translateObject((AtomObject)atom.getArgument());
            ATermAppl type = (ATermAppl)atom.getPredicate();
            this.node = new ProductionNode.Type(Compiler.this.strategy, this.explain, s, type);
        }

        @Override
        public void visit(BuiltInAtom atom) {
        }
    }

    private class SafetyChecker
    implements RuleAtomVisitor {
        private boolean result = false;

        private SafetyChecker() {
        }

        public boolean isSafe(RuleAtom atom) {
            atom.accept(this);
            return this.result;
        }

        @Override
        public void visit(BuiltInAtom atom) {
            this.result = true;
        }

        @Override
        public void visit(ClassAtom atom) {
            ATermAppl c = (ATermAppl)atom.getPredicate();
            this.result = Compiler.this.abox.getKB().getTBox().isPrimitive(c);
        }

        @Override
        public void visit(DataRangeAtom atom) {
            this.result = true;
        }

        @Override
        public void visit(DatavaluedPropertyAtom atom) {
            this.result = true;
        }

        @Override
        public void visit(DifferentIndividualsAtom atom) {
            this.result = false;
        }

        @Override
        public void visit(IndividualPropertyAtom atom) {
            this.result = Compiler.this.abox.getRole((ATerm)atom.getPredicate()).isSimple();
        }

        @Override
        public void visit(SameIndividualAtom atom) {
            this.result = true;
        }
    }
}

