/*
 * Decompiled with CFR 0.152.
 */
package com.clarkparsia.pellet.rules.rete;

import com.clarkparsia.pellet.rules.rete.AlphaNode;
import com.clarkparsia.pellet.rules.rete.BetaMemoryIndex;
import com.clarkparsia.pellet.rules.rete.BetaNode;
import com.clarkparsia.pellet.rules.rete.FilterCondition;
import com.clarkparsia.pellet.rules.rete.JoinCondition;
import com.clarkparsia.pellet.rules.rete.Token;
import com.clarkparsia.pellet.rules.rete.WME;
import java.util.Iterator;
import java.util.List;
import java.util.logging.Level;

public class BetaMemoryNode
extends BetaNode {
    private final BetaMemoryIndex memory;
    private final AlphaNode alpha;
    private final List<FilterCondition> conditions;

    public BetaMemoryNode(AlphaNode alpha, List<FilterCondition> conditions) {
        if (conditions == null) {
            throw new NullPointerException();
        }
        this.alpha = alpha;
        this.conditions = conditions;
        this.memory = BetaMemoryNode.createIndex(conditions);
    }

    private static BetaMemoryIndex createIndex(List<FilterCondition> conditions) {
        if (!conditions.isEmpty() && conditions.get(0) instanceof JoinCondition) {
            return BetaMemoryIndex.withJoin((JoinCondition)conditions.get(0));
        }
        return BetaMemoryIndex.withoutJoin();
    }

    public AlphaNode getAlphaNode() {
        return this.alpha;
    }

    public List<FilterCondition> getConditions() {
        return this.conditions;
    }

    @Override
    public void activate(WME wme) {
        if (log.isLoggable(Level.FINE)) {
            log.fine("Activate beta " + wme);
        }
        Iterator<Token> wmeTokens = this.memory.getTokens(wme);
        while (wmeTokens.hasNext()) {
            Token token = wmeTokens.next();
            if (!this.testConditions(wme, token, 0)) continue;
            this.activateChildren(wme, token);
        }
    }

    @Override
    public void activate(Token token) {
        if (log.isLoggable(Level.FINE)) {
            log.fine("Activate beta " + token);
        }
        this.memory.add(token);
        Iterator<WME> matches = this.memory.getWMEs(token, this.alpha);
        while (matches.hasNext()) {
            WME wme = matches.next();
            if (!this.testConditions(wme, token, this.memory.isJoined() ? 1 : 0)) continue;
            this.activateChildren(wme, token);
        }
    }

    private boolean testConditions(WME wme, Token token, int start) {
        int i = start;
        int n = this.conditions.size();
        while (i < n) {
            FilterCondition condition = this.conditions.get(i);
            if (!condition.test(wme, token)) {
                return false;
            }
            ++i;
        }
        return true;
    }

    @Override
    public void reset() {
        super.reset();
        this.memory.clear();
    }

    @Override
    public void restore(int branch) {
        super.restore(branch);
        this.memory.restore(branch);
    }

    @Override
    public void print(String indent) {
        System.out.print(indent);
        System.out.println(this.alpha);
        indent = String.valueOf(indent) + "  ";
        System.out.print(indent);
        System.out.print(this);
        System.out.print(" ");
        System.out.println(this.memory);
        for (BetaNode node : this.getBetas()) {
            node.print(indent);
        }
    }

    public String toString() {
        return this.isTop() ? "Top" : "Beta" + this.conditions;
    }
}

