/*
 * Decompiled with CFR 0.152.
 */
package com.clarkparsia.pellet.rules.rete;

import com.clarkparsia.pellet.rules.rete.AlphaNode;
import com.clarkparsia.pellet.rules.rete.JoinCondition;
import com.clarkparsia.pellet.rules.rete.Token;
import com.clarkparsia.pellet.rules.rete.WME;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.mindswap.pellet.Node;
import org.mindswap.pellet.utils.iterator.IteratorUtils;

public abstract class BetaMemoryIndex {
    public abstract void add(Token var1);

    public abstract Iterator<Token> getTokens(WME var1);

    public abstract Iterator<WME> getWMEs(Token var1, AlphaNode var2);

    public abstract void restore(int var1);

    public abstract void clear();

    public abstract boolean isJoined();

    public static BetaMemoryIndex withoutJoin() {
        return new Unindexed();
    }

    public static BetaMemoryIndex withJoin(JoinCondition condition) {
        return condition == null ? new Unindexed() : new JoinIndexed(condition);
    }

    private static class JoinIndexed
    extends BetaMemoryIndex {
        private final Map<Node, List<Token>> index = new HashMap<Node, List<Token>>();
        private final JoinCondition joinCondition;

        private JoinIndexed(JoinCondition joinCondition) {
            this.joinCondition = joinCondition;
        }

        @Override
        public boolean isJoined() {
            return true;
        }

        @Override
        public void add(Token token) {
            Node tokenArg = this.joinCondition.getToken().getNode(null, token);
            List<Token> tokens = this.index.get(tokenArg);
            if (tokens == null) {
                tokens = new ArrayList<Token>();
                this.index.put(tokenArg, tokens);
            }
            tokens.add(token);
        }

        @Override
        public Iterator<Token> getTokens(WME wme) {
            Node wmeArg = this.joinCondition.getWME().getNode(wme, null);
            List<Token> tokens = this.index.get(wmeArg);
            return tokens == null ? IteratorUtils.emptyIterator() : new ListIterator(tokens);
        }

        @Override
        public Iterator<WME> getWMEs(Token token, AlphaNode alpha) {
            Node tokenArg = this.joinCondition.getToken().getNode(null, token);
            return alpha.getMatches(this.joinCondition.getWME().getIndexArg(), tokenArg);
        }

        @Override
        public void restore(int branch) {
            Iterator<List<Token>> i = this.index.values().iterator();
            while (i.hasNext()) {
                List<Token> tokens = i.next();
                Iterator<Token> j = tokens.iterator();
                while (j.hasNext()) {
                    Token token = j.next();
                    if (!token.dependsOn(branch)) continue;
                    j.remove();
                }
                if (!tokens.isEmpty()) continue;
                i.remove();
            }
        }

        @Override
        public void clear() {
            this.index.clear();
        }

        public String toString() {
            return this.index.values().toString();
        }
    }

    private static class JoinUnindexed
    extends BetaMemoryIndex {
        private final List<Token> memory = new ArrayList<Token>();
        private final JoinCondition joinCondition;

        private JoinUnindexed(JoinCondition joinCondition) {
            this.joinCondition = joinCondition;
        }

        @Override
        public boolean isJoined() {
            return true;
        }

        @Override
        public void add(Token token) {
            this.memory.add(token);
        }

        @Override
        public Iterator<Token> getTokens(WME wme) {
            return new ListIterator<Token>(this.memory);
        }

        @Override
        public Iterator<WME> getWMEs(Token token, AlphaNode alpha) {
            Node tokenArg = this.joinCondition.getToken().getNode(null, token);
            return alpha.getMatches(this.joinCondition.getWME().getIndexArg(), tokenArg);
        }

        @Override
        public void restore(int branch) {
            Iterator<Token> i = this.memory.iterator();
            while (i.hasNext()) {
                Token token = i.next();
                if (!token.dependsOn(branch)) continue;
                i.remove();
            }
        }

        @Override
        public void clear() {
            this.memory.clear();
        }

        public String toString() {
            return this.memory.toString();
        }
    }

    private static class ListIterator<T>
    implements Iterator<T> {
        private final List<T> list;
        private final int size;
        private int index = 0;

        private ListIterator(List<T> list) {
            this.list = list;
            this.size = list.size();
        }

        @Override
        public boolean hasNext() {
            return this.index < this.size;
        }

        @Override
        public T next() {
            return this.list.get(this.index++);
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }

    private static class Unindexed
    extends BetaMemoryIndex {
        private Token[] index = new Token[10];
        private int size = 0;

        private Unindexed() {
        }

        @Override
        public boolean isJoined() {
            return false;
        }

        @Override
        public void add(Token token) {
            if (this.size == this.index.length) {
                int newSize = this.size * 3 / 2 + 1;
                this.index = Arrays.copyOf(this.index, newSize);
            }
            this.index[this.size++] = token;
        }

        @Override
        public Iterator<Token> getTokens(WME wme) {
            return IteratorUtils.iterator(this.size, this.index);
        }

        @Override
        public Iterator<WME> getWMEs(Token token, AlphaNode alpha) {
            return alpha.getMatches();
        }

        @Override
        public void restore(int branch) {
            int i = 0;
            int removed = 0;
            while (i < this.size) {
                Token token = this.index[i];
                if (token.dependsOn(branch)) {
                    ++removed;
                } else if (removed > 0) {
                    System.arraycopy(this.index, i, this.index, i - removed, this.size - i);
                    this.size -= removed;
                }
                ++i;
            }
            if (removed > 0) {
                System.arraycopy(this.index, i, this.index, i - removed, this.size - i);
                this.size -= removed;
            }
        }

        @Override
        public void clear() {
            this.size = 0;
        }

        public String toString() {
            if (this.size == 0) {
                return "[]";
            }
            StringBuilder sb = new StringBuilder("[");
            int i = 0;
            while (i < this.size) {
                sb.append(this.index[i]);
                sb.append(", ");
                ++i;
            }
            int length = sb.length();
            sb.setCharAt(length - 2, ']');
            sb.setLength(length - 1);
            return sb.toString();
        }
    }
}

