/*
 * Decompiled with CFR 0.152.
 */
package com.clarkparsia.pellet.rules.rete;

import aterm.ATermAppl;
import com.clarkparsia.pellet.rules.model.AtomConstant;
import com.clarkparsia.pellet.rules.model.AtomIConstant;
import com.clarkparsia.pellet.rules.model.BinaryAtom;
import com.clarkparsia.pellet.rules.model.DatavaluedPropertyAtom;
import com.clarkparsia.pellet.rules.model.IndividualPropertyAtom;
import com.clarkparsia.pellet.rules.model.RuleAtom;
import com.clarkparsia.pellet.rules.rete.AlphaFixedEdgeNode;
import com.clarkparsia.pellet.rules.rete.WME;
import java.util.Iterator;
import org.mindswap.pellet.ABox;
import org.mindswap.pellet.Edge;
import org.mindswap.pellet.EdgeList;
import org.mindswap.pellet.Individual;
import org.mindswap.pellet.Node;
import org.mindswap.pellet.Role;
import org.mindswap.pellet.utils.ATermUtils;

public class AlphaNoVarEdgeNode
extends AlphaFixedEdgeNode {
    private final ATermAppl objectName;
    private Node objectNode;

    public AlphaNoVarEdgeNode(ABox abox, Role role, ATermAppl subjectName, ATermAppl objectName) {
        super(abox, role, subjectName);
        this.objectName = objectName;
    }

    protected Node initObjectNode() {
        if (this.objectNode == null) {
            this.objectNode = this.initNode(this.objectName);
        }
        assert (this.objectNode != null);
        return this.objectNode;
    }

    @Override
    public boolean activate(Edge edge) {
        Individual subject = (Individual)this.initNode();
        Node object = this.initObjectNode();
        WME.EdgeDirection dir = this.edgeMatches(edge);
        if (dir != null && (dir == WME.EdgeDirection.FORWARD ? edge.getFrom() : edge.getTo()).isSame(subject) && (dir == WME.EdgeDirection.BACKWARD ? edge.getFrom() : edge.getTo()).isSame(object)) {
            this.activate(WME.createEdge(edge, dir));
            return true;
        }
        return false;
    }

    @Override
    public Iterator<WME> getMatches(int argIndex, Node arg) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Iterator<WME> getMatches() {
        Individual subject = (Individual)this.initNode();
        Node object = this.initObjectNode();
        EdgeList edges = subject.getEdgesTo(object, this.role);
        return this.toWMEs(edges, WME.EdgeDirection.FORWARD);
    }

    @Override
    public boolean matches(RuleAtom atom) {
        return (atom instanceof IndividualPropertyAtom || atom instanceof DatavaluedPropertyAtom) && atom.getPredicate().equals(this.role.getName()) && ((BinaryAtom)atom).getArgument1() instanceof AtomIConstant && ((AtomIConstant)((BinaryAtom)atom).getArgument1()).getValue().equals((Object)this.name) && ((BinaryAtom)atom).getArgument2() instanceof AtomConstant && ((AtomConstant)((BinaryAtom)atom).getArgument2()).getValue().equals((Object)this.objectName);
    }

    @Override
    public String toString() {
        return String.valueOf(ATermUtils.toString(this.role.getName())) + "(" + ATermUtils.toString(this.name) + ", " + ATermUtils.toString(this.objectName) + ")";
    }
}

