/*
 * Decompiled with CFR 0.152.
 */
package com.clarkparsia.pellet.rules.builtins;

import aterm.ATermAppl;
import com.clarkparsia.pellet.datatypes.Datatype;
import com.clarkparsia.pellet.datatypes.exceptions.InvalidLiteralException;
import com.clarkparsia.pellet.datatypes.types.datetime.XSDDate;
import com.clarkparsia.pellet.datatypes.types.datetime.XSDDateTime;
import com.clarkparsia.pellet.datatypes.types.datetime.XSDTime;
import com.clarkparsia.pellet.rules.builtins.ComparisonTesters;
import com.clarkparsia.pellet.rules.builtins.Function;
import com.clarkparsia.pellet.rules.builtins.GeneralFunction;
import com.clarkparsia.pellet.rules.builtins.StringFunctionAdapter;
import com.clarkparsia.pellet.rules.builtins.StringToStringFunction;
import java.math.BigDecimal;
import javax.xml.datatype.XMLGregorianCalendar;
import org.mindswap.pellet.ABox;
import org.mindswap.pellet.Literal;
import org.mindswap.pellet.utils.ATermUtils;

public class DateTimeOperators {
    public static final GeneralFunction date = new Date();
    public static final GeneralFunction dateTime = new DateTime();
    public static final Function dayTimeDuration = new StringFunctionAdapter(new Duration(Duration.DURATIONTYPE.DAYTIME), "http://www.w3.org/2001/XMLSchema#duration");
    public static final GeneralFunction time = new Time();
    public static final Function yearMonthDuration = new StringFunctionAdapter(new Duration(Duration.DURATIONTYPE.YEARMONTH), "http://www.w3.org/2001/XMLSchema#duration");

    private static boolean applicability(int minargs, int maxargs, boolean[] boundPositions) {
        if (boundPositions.length < minargs || boundPositions.length > maxargs) {
            return false;
        }
        if (boundPositions[0]) {
            return true;
        }
        int i = 1;
        while (i < boundPositions.length) {
            if (!boundPositions[i]) {
                return false;
            }
            ++i;
        }
        return true;
    }

    private static Literal[] argList(Literal[] literals) {
        Literal[] args = new Literal[literals.length - 1];
        int i = 1;
        while (i < literals.length) {
            args[i - 1] = literals[i];
            ++i;
        }
        return args;
    }

    private static boolean checkValue(String val, Datatype<?> dt) {
        try {
            dt.getValue(ATermUtils.makeTypedLiteral(val, dt.getName()));
            return true;
        }
        catch (InvalidLiteralException e) {
            return false;
        }
    }

    private static Literal createDecimal(ABox abox, Number val) {
        ATermAppl term = ATermUtils.makeTypedLiteral(val.toString(), "http://www.w3.org/2001/XMLSchema#decimal");
        return abox.addLiteral(term);
    }

    private static Literal createInteger(ABox abox, Number val) {
        ATermAppl term = ATermUtils.makeTypedLiteral(val.toString(), "http://www.w3.org/2001/XMLSchema#integer");
        return abox.addLiteral(term);
    }

    private static boolean mergeResults(Literal[] args1, Literal[] args2) {
        int i = 0;
        while (i < args1.length) {
            if (args1[i] == null) {
                if (args2[i] == null) {
                    return false;
                }
                args1[i] = args2[i];
            } else if (args2[i] != null && !ComparisonTesters.equal.test(new Literal[]{args1[i], args2[i]})) {
                return false;
            }
            ++i;
        }
        return true;
    }

    private static String pad(int p, String s) {
        while (s.length() < p) {
            s = "0" + s;
        }
        return s;
    }

    private static boolean restBound(Literal[] args) {
        int i = 1;
        while (i < args.length) {
            if (args[i] == null) {
                return false;
            }
            ++i;
        }
        return true;
    }

    private static String toDate(String year, String month, String day) {
        return String.valueOf(DateTimeOperators.pad(4, year)) + "-" + DateTimeOperators.pad(2, month) + "-" + DateTimeOperators.pad(2, day);
    }

    private static String toTime(String hour, String minute, String second) {
        String millis = "";
        int point = second.indexOf(46);
        if (point >= 0) {
            millis = second.substring(point);
            second = second.substring(0, point);
        }
        return String.valueOf(DateTimeOperators.pad(2, hour)) + ":" + DateTimeOperators.pad(2, minute) + ":" + DateTimeOperators.pad(2, second) + millis;
    }

    private static String toTZ(int tz) {
        if (tz == 0) {
            return "Z";
        }
        return String.format("%+03d:02d", tz / 60, tz % 60);
    }

    private static class Date
    implements GeneralFunction,
    StringToStringFunction {
        StringFunctionAdapter allBound = new StringFunctionAdapter(this, "http://www.w3.org/2001/XMLSchema#date");

        private Date() {
        }

        @Override
        public boolean apply(ABox abox, Literal[] args) {
            Literal result;
            if (args[0] != null && args[0].getValue() instanceof XMLGregorianCalendar) {
                XMLGregorianCalendar value = (XMLGregorianCalendar)args[0].getValue();
                Literal[] results = new Literal[]{args[0], DateTimeOperators.createInteger(abox, value.getYear()), DateTimeOperators.createInteger(abox, value.getMonth()), DateTimeOperators.createInteger(abox, value.getDay()), value.getTimezone() != Integer.MIN_VALUE ? abox.addLiteral(ATermUtils.makePlainLiteral(DateTimeOperators.toTZ(value.getTimezone()))) : abox.addLiteral(ATermUtils.makePlainLiteral(""))};
                if (DateTimeOperators.mergeResults(args, results)) {
                    return true;
                }
            } else if (DateTimeOperators.restBound(args) && (result = this.allBound.apply(abox, args[0], DateTimeOperators.argList(args))) != null) {
                if (args[0] == null) {
                    args[0] = result;
                }
                return true;
            }
            return false;
        }

        @Override
        public String apply(String ... args) {
            String dateString;
            if (args.length < 3 || args.length > 4) {
                return null;
            }
            String tz = "";
            if (args.length == 4) {
                tz = args[3];
            }
            if (!DateTimeOperators.checkValue(dateString = String.valueOf(DateTimeOperators.toDate(args[0], args[1], args[2])) + tz, XSDDate.getInstance())) {
                return null;
            }
            return dateString;
        }

        @Override
        public boolean isApplicable(boolean[] boundPositions) {
            return DateTimeOperators.applicability(4, 5, boundPositions);
        }
    }

    private static class DateTime
    implements GeneralFunction,
    StringToStringFunction {
        StringFunctionAdapter allBound = new StringFunctionAdapter(this, "http://www.w3.org/2001/XMLSchema#dateTime");

        private DateTime() {
        }

        @Override
        public boolean apply(ABox abox, Literal[] args) {
            if (DateTimeOperators.restBound(args)) {
                Literal result = this.allBound.apply(abox, args[0], DateTimeOperators.argList(args));
                if (result != null) {
                    if (args[0] == null) {
                        args[0] = result;
                    }
                    return true;
                }
                return false;
            }
            if (args[0].getValue() instanceof XMLGregorianCalendar) {
                XMLGregorianCalendar value = (XMLGregorianCalendar)args[0].getValue();
                Literal[] results = new Literal[8];
                results[0] = args[0];
                results[1] = DateTimeOperators.createInteger(abox, value.getYear());
                results[2] = DateTimeOperators.createInteger(abox, value.getMonth());
                results[3] = DateTimeOperators.createInteger(abox, value.getDay());
                results[4] = DateTimeOperators.createInteger(abox, value.getHour());
                results[5] = DateTimeOperators.createInteger(abox, value.getMinute());
                BigDecimal fractionalSeconds = value.getFractionalSecond();
                results[6] = DateTimeOperators.createDecimal(abox, fractionalSeconds == null ? Integer.valueOf(value.getSecond()) : fractionalSeconds.add(BigDecimal.valueOf(value.getSecond())));
                if (value.getTimezone() != Integer.MIN_VALUE) {
                    results[7] = abox.addLiteral(ATermUtils.makePlainLiteral(DateTimeOperators.toTZ(value.getTimezone())));
                }
                if (DateTimeOperators.mergeResults(args, results)) {
                    return true;
                }
            }
            return false;
        }

        @Override
        public String apply(String ... args) {
            String dateTimeString;
            if (args.length < 6 || args.length > 7) {
                return null;
            }
            String tz = "";
            if (args.length == 7) {
                tz = args[6];
            }
            if (!DateTimeOperators.checkValue(dateTimeString = String.valueOf(DateTimeOperators.toDate(args[0], args[1], args[2])) + "T" + DateTimeOperators.toTime(args[3], args[4], args[5]) + tz, XSDDateTime.getInstance())) {
                return null;
            }
            return dateTimeString;
        }

        @Override
        public boolean isApplicable(boolean[] boundPositions) {
            return DateTimeOperators.applicability(7, 8, boundPositions);
        }
    }

    private static class Duration
    implements GeneralFunction,
    StringToStringFunction {
        private static final char[] SEP = new char[]{'Y', 'M', 'D', 'H', 'M', 'S'};
        private StringFunctionAdapter allBound;
        private DURATIONTYPE granularity;

        public Duration(DURATIONTYPE dur) {
            this.granularity = dur;
            this.allBound = new StringFunctionAdapter(this, "http://www.w3.org/2001/XMLSchema#duration");
        }

        @Override
        public boolean apply(ABox abox, Literal[] args) {
            if (DateTimeOperators.restBound(args)) {
                Literal result = this.allBound.apply(abox, args[0], DateTimeOperators.argList(args));
                if (result != null) {
                    if (args[0] == null) {
                        args[0] = result;
                    }
                    return true;
                }
                return false;
            }
            return false;
        }

        @Override
        public String apply(String ... args) {
            StringBuffer result;
            if (args.length > SEP.length + this.granularity.start) {
                return null;
            }
            if (args[0].charAt(0) != '-') {
                result = new StringBuffer("P");
            } else {
                result = new StringBuffer("-P");
                args[0] = args[0].substring(1);
            }
            boolean seenTime = false;
            int i = this.granularity.start;
            String[] stringArray = args;
            int n = args.length;
            int n2 = 0;
            while (n2 < n) {
                String arg = stringArray[n2];
                if (arg.length() > 0) {
                    if (i > 2 && !seenTime) {
                        seenTime = true;
                        result.append('T');
                    }
                    result.append(arg);
                    result.append(SEP[i]);
                }
                ++i;
                ++n2;
            }
            return result.toString();
        }

        @Override
        public boolean isApplicable(boolean[] boundPositions) {
            return DateTimeOperators.applicability(4, 5, boundPositions);
        }

        public static enum DURATIONTYPE {
            FULL(0, 5),
            YEARMONTH(0, 2),
            DAYTIME(2, 5);

            private int start;
            private int end;

            private DURATIONTYPE(int start, int end) {
                this.start = start;
                this.end = end;
            }
        }
    }

    private static class Time
    implements GeneralFunction,
    StringToStringFunction {
        StringFunctionAdapter allBound = new StringFunctionAdapter(this, "http://www.w3.org/2001/XMLSchema#time");

        private Time() {
        }

        @Override
        public boolean apply(ABox abox, Literal[] args) {
            if (DateTimeOperators.restBound(args)) {
                Literal result = this.allBound.apply(abox, args[0], DateTimeOperators.argList(args));
                if (result != null) {
                    if (args[0] == null) {
                        args[0] = result;
                    }
                    return true;
                }
                return false;
            }
            if (args[0].getValue() instanceof XMLGregorianCalendar) {
                XMLGregorianCalendar value = (XMLGregorianCalendar)args[0].getValue();
                Literal[] results = new Literal[5];
                results[0] = args[0];
                results[1] = DateTimeOperators.createInteger(abox, value.getHour());
                results[2] = DateTimeOperators.createInteger(abox, value.getMinute());
                BigDecimal fractionalSeconds = value.getFractionalSecond();
                results[3] = DateTimeOperators.createDecimal(abox, fractionalSeconds == null ? Integer.valueOf(value.getSecond()) : fractionalSeconds.add(BigDecimal.valueOf(value.getSecond())));
                if (value.getTimezone() != Integer.MIN_VALUE) {
                    results[4] = abox.addLiteral(ATermUtils.makePlainLiteral(DateTimeOperators.toTZ(value.getTimezone())));
                }
                if (DateTimeOperators.mergeResults(args, results)) {
                    return true;
                }
            }
            return false;
        }

        @Override
        public String apply(String ... args) {
            String timeString;
            if (args.length < 3 || args.length > 4) {
                return null;
            }
            String tz = "";
            if (args.length == 4) {
                tz = args[3];
            }
            if (!DateTimeOperators.checkValue(timeString = String.valueOf(DateTimeOperators.toTime(args[0], args[1], args[2])) + tz, XSDTime.getInstance())) {
                return null;
            }
            return timeString;
        }

        @Override
        public boolean isApplicable(boolean[] boundPositions) {
            return DateTimeOperators.applicability(4, 5, boundPositions);
        }
    }
}

