/*
 * Decompiled with CFR 0.152.
 */
package com.clarkparsia.pellet.rules.builtins;

import aterm.ATermAppl;
import com.clarkparsia.pellet.datatypes.DatatypeReasoner;
import com.clarkparsia.pellet.datatypes.Facet;
import com.clarkparsia.pellet.datatypes.exceptions.DatatypeReasonerException;
import com.clarkparsia.pellet.rules.builtins.BinaryTester;
import com.clarkparsia.pellet.rules.builtins.NumericComparisonVisitor;
import com.clarkparsia.pellet.rules.builtins.NumericPromotion;
import com.clarkparsia.pellet.rules.builtins.Tester;
import java.util.Arrays;
import java.util.Collections;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.mindswap.pellet.Literal;
import org.mindswap.pellet.utils.ATermUtils;

public class ComparisonTesters {
    private static Logger log = Logger.getLogger(ComparisonTesters.class.getCanonicalName());
    public static final Tester equal = new EqualityTester(false);
    public static final Tester greaterThan = new OrderingTester(false, false);
    public static final Tester greaterThanOrEqual = new OrderingTester(false, true);
    public static final Tester lessThan = new OrderingTester(true, false);
    public static final Tester lessThanOrEqual = new OrderingTester(true, true);
    public static final Tester notEqual = new EqualityTester(true);

    public static Literal expectedIfEquals(Literal expected, Literal result) {
        if (expected == null) {
            return result;
        }
        if (equal.test(new Literal[]{expected, result})) {
            return expected;
        }
        return null;
    }

    private static class EqualityTester
    extends BinaryTester {
        private boolean flip;

        private EqualityTester(boolean flip) {
            this.flip = flip;
        }

        @Override
        protected boolean test(Literal a, Literal b) {
            Object aval = a.getValue();
            Object bval = b.getValue();
            if (aval instanceof Number && bval instanceof Number) {
                NumericPromotion promoter = new NumericPromotion();
                Number anum = (Number)aval;
                Number bnum = (Number)bval;
                promoter.promote(anum, bnum);
                NumericComparisonVisitor visitor = new NumericComparisonVisitor();
                promoter.accept(visitor);
                if (visitor.getComparison() == 0) {
                    return true ^ this.flip;
                }
                return this.flip;
            }
            if (a.getValue() != null && b.getValue() != null) {
                return (aval.getClass().equals(bval.getClass()) && aval.equals(bval)) ^ this.flip;
            }
            return false;
        }
    }

    private static class OrderingTester
    extends BinaryTester {
        private boolean lt;
        private boolean inclusive;

        private OrderingTester(boolean flip, boolean inclusive) {
            this.lt = flip;
            this.inclusive = inclusive;
        }

        private boolean comparesWell(int comparison) {
            if (this.lt && comparison < 0) {
                return true;
            }
            if (!this.lt && comparison > 0) {
                return true;
            }
            return this.inclusive && comparison == 0;
        }

        @Override
        public boolean test(Literal l1, Literal l2) {
            Object l1val = l1.getValue();
            Object l2val = l2.getValue();
            if (l1val instanceof ATermAppl && l2val instanceof ATermAppl) {
                ATermAppl l1term = (ATermAppl)l1val;
                ATermAppl l2term = (ATermAppl)l2val;
                String l1str = ATermUtils.getLiteralValue(l1term);
                String l2str = ATermUtils.getLiteralValue(l2term);
                String l1lang = ATermUtils.getLiteralLang(l1term);
                String l2lang = ATermUtils.getLiteralLang(l2term);
                String l1data = ATermUtils.getLiteralDatatype(l1term);
                String l2data = ATermUtils.getLiteralDatatype(l2term);
                if (l1lang.equals(l2lang) && l1data.equals(l2data)) {
                    return this.comparesWell(l1str.compareTo(l2str));
                }
                return false;
            }
            if (l1val instanceof Number && l2val instanceof Number) {
                NumericPromotion promoter = new NumericPromotion();
                Number l1num = (Number)l1val;
                Number l2num = (Number)l2val;
                promoter.promote(l1num, l2num);
                NumericComparisonVisitor visitor = new NumericComparisonVisitor();
                promoter.accept(visitor);
                return this.comparesWell(visitor.getComparison());
            }
            DatatypeReasoner dtr = l1.getABox().getDatatypeReasoner();
            ATermAppl term1 = l1.getTerm();
            ATermAppl type1 = (ATermAppl)term1.getArgument(2);
            ATermAppl type2 = (ATermAppl)l2.getTerm().getArgument(2);
            try {
                if (dtr.isSatisfiable(Arrays.asList(type1, type2))) {
                    Facet.XSD f = this.lt ? (this.inclusive ? Facet.XSD.MIN_INCLUSIVE : Facet.XSD.MIN_EXCLUSIVE) : (this.inclusive ? Facet.XSD.MAX_INCLUSIVE : Facet.XSD.MAX_EXCLUSIVE);
                    ATermAppl canon1 = dtr.getCanonicalRepresentation(term1);
                    ATermAppl baseType = (ATermAppl)canon1.getArgument(2);
                    ATermAppl dr = ATermUtils.makeRestrictedDatatype(baseType, new ATermAppl[]{ATermUtils.makeFacetRestriction(f.getName(), canon1)});
                    return dtr.isSatisfiable(Collections.singleton(dr), l2val);
                }
                return false;
            }
            catch (DatatypeReasonerException e) {
                String msg = String.format("Unexpected datatype reasoner exception comparaing two literals ('%s','%s'). Treating as incomparable.", term1, l2.getTerm());
                log.log(Level.WARNING, msg, e);
                return false;
            }
        }
    }
}

