/*
 * Decompiled with CFR 0.152.
 */
package com.clarkparsia.pellet.rules;

import aterm.ATerm;
import aterm.ATermAppl;
import com.clarkparsia.pellet.datatypes.exceptions.InvalidLiteralException;
import com.clarkparsia.pellet.datatypes.exceptions.UnrecognizedDatatypeException;
import com.clarkparsia.pellet.rules.model.AtomDConstant;
import com.clarkparsia.pellet.rules.model.AtomDObject;
import com.clarkparsia.pellet.rules.model.AtomDVariable;
import com.clarkparsia.pellet.rules.model.AtomIConstant;
import com.clarkparsia.pellet.rules.model.AtomIObject;
import com.clarkparsia.pellet.rules.model.AtomIVariable;
import com.clarkparsia.pellet.rules.model.AtomObjectVisitor;
import com.clarkparsia.pellet.rules.model.AtomVariable;
import com.clarkparsia.pellet.rules.model.DefaultAtomObjectVisitor;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.logging.Logger;
import org.mindswap.pellet.ABox;
import org.mindswap.pellet.Individual;
import org.mindswap.pellet.Literal;
import org.mindswap.pellet.Node;
import org.mindswap.pellet.PelletOptions;
import org.mindswap.pellet.exceptions.InternalReasonerException;

public class VariableBinding {
    private static final Logger log = Logger.getLogger(VariableBinding.class.getCanonicalName());
    private ABox abox;
    private Map<AtomDVariable, Literal> dataVars;
    private Map<AtomIVariable, Individual> instanceVars;

    public VariableBinding(ABox abox) {
        this.abox = abox;
        this.dataVars = new HashMap<AtomDVariable, Literal>();
        this.instanceVars = new HashMap<AtomIVariable, Individual>();
    }

    public VariableBinding(VariableBinding binding) {
        this.abox = binding.abox;
        this.dataVars = new HashMap<AtomDVariable, Literal>(binding.dataVars);
        this.instanceVars = new HashMap<AtomIVariable, Individual>(binding.instanceVars);
    }

    public boolean containsKey(AtomDVariable key) {
        return this.dataVars.containsKey(key);
    }

    public boolean containsKey(AtomIVariable key) {
        return this.instanceVars.containsKey(key);
    }

    public Set<Map.Entry<AtomDVariable, Literal>> dataEntrySet() {
        return this.dataVars.entrySet();
    }

    public Set<Map.Entry<? extends AtomVariable, ? extends Node>> entrySet() {
        HashSet<Map.Entry<? extends AtomVariable, ? extends Node>> entries = new HashSet<Map.Entry<? extends AtomVariable, ? extends Node>>();
        entries.addAll(this.dataVars.entrySet());
        entries.addAll(this.instanceVars.entrySet());
        return entries;
    }

    public boolean equals(Object other) {
        if (other instanceof VariableBinding) {
            VariableBinding otherBinding = (VariableBinding)other;
            if (this.dataVars.equals(otherBinding.dataVars) && this.instanceVars.equals(otherBinding.instanceVars)) {
                return true;
            }
        }
        return false;
    }

    public Literal get(AtomDObject key) {
        DataValueCollector collector = new DataValueCollector();
        key.accept(collector);
        return collector.getValue();
    }

    public Individual get(AtomIObject key) {
        IndividualValueCollector collector = new IndividualValueCollector();
        key.accept(collector);
        return collector.getValue();
    }

    public ABox getABox() {
        return this.abox;
    }

    public int hashCode() {
        return this.dataVars.hashCode() + this.instanceVars.hashCode();
    }

    public Literal set(AtomDObject key, Literal value) {
        ValueSettingVisitor visitor = new ValueSettingVisitor(null, value);
        key.accept(visitor);
        return visitor.getData();
    }

    public Literal set(AtomDVariable key, ATermAppl value) {
        AtomDConstant constant = new AtomDConstant(value);
        DataValueCollector collector = new DataValueCollector();
        constant.accept(collector);
        return this.set((AtomDObject)key, collector.getValue());
    }

    public Individual set(AtomIObject key, Individual value) {
        ValueSettingVisitor visitor = new ValueSettingVisitor(value, null);
        key.accept(visitor);
        return visitor.getIndividual();
    }

    public Individual set(AtomIVariable key, ATermAppl value) {
        AtomIConstant constant = new AtomIConstant(value);
        IndividualValueCollector collector = new IndividualValueCollector();
        constant.accept(collector);
        return this.set((AtomIObject)key, collector.getValue());
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer("{");
        buffer.append(this.instanceVars);
        buffer.append(", ");
        buffer.append(this.dataVars);
        buffer.append("}");
        return buffer.toString();
    }

    private class DataValueCollector
    extends DefaultAtomObjectVisitor {
        Literal value = null;

        private DataValueCollector() {
        }

        public Literal getValue() {
            return this.value;
        }

        @Override
        public void visit(AtomDConstant constant) {
            ATermAppl canonical;
            ATermAppl literal = constant.getValue();
            try {
                canonical = VariableBinding.this.abox.getKB().getDatatypeReasoner().getCanonicalRepresentation(literal);
            }
            catch (InvalidLiteralException e) {
                String msg = String.format("Invalid literal (%s) in SWRL data constant: %s", literal, e.getMessage());
                if (PelletOptions.INVALID_LITERAL_AS_INCONSISTENCY) {
                    canonical = literal;
                }
                log.severe(msg);
                throw new InternalReasonerException(msg, e);
            }
            catch (UnrecognizedDatatypeException e) {
                String msg = String.format("Unrecognized datatype in literal appearing (%s) in SWRL data constant: %s", literal, e.getMessage());
                log.severe(msg);
                throw new InternalReasonerException(msg, e);
            }
            VariableBinding.this.abox.copyOnWrite();
            this.value = VariableBinding.this.abox.getLiteral((ATerm)canonical);
            if (this.value == null) {
                this.value = VariableBinding.this.abox.addLiteral(canonical);
            }
        }

        @Override
        public void visit(AtomDVariable variable) {
            this.value = (Literal)VariableBinding.this.dataVars.get(variable);
        }
    }

    private class IndividualValueCollector
    extends DefaultAtomObjectVisitor {
        Individual value = null;

        private IndividualValueCollector() {
        }

        public Individual getValue() {
            return this.value;
        }

        @Override
        public void visit(AtomIConstant constant) {
            VariableBinding.this.abox.copyOnWrite();
            this.value = VariableBinding.this.abox.getIndividual((ATerm)constant.getValue());
        }

        @Override
        public void visit(AtomIVariable variable) {
            this.value = (Individual)VariableBinding.this.instanceVars.get(variable);
        }
    }

    private class ValueSettingVisitor
    implements AtomObjectVisitor {
        Literal data;
        Individual individual;

        public ValueSettingVisitor(Individual individual, Literal data) {
            this.data = data;
            this.individual = individual;
        }

        public Literal getData() {
            return this.data;
        }

        public Individual getIndividual() {
            return this.individual;
        }

        @Override
        public void visit(AtomDConstant constant) {
            this.data = null;
        }

        @Override
        public void visit(AtomDVariable var) {
            if (this.data != null) {
                this.data = VariableBinding.this.dataVars.put(var, this.data);
            }
        }

        @Override
        public void visit(AtomIConstant constant) {
            this.individual = null;
        }

        @Override
        public void visit(AtomIVariable var) {
            if (this.individual != null) {
                this.individual = VariableBinding.this.instanceVars.put(var, this.individual);
            }
        }
    }
}

