/*
 * Decompiled with CFR 0.152.
 */
package com.clarkparsia.pellet.rules;

import com.clarkparsia.pellet.rules.VariableUtils;
import com.clarkparsia.pellet.rules.builtins.BuiltIn;
import com.clarkparsia.pellet.rules.builtins.BuiltInRegistry;
import com.clarkparsia.pellet.rules.builtins.NoSuchBuiltIn;
import com.clarkparsia.pellet.rules.model.AtomVariable;
import com.clarkparsia.pellet.rules.model.BuiltInAtom;
import com.clarkparsia.pellet.rules.model.DataRangeAtom;
import com.clarkparsia.pellet.rules.model.DefaultRuleAtomVisitor;
import com.clarkparsia.pellet.rules.model.Rule;
import com.clarkparsia.pellet.rules.model.RuleAtom;
import com.clarkparsia.pellet.rules.model.SameIndividualAtom;
import java.util.HashSet;

public class UsableRuleFilter {
    private static BodyAtomFilter bodyFilter = new BodyAtomFilter();
    private static HeadAtomFilter headFilter = new HeadAtomFilter();

    public static boolean isUsable(Rule rule) {
        return UsableRuleFilter.explainNotUsable(rule) == null;
    }

    public static String explainNotUsable(Rule rule) {
        String notUsableExplanation;
        HashSet<AtomVariable> bodyVars = new HashSet<AtomVariable>();
        for (RuleAtom ruleAtom : rule.getBody()) {
            notUsableExplanation = bodyFilter.explainNotUsable(ruleAtom);
            if (notUsableExplanation != null) {
                return notUsableExplanation;
            }
            bodyVars.addAll(VariableUtils.getVars(ruleAtom));
        }
        for (RuleAtom ruleAtom : rule.getHead()) {
            if (!bodyVars.containsAll(VariableUtils.getVars(ruleAtom))) {
                return "Head atom " + ruleAtom + " contains variables not found in body.";
            }
            notUsableExplanation = headFilter.explainNotUsable(ruleAtom);
            if (notUsableExplanation == null) continue;
            return notUsableExplanation;
        }
        return null;
    }

    private static class BodyAtomFilter
    extends UsableFilter {
        private BodyAtomFilter() {
        }

        @Override
        public void visit(BuiltInAtom atom) {
            BuiltIn builtin = BuiltInRegistry.instance.getBuiltIn((String)atom.getPredicate());
            if (builtin.equals(NoSuchBuiltIn.instance)) {
                this.notUsableMessage = "No builtin for " + (String)atom.getPredicate();
            }
        }

        @Override
        public void visit(SameIndividualAtom atom) {
            this.notUsableMessage = "SameIndividual atom is not supported in rule body: " + atom;
        }
    }

    private static class HeadAtomFilter
    extends UsableFilter {
        private HeadAtomFilter() {
        }

        @Override
        public void visit(BuiltInAtom atom) {
            this.notUsableMessage = "Builtin atoms in rule heads are not currently supported";
        }

        @Override
        public void visit(DataRangeAtom atom) {
            this.notUsableMessage = "DataRange atoms in rule heads are not currently supported";
        }
    }

    private static class UsableFilter
    extends DefaultRuleAtomVisitor {
        protected String notUsableMessage;

        private UsableFilter() {
        }

        public String explainNotUsable(RuleAtom atom) {
            this.notUsableMessage = null;
            atom.accept(this);
            return this.notUsableMessage;
        }
    }
}

