/*
 * Decompiled with CFR 0.152.
 */
package com.clarkparsia.pellet.rules;

import aterm.ATermAppl;
import com.clarkparsia.pellet.expressivity.Expressivity;
import com.clarkparsia.pellet.rules.BindingGeneratorStrategy;
import com.clarkparsia.pellet.rules.BindingGeneratorStrategyImpl;
import com.clarkparsia.pellet.rules.PartialBinding;
import com.clarkparsia.pellet.rules.RuleAtomAsserter;
import com.clarkparsia.pellet.rules.RulesToATermTranslator;
import com.clarkparsia.pellet.rules.TrivialSatisfactionHelpers;
import com.clarkparsia.pellet.rules.VariableBinding;
import com.clarkparsia.pellet.rules.model.Rule;
import com.clarkparsia.pellet.rules.model.RuleAtom;
import com.clarkparsia.pellet.rules.rete.Compiler;
import com.clarkparsia.pellet.rules.rete.Interpreter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import org.mindswap.pellet.ABox;
import org.mindswap.pellet.Clash;
import org.mindswap.pellet.DependencySet;
import org.mindswap.pellet.Edge;
import org.mindswap.pellet.Individual;
import org.mindswap.pellet.Node;
import org.mindswap.pellet.PelletOptions;
import org.mindswap.pellet.Role;
import org.mindswap.pellet.tableau.branch.Branch;
import org.mindswap.pellet.tableau.branch.RuleBranch;
import org.mindswap.pellet.tableau.completion.SROIQStrategy;
import org.mindswap.pellet.tableau.completion.rule.TableauRule;
import org.mindswap.pellet.utils.Pair;
import org.mindswap.pellet.utils.Timer;

public class ContinuousRulesStrategy
extends SROIQStrategy {
    private BindingGeneratorStrategy bindingStrategy;
    private Interpreter interpreter;
    private boolean merging;
    private Set<PartialBinding> unsafeRules;
    private Set<PartialBinding> partialBindings;
    private Map<Pair<Rule, VariableBinding>, Integer> rulesApplied;
    private RulesToATermTranslator atermTranslator;
    private RuleAtomAsserter ruleAtomAsserter;
    private TrivialSatisfactionHelpers atomTester;

    public ContinuousRulesStrategy(ABox abox) {
        super(abox);
        this.bindingStrategy = new BindingGeneratorStrategyImpl(abox);
        this.partialBindings = new HashSet<PartialBinding>();
        this.unsafeRules = new HashSet<PartialBinding>();
        this.rulesApplied = new HashMap<Pair<Rule, VariableBinding>, Integer>();
        this.atermTranslator = new RulesToATermTranslator();
        this.ruleAtomAsserter = new RuleAtomAsserter();
        this.atomTester = new TrivialSatisfactionHelpers(abox);
    }

    public void addUnsafeRule(Rule rule, Set<ATermAppl> explain) {
        this.unsafeRules.add(new PartialBinding(rule, new VariableBinding(this.abox), new DependencySet(explain)));
    }

    public void addPartialBinding(PartialBinding binding) {
        this.partialBindings.add(binding);
    }

    @Override
    public Edge addEdge(Individual subj, Role pred, Node obj, DependencySet ds) {
        Edge edge = super.addEdge(subj, pred, obj, ds);
        if (edge != null && !this.abox.isClosed() && subj.isRootNominal() && obj.isRootNominal() && this.interpreter != null) {
            this.interpreter.alphaNet.activateEdge(edge);
        }
        return edge;
    }

    @Override
    public void addType(Node node, ATermAppl c, DependencySet ds) {
        super.addType(node, c, ds);
        if (!this.merging && !this.abox.isClosed() && node.isRootNominal() && this.interpreter != null && node.isIndividual()) {
            Individual ind = (Individual)node;
            this.interpreter.alphaNet.activateType(ind, c, ds);
        }
    }

    @Override
    protected boolean mergeIndividuals(Individual y, Individual x, DependencySet ds) {
        if (super.mergeIndividuals(y, x, ds)) {
            if (this.interpreter != null) {
                this.interpreter.alphaNet.activateDifferents(y);
            }
            return true;
        }
        return false;
    }

    @Override
    public boolean setDifferent(Node y, Node z, DependencySet ds) {
        if (super.setDifferent(y, z, ds)) {
            if (this.interpreter != null && !this.merging && !this.abox.isClosed() && y.isRootNominal() && y.isIndividual() && z.isRootNominal() && z.isIndividual()) {
                this.interpreter.alphaNet.activateDifferent((Individual)y, (Individual)z, ds);
            }
            return true;
        }
        return false;
    }

    public Collection<PartialBinding> applyRete() {
        Timer t;
        if (PelletOptions.ALWAYS_REBUILD_RETE) {
            t = this.timers.startTimer("rule-rebuildRete");
            this.partialBindings.clear();
            this.partialBindings.addAll(this.unsafeRules);
            this.interpreter.reset();
            t.stop();
        }
        t = this.timers.startTimer("rule-reteRun");
        this.interpreter.run();
        t.stop();
        return this.interpreter.getBindings();
    }

    public void applyRuleBindings() {
        int total = 0;
        for (PartialBinding ruleBinding : this.partialBindings) {
            Rule rule = ruleBinding.getRule();
            VariableBinding initial = ruleBinding.getBinding();
            for (VariableBinding binding : this.bindingStrategy.createGenerator(rule, initial)) {
                int branch;
                Pair<Rule, VariableBinding> ruleKey = new Pair<Rule, VariableBinding>(rule, binding);
                if (this.rulesApplied.containsKey(ruleKey)) continue;
                ++total;
                if (log.isLoggable(Level.FINE)) {
                    log.fine("Rule: " + rule);
                    log.fine("Binding: " + binding);
                    log.fine("total:" + total);
                }
                if ((branch = this.createDisjunctionsFromBinding(binding, rule, ruleBinding.getDependencySet())) >= 0) {
                    this.rulesApplied.put(ruleKey, branch);
                }
                if (!this.abox.isClosed()) continue;
                return;
            }
        }
    }

    /*
     * Unable to fully structure code
     */
    @Override
    public void complete(Expressivity expr) {
        expressivity = this.abox.getKB().getExpressivity();
        this.initialize(expressivity);
        this.merging = false;
        t = this.timers.startTimer("rule-buildReteRules");
        compiler = new Compiler(this);
        for (Map.Entry<Rule, Rule> e : this.abox.getKB().getNormalizedRules().entrySet()) {
            rule = e.getKey();
            normalizedRule = e.getValue();
            if (normalizedRule == null) continue;
            explain = this.abox.doExplanation() != false ? rule.getExplanation(this.atermTranslator) : Collections.emptySet();
            try {
                compiler.compile(normalizedRule, explain);
            }
            catch (UnsupportedOperationException uoe) {
                throw new RuntimeException("Unsupported rule " + normalizedRule, uoe);
            }
        }
        t.stop();
        alphaNet = compiler.getAlphaNet();
        if (this.abox.doExplanation()) {
            alphaNet.setDoExplanation(true);
        }
        this.interpreter = new Interpreter(alphaNet);
        this.partialBindings.clear();
        this.partialBindings.addAll(this.unsafeRules);
        this.rulesApplied.clear();
        this.applyRete();
        ** GOTO lbl78
        {
            block14: {
                this.completionTimer.check();
                this.abox.setChanged(false);
                if (ContinuousRulesStrategy.log.isLoggable(Level.FINE)) {
                    ContinuousRulesStrategy.log.fine("Branch: " + this.abox.getBranch() + ", Depth: " + this.abox.stats.treeDepth + ", Size: " + this.abox.getNodes().size() + ", Mem: " + Runtime.getRuntime().freeMemory() / 1000L + "kb");
                    this.abox.validate();
                    this.abox.printTree();
                    this.interpreter.alphaNet.print();
                }
                i = this.abox.getIndIterator();
                for (TableauRule tableauRule : this.tableauRules) {
                    tableauRule.apply(i);
                    if (this.abox.isClosed()) break;
                }
                if (this.abox.isClosed()) ** GOTO lbl48
                if (this.abox.isChanged() || this.partialBindings.isEmpty()) break block14;
                this.applyRuleBindings();
                if (this.abox.isClosed()) ** GOTO lbl48
            }
            do {
                if (this.abox.isChanged() && !this.abox.isClosed()) continue block3;
lbl48:
                // 3 sources

                if (this.abox.isClosed()) {
                    if (ContinuousRulesStrategy.log.isLoggable(Level.FINE)) {
                        ContinuousRulesStrategy.log.fine("Clash at Branch (" + this.abox.getBranch() + ") " + this.abox.getClash());
                    }
                    if (this.backtrack()) {
                        this.abox.setClash(null);
                        continue;
                    }
                    this.abox.setComplete(true);
                    continue;
                }
                if (PelletOptions.SATURATE_TABLEAU) {
                    unexploredBranch = null;
                    i = this.abox.getBranches().size() - 1;
                    while (i >= 0) {
                        unexploredBranch = this.abox.getBranches().get(i);
                        unexploredBranch.setTryNext(unexploredBranch.getTryNext() + 1);
                        if (unexploredBranch.getTryNext() < unexploredBranch.getTryCount()) {
                            this.restore(unexploredBranch);
                            System.out.println("restoring branch " + unexploredBranch.getBranch() + " tryNext = " + unexploredBranch.getTryNext() + " tryCount = " + unexploredBranch.getTryCount());
                            unexploredBranch.tryNext();
                            break;
                        }
                        System.out.println("removing branch " + unexploredBranch.getBranch());
                        this.abox.getBranches().remove(i);
                        unexploredBranch = null;
                        --i;
                    }
                    if (unexploredBranch != null) continue;
                    this.abox.setComplete(true);
                    continue;
                }
                this.abox.setComplete(true);
lbl78:
                // 6 sources

            } while (!this.abox.isComplete());
        }
    }

    private int createDisjunctionsFromBinding(VariableBinding binding, Rule rule, DependencySet ds) {
        ArrayList<RuleAtom> atoms = new ArrayList<RuleAtom>();
        for (RuleAtom ruleAtom : rule.getBody()) {
            DependencySet atomDS = this.atomTester.isAtomTrue(ruleAtom, binding);
            if (atomDS != null) {
                ds = ds.union(atomDS, this.abox.doExplanation());
                continue;
            }
            atoms.add(ruleAtom);
        }
        if (atoms.isEmpty()) {
            if (rule.getHead().isEmpty()) {
                if (log.isLoggable(Level.FINE)) {
                    log.fine("Empty head for rule " + rule);
                }
                this.abox.setClash(Clash.unexplained(null, ds));
            } else {
                for (RuleAtom ruleAtom : rule.getHead()) {
                    this.ruleAtomAsserter.assertAtom(ruleAtom, binding, ds, false, this.abox, this);
                }
            }
            return -1;
        }
        int n = atoms.size();
        for (RuleAtom ruleAtom : rule.getHead()) {
            DependencySet atomDS = this.atomTester.isAtomTrue(ruleAtom, binding);
            if (atomDS != null) continue;
            atoms.add(ruleAtom);
        }
        if (atoms.size() == n && !rule.getHead().isEmpty()) {
            return -1;
        }
        if (atoms.size() == 1) {
            this.ruleAtomAsserter.assertAtom((RuleAtom)atoms.get(0), binding, ds, true, this.abox, this);
            return -1;
        }
        RuleBranch ruleBranch = new RuleBranch(this.abox, this, this.ruleAtomAsserter, atoms, binding, n, ds);
        this.addBranch(ruleBranch);
        ruleBranch.tryNext();
        return ruleBranch.getBranch();
    }

    @Override
    public void mergeTo(Node y, Node z, DependencySet ds) {
        this.merging = true;
        super.mergeTo(y, z, ds);
        if (!this.abox.isClosed() && this.interpreter != null && !y.isRootNominal()) {
            z.isRootNominal();
        }
        this.merging = false;
    }

    @Override
    public void restore(Branch branch) {
        super.restore(branch);
        this.restoreRules(branch);
    }

    @Override
    public void restoreLocal(Individual ind, Branch branch) {
        super.restoreLocal(ind, branch);
        this.restoreRules(branch);
    }

    private void restoreRules(Branch branch) {
        int total = 0;
        Iterator<Map.Entry<Pair<Rule, VariableBinding>, Integer>> ruleAppIter = this.rulesApplied.entrySet().iterator();
        while (ruleAppIter.hasNext()) {
            Map.Entry<Pair<Rule, VariableBinding>, Integer> ruleBranchEntry = ruleAppIter.next();
            if (ruleBranchEntry.getValue() <= branch.getBranch()) continue;
            ruleAppIter.remove();
            ++total;
        }
        Iterator<PartialBinding> iter = this.partialBindings.iterator();
        while (iter.hasNext()) {
            PartialBinding binding = iter.next();
            if (binding.getBranch() <= branch.getBranch()) continue;
            iter.remove();
        }
        this.interpreter.restore(branch.getBranch());
    }
}

