/*
 * Decompiled with CFR 0.152.
 */
package com.clarkparsia.pellet.rules;

import com.clarkparsia.pellet.rules.BindingGenerator;
import com.clarkparsia.pellet.rules.BindingGeneratorImpl;
import com.clarkparsia.pellet.rules.BindingGeneratorStrategy;
import com.clarkparsia.pellet.rules.BindingHelper;
import com.clarkparsia.pellet.rules.DataRangeBindingHelper;
import com.clarkparsia.pellet.rules.DatavaluePropertyBindingHelper;
import com.clarkparsia.pellet.rules.ObjectVariableBindingHelper;
import com.clarkparsia.pellet.rules.TrivialSatisfactionHelpers;
import com.clarkparsia.pellet.rules.VariableBinding;
import com.clarkparsia.pellet.rules.VariableUtils;
import com.clarkparsia.pellet.rules.builtins.BuiltIn;
import com.clarkparsia.pellet.rules.builtins.BuiltInRegistry;
import com.clarkparsia.pellet.rules.model.AtomDVariable;
import com.clarkparsia.pellet.rules.model.AtomIVariable;
import com.clarkparsia.pellet.rules.model.AtomVariable;
import com.clarkparsia.pellet.rules.model.BuiltInAtom;
import com.clarkparsia.pellet.rules.model.DataRangeAtom;
import com.clarkparsia.pellet.rules.model.DatavaluedPropertyAtom;
import com.clarkparsia.pellet.rules.model.DefaultRuleAtomVisitor;
import com.clarkparsia.pellet.rules.model.Rule;
import com.clarkparsia.pellet.rules.model.RuleAtom;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.ListIterator;
import java.util.Set;
import org.mindswap.pellet.ABox;

public class BindingGeneratorStrategyImpl
implements BindingGeneratorStrategy {
    private ABox abox;

    public BindingGeneratorStrategyImpl(ABox abox) {
        this.abox = abox;
    }

    @Override
    public BindingGenerator createGenerator(Rule rule) {
        return this.createGenerator(rule, new VariableBinding(this.abox));
    }

    @Override
    public BindingGenerator createGenerator(Rule rule, VariableBinding initialBinding) {
        BodyAtomsToSelectiveHelpersVisitor selectiveVisitor = new BodyAtomsToSelectiveHelpersVisitor();
        HashSet<AtomIVariable> instanceVariables = new HashSet<AtomIVariable>();
        HashSet<AtomDVariable> dataVariables = new HashSet<AtomDVariable>();
        for (RuleAtom ruleAtom : rule.getBody()) {
            ruleAtom.accept(selectiveVisitor);
            instanceVariables.addAll(VariableUtils.getIVars(ruleAtom));
            dataVariables.addAll(VariableUtils.getDVars(ruleAtom));
        }
        List<BindingHelper> helpers = selectiveVisitor.getHelpers();
        HashSet<? extends AtomVariable> hashSet = new HashSet<AtomVariable>();
        for (BindingHelper helper : helpers) {
            Set<AtomVariable> emptyCollection = Collections.emptySet();
            hashSet.addAll(helper.getBindableVars(emptyCollection));
        }
        for (AtomIVariable var : instanceVariables) {
            if (hashSet.contains(var)) continue;
            helpers.add(new ObjectVariableBindingHelper(this.abox, var));
        }
        helpers.addAll(new TrivialSatisfactionHelpers(this.abox).getHelpers(rule));
        if (!this.ensureOrdering(helpers, initialBinding)) {
            ABox.log.warning("IGNORING RULE " + rule + ": Could not generate safe ordering for body constraints.");
            return new BindingGeneratorImpl();
        }
        this.optimize(helpers);
        return new BindingGeneratorImpl(this.abox, initialBinding, helpers);
    }

    private boolean ensureOrdering(List<BindingHelper> helpers, VariableBinding initialBinding) {
        ArrayList<BindingHelper> unsatList = new ArrayList<BindingHelper>();
        HashSet<AtomVariable> bound = new HashSet<AtomVariable>();
        ListIterator<BindingHelper> listIter = helpers.listIterator();
        while (listIter.hasNext()) {
            BindingHelper helper = listIter.next();
            if (bound.containsAll(helper.getPrerequisiteVars(bound))) {
                bound.addAll(helper.getBindableVars(bound));
                ListIterator unsatIter = unsatList.listIterator();
                while (unsatIter.hasNext()) {
                    BindingHelper unsat = (BindingHelper)unsatIter.next();
                    if (!bound.containsAll(unsat.getPrerequisiteVars(bound))) continue;
                    listIter.add(unsat);
                    bound.addAll(unsat.getBindableVars(bound));
                    unsatIter.remove();
                }
                continue;
            }
            unsatList.add(helper);
            listIter.remove();
        }
        return unsatList.size() == 0;
    }

    private void optimize(List<BindingHelper> helpers) {
        HashSet<AtomVariable> bound = new HashSet<AtomVariable>();
        int i = 0;
        while (i < helpers.size()) {
            int j = 0;
            while (i + j < helpers.size()) {
                BindingHelper helper = helpers.get(i + j);
                if (bound.containsAll(helper.getBindableVars(bound)) && bound.containsAll(helper.getPrerequisiteVars(bound))) {
                    helpers.remove(i + j);
                    helpers.add(i, helper);
                    ++i;
                    continue;
                }
                ++j;
            }
            if (i < helpers.size()) {
                bound.addAll(helpers.get(i).getBindableVars(bound));
            }
            ++i;
        }
    }

    private class BodyAtomsToSelectiveHelpersVisitor
    extends DefaultRuleAtomVisitor {
        private List<BindingHelper> helpers = new ArrayList<BindingHelper>();

        private BodyAtomsToSelectiveHelpersVisitor() {
        }

        public List<BindingHelper> getHelpers() {
            return this.helpers;
        }

        @Override
        public void visit(BuiltInAtom atom) {
            BuiltIn builtIn = BuiltInRegistry.instance.getBuiltIn((String)atom.getPredicate());
            this.helpers.add(builtIn.createHelper(atom));
        }

        @Override
        public void visit(DataRangeAtom atom) {
            this.helpers.add(new DataRangeBindingHelper(BindingGeneratorStrategyImpl.this.abox, atom));
        }

        @Override
        public void visit(DatavaluedPropertyAtom atom) {
            this.helpers.add(new DatavaluePropertyBindingHelper(BindingGeneratorStrategyImpl.this.abox, atom));
        }
    }
}

