/*
 * Decompiled with CFR 0.152.
 */
package com.clarkparsia.pellet.rules;

import com.clarkparsia.pellet.rules.BindingGenerator;
import com.clarkparsia.pellet.rules.BindingHelper;
import com.clarkparsia.pellet.rules.VariableBinding;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.NoSuchElementException;
import org.mindswap.pellet.ABox;

public class BindingGeneratorImpl
implements BindingGenerator {
    private Collection<BindingHelper> helpers;
    private VariableBinding initialBinding;

    public BindingGeneratorImpl() {
        this.helpers = Collections.emptySet();
    }

    public BindingGeneratorImpl(ABox abox, VariableBinding initialBinding, Collection<BindingHelper> helpers) {
        this.helpers = helpers;
        this.initialBinding = initialBinding;
    }

    @Override
    public Iterator<VariableBinding> iterator() {
        return new BindingIterator();
    }

    private class BindingIterator
    implements Iterator<VariableBinding> {
        private VariableBinding binding;
        private BindingHelper[] helperChain;

        public BindingIterator() {
            this.helperChain = new BindingHelper[BindingGeneratorImpl.this.helpers.size()];
            this.helperChain = BindingGeneratorImpl.this.helpers.toArray(this.helperChain);
            if (this.helperChain.length > 0) {
                this.helperChain[0].rebind(BindingGeneratorImpl.this.initialBinding);
            }
        }

        private VariableBinding getBinding(int max) {
            VariableBinding newBinding = new VariableBinding(BindingGeneratorImpl.this.initialBinding);
            int i = 0;
            while (i <= max) {
                this.helperChain[i].setCurrentBinding(newBinding);
                ++i;
            }
            return newBinding;
        }

        @Override
        public boolean hasNext() {
            if (this.binding != null) {
                return true;
            }
            VariableBinding newBinding = null;
            int position = this.helperChain.length - 1;
            while (position >= 0) {
                if (this.helperChain[position].selectNextBinding()) {
                    if (newBinding == null) {
                        newBinding = this.getBinding(position);
                    } else {
                        this.helperChain[position].setCurrentBinding(newBinding);
                    }
                    if (position < this.helperChain.length - 1) {
                        this.helperChain[position + 1].rebind(newBinding);
                        ++position;
                        continue;
                    }
                    this.binding = newBinding;
                    return true;
                }
                newBinding = null;
                --position;
            }
            return false;
        }

        @Override
        public VariableBinding next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            VariableBinding result = this.binding;
            this.binding = null;
            return result;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }
}

