/*
 * Decompiled with CFR 0.152.
 */
package com.clarkparsia.pellet.datatypes.types.uri;

import aterm.ATermAppl;
import com.clarkparsia.pellet.datatypes.Datatype;
import com.clarkparsia.pellet.datatypes.RestrictedDatatype;
import com.clarkparsia.pellet.datatypes.exceptions.InvalidConstrainingFacetException;
import com.clarkparsia.pellet.datatypes.types.uri.XSDAnyURI;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import org.mindswap.pellet.utils.ATermUtils;

public class RestrictedURIDatatype
implements RestrictedDatatype<ATermAppl> {
    private final Datatype<ATermAppl> dt;
    private final Set<Object> excludedValues;

    public RestrictedURIDatatype(Datatype<ATermAppl> dt) {
        this(dt, Collections.emptySet());
    }

    private RestrictedURIDatatype(Datatype<ATermAppl> dt, Set<Object> excludedValues) {
        this.dt = dt;
        this.excludedValues = excludedValues;
    }

    @Override
    public RestrictedDatatype<ATermAppl> applyConstrainingFacet(ATermAppl facet, Object value) throws InvalidConstrainingFacetException {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean contains(Object value) {
        if (value instanceof ATermAppl) {
            ATermAppl a = (ATermAppl)value;
            if (this.excludedValues.contains(a)) {
                return false;
            }
            if (ATermUtils.isLiteral(a) && XSDAnyURI.NAME.equals((Object)a.getArgument(2))) {
                return true;
            }
        }
        return false;
    }

    @Override
    public boolean containsAtLeast(int n) {
        return true;
    }

    @Override
    public RestrictedDatatype<ATermAppl> exclude(Collection<?> values) {
        HashSet<Object> newExcludedValues = new HashSet<Object>(values);
        newExcludedValues.addAll(this.excludedValues);
        return new RestrictedURIDatatype(this.dt, newExcludedValues);
    }

    @Override
    public Datatype<? extends ATermAppl> getDatatype() {
        return this.dt;
    }

    @Override
    public ATermAppl getValue(int i) {
        throw new UnsupportedOperationException();
    }

    @Override
    public RestrictedDatatype<ATermAppl> intersect(RestrictedDatatype<?> other, boolean negated) {
        if (other instanceof RestrictedURIDatatype) {
            return this;
        }
        throw new IllegalArgumentException();
    }

    @Override
    public boolean isEmpty() {
        return false;
    }

    @Override
    public boolean isEnumerable() {
        return false;
    }

    @Override
    public boolean isFinite() {
        return false;
    }

    @Override
    public int size() {
        throw new IllegalStateException();
    }

    @Override
    public RestrictedDatatype<ATermAppl> union(RestrictedDatatype<?> other) {
        if (other instanceof RestrictedURIDatatype) {
            return this;
        }
        throw new IllegalArgumentException();
    }

    @Override
    public Iterator<ATermAppl> valueIterator() {
        throw new IllegalStateException();
    }
}

