/*
 * Decompiled with CFR 0.152.
 */
package com.clarkparsia.pellet.datatypes.types.text;

import aterm.ATermAppl;
import com.clarkparsia.pellet.datatypes.AbstractBaseDatatype;
import com.clarkparsia.pellet.datatypes.Datatype;
import com.clarkparsia.pellet.datatypes.RestrictedDatatype;
import com.clarkparsia.pellet.datatypes.exceptions.InvalidLiteralException;
import com.clarkparsia.pellet.datatypes.types.text.RDFPlainLiteral;
import com.clarkparsia.pellet.datatypes.types.text.RestrictedTextDatatype;
import org.mindswap.pellet.utils.ATermUtils;

public class XSDNormalizedString
extends AbstractBaseDatatype<ATermAppl> {
    private static final XSDNormalizedString instance;
    private static final RDFPlainLiteral RDF_PLAIN_LITERAL;
    private final RestrictedDatatype<ATermAppl> dataRange = new RestrictedTextDatatype((Datatype<ATermAppl>)this, "([^\\r\\n\\t])*");

    static {
        RDF_PLAIN_LITERAL = RDFPlainLiteral.getInstance();
        instance = new XSDNormalizedString();
        RestrictedTextDatatype.addPermittedDatatype(instance.getName());
    }

    public static XSDNormalizedString getInstance() {
        return instance;
    }

    private XSDNormalizedString() {
        super(ATermUtils.makeTermAppl("http://www.w3.org/2001/XMLSchema#normalizedString"));
    }

    @Override
    public RestrictedDatatype<ATermAppl> asDataRange() {
        return this.dataRange;
    }

    @Override
    public ATermAppl getCanonicalRepresentation(ATermAppl input) throws InvalidLiteralException {
        return this.getValue(input);
    }

    @Override
    public ATermAppl getLiteral(Object value) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Datatype<?> getPrimitiveDatatype() {
        return RDF_PLAIN_LITERAL;
    }

    @Override
    public ATermAppl getValue(ATermAppl literal) throws InvalidLiteralException {
        String lexicalForm = this.getLexicalForm(literal);
        return RDF_PLAIN_LITERAL.getCanonicalRepresentation(ATermUtils.makePlainLiteral(lexicalForm));
    }

    @Override
    public boolean isPrimitive() {
        return false;
    }
}

