/*
 * Decompiled with CFR 0.152.
 */
package com.clarkparsia.pellet.datatypes.types.text;

import aterm.ATermAppl;
import com.clarkparsia.pellet.datatypes.AbstractBaseDatatype;
import com.clarkparsia.pellet.datatypes.Datatype;
import com.clarkparsia.pellet.datatypes.RestrictedDatatype;
import com.clarkparsia.pellet.datatypes.exceptions.InvalidLiteralException;
import com.clarkparsia.pellet.datatypes.types.text.RDFPlainLiteral;
import com.clarkparsia.pellet.datatypes.types.text.RestrictedTextDatatype;
import org.mindswap.pellet.utils.ATermUtils;

public class XSDName
extends AbstractBaseDatatype<ATermAppl> {
    private static final XSDName instance;
    private static final RDFPlainLiteral RDF_PLAIN_LITERAL;
    private final RestrictedDatatype<ATermAppl> dataRange = new RestrictedTextDatatype((Datatype<ATermAppl>)this, "(:|[A-Z]|_|[a-z]|[\u00c0-\u00d6]|[\u00d8-\u00f6]|[\u00f8-\u02ff]|[\u0370-\u037d]|[\u037f-\u1fff]|[\u200c-\u200d]|[\u2070-\u218f]|[\u2c00-\u2fef]|[\u3001-\ud7ff]|[\uf900-\ufdcf]|[\ufdf0-\ufffd])(:|[A-Z]|_|[a-z]|[\u00c0-\u00d6]|[\u00d8-\u00f6]|[\u00f8-\u02ff]|[\u0370-\u037d]|[\u037f-\u1fff]|[\u200c-\u200d]|[\u2070-\u218f]|[\u2c00-\u2fef]|[\u3001-\ud7ff]|[\uf900-\ufdcf]|[\ufdf0-\ufffd]|-|\\.|[0-9]|\u00b7|[\u0300-\u036f]|[\u203f-\u2040])*");

    static {
        RDF_PLAIN_LITERAL = RDFPlainLiteral.getInstance();
        instance = new XSDName();
        RestrictedTextDatatype.addPermittedDatatype(instance.getName());
    }

    public static XSDName getInstance() {
        return instance;
    }

    private XSDName() {
        super(ATermUtils.makeTermAppl("http://www.w3.org/2001/XMLSchema#Name"));
    }

    @Override
    public RestrictedDatatype<ATermAppl> asDataRange() {
        return this.dataRange;
    }

    @Override
    public ATermAppl getCanonicalRepresentation(ATermAppl input) throws InvalidLiteralException {
        return this.getValue(input);
    }

    @Override
    public ATermAppl getLiteral(Object value) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Datatype<?> getPrimitiveDatatype() {
        return RDF_PLAIN_LITERAL;
    }

    @Override
    public ATermAppl getValue(ATermAppl literal) throws InvalidLiteralException {
        String lexicalForm = this.getLexicalForm(literal);
        return RDF_PLAIN_LITERAL.getCanonicalRepresentation(ATermUtils.makePlainLiteral(lexicalForm));
    }

    @Override
    public boolean isPrimitive() {
        return false;
    }
}

