/*
 * Decompiled with CFR 0.152.
 */
package com.clarkparsia.pellet.datatypes.types.text;

import aterm.ATermAppl;
import com.clarkparsia.pellet.datatypes.AbstractBaseDatatype;
import com.clarkparsia.pellet.datatypes.Datatype;
import com.clarkparsia.pellet.datatypes.RestrictedDatatype;
import com.clarkparsia.pellet.datatypes.exceptions.InvalidLiteralException;
import com.clarkparsia.pellet.datatypes.types.text.RDFPlainLiteral;
import com.clarkparsia.pellet.datatypes.types.text.RestrictedTextDatatype;
import org.mindswap.pellet.utils.ATermUtils;

public class XSDLanguage
extends AbstractBaseDatatype<ATermAppl> {
    private static final XSDLanguage instance;
    private static final RDFPlainLiteral RDF_PLAIN_LITERAL;
    private final RestrictedDatatype<ATermAppl> dataRange = new RestrictedTextDatatype((Datatype<ATermAppl>)this, "[a-zA-Z]{1,8}(-[a-zA-Z0-9]{1,8})*");

    static {
        RDF_PLAIN_LITERAL = RDFPlainLiteral.getInstance();
        instance = new XSDLanguage();
        RestrictedTextDatatype.addPermittedDatatype(instance.getName());
    }

    public static XSDLanguage getInstance() {
        return instance;
    }

    private XSDLanguage() {
        super(ATermUtils.makeTermAppl("http://www.w3.org/2001/XMLSchema#language"));
    }

    @Override
    public RestrictedDatatype<ATermAppl> asDataRange() {
        return this.dataRange;
    }

    @Override
    public ATermAppl getCanonicalRepresentation(ATermAppl input) throws InvalidLiteralException {
        return this.getValue(input);
    }

    @Override
    public ATermAppl getLiteral(Object value) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Datatype<?> getPrimitiveDatatype() {
        return RDF_PLAIN_LITERAL;
    }

    @Override
    public ATermAppl getValue(ATermAppl literal) throws InvalidLiteralException {
        String lexicalForm = this.getLexicalForm(literal);
        return RDF_PLAIN_LITERAL.getCanonicalRepresentation(ATermUtils.makePlainLiteral(lexicalForm));
    }

    @Override
    public boolean isPrimitive() {
        return false;
    }
}

