/*
 * Decompiled with CFR 0.152.
 */
package com.clarkparsia.pellet.datatypes.types.real;

import com.clarkparsia.pellet.datatypes.exceptions.InvalidLiteralException;
import com.clarkparsia.pellet.datatypes.types.real.AbstractDerivedIntegerType;
import javax.xml.bind.DatatypeConverter;
import org.mindswap.pellet.utils.ATermUtils;

public class XSDUnsignedShort
extends AbstractDerivedIntegerType {
    private static final XSDUnsignedShort instance;
    private static final int MAX_VALUE;

    static {
        MAX_VALUE = 65535;
        instance = new XSDUnsignedShort();
    }

    public static XSDUnsignedShort getInstance() {
        return instance;
    }

    private XSDUnsignedShort() {
        super(ATermUtils.makeTermAppl("http://www.w3.org/2001/XMLSchema#unsignedShort"), 0, MAX_VALUE);
    }

    @Override
    protected Number fromLexicalForm(String lexicalForm) throws InvalidLiteralException {
        try {
            int i = DatatypeConverter.parseInt((String)lexicalForm);
            if (i < 0) {
                throw new InvalidLiteralException(this.getName(), lexicalForm);
            }
            if (i > MAX_VALUE) {
                throw new InvalidLiteralException(this.getName(), lexicalForm);
            }
            return i;
        }
        catch (NumberFormatException e) {
            throw new InvalidLiteralException(this.getName(), lexicalForm);
        }
    }
}

