/*
 * Decompiled with CFR 0.152.
 */
package com.clarkparsia.pellet.datatypes.types.real;

import com.clarkparsia.pellet.datatypes.exceptions.InvalidLiteralException;
import com.clarkparsia.pellet.datatypes.types.real.AbstractDerivedIntegerType;
import java.math.BigInteger;
import javax.xml.bind.DatatypeConverter;
import org.mindswap.pellet.utils.ATermUtils;

public class XSDUnsignedLong
extends AbstractDerivedIntegerType {
    private static final XSDUnsignedLong instance;
    private static final BigInteger MAX_VALUE;

    static {
        MAX_VALUE = new BigInteger("18446744073709551615");
        instance = new XSDUnsignedLong();
    }

    public static XSDUnsignedLong getInstance() {
        return instance;
    }

    private XSDUnsignedLong() {
        super(ATermUtils.makeTermAppl("http://www.w3.org/2001/XMLSchema#unsignedLong"), 0, MAX_VALUE);
    }

    @Override
    protected Number fromLexicalForm(String lexicalForm) throws InvalidLiteralException {
        try {
            BigInteger n = DatatypeConverter.parseInteger((String)lexicalForm);
            if (BigInteger.ZERO.compareTo(n) > 0) {
                throw new InvalidLiteralException(this.getName(), lexicalForm);
            }
            if (MAX_VALUE.compareTo(n) < 0) {
                throw new InvalidLiteralException(this.getName(), lexicalForm);
            }
            return n;
        }
        catch (NumberFormatException e) {
            throw new InvalidLiteralException(this.getName(), lexicalForm);
        }
    }
}

