/*
 * Decompiled with CFR 0.152.
 */
package com.clarkparsia.pellet.datatypes.types.real;

import com.clarkparsia.pellet.datatypes.exceptions.InvalidLiteralException;
import com.clarkparsia.pellet.datatypes.types.real.AbstractDerivedIntegerType;
import javax.xml.bind.DatatypeConverter;
import org.mindswap.pellet.utils.ATermUtils;

public class XSDUnsignedInt
extends AbstractDerivedIntegerType {
    private static final XSDUnsignedInt instance;
    private static final long MAX_VALUE;

    static {
        MAX_VALUE = 0xFFFFFFFFL;
        instance = new XSDUnsignedInt();
    }

    public static XSDUnsignedInt getInstance() {
        return instance;
    }

    private XSDUnsignedInt() {
        super(ATermUtils.makeTermAppl("http://www.w3.org/2001/XMLSchema#unsignedInt"), 0, MAX_VALUE);
    }

    @Override
    protected Number fromLexicalForm(String lexicalForm) throws InvalidLiteralException {
        try {
            long l = DatatypeConverter.parseLong((String)lexicalForm);
            if (l < 0L) {
                throw new InvalidLiteralException(this.getName(), lexicalForm);
            }
            if (l > MAX_VALUE) {
                throw new InvalidLiteralException(this.getName(), lexicalForm);
            }
            return l;
        }
        catch (NumberFormatException e) {
            throw new InvalidLiteralException(this.getName(), lexicalForm);
        }
    }
}

