/*
 * Decompiled with CFR 0.152.
 */
package com.clarkparsia.pellet.datatypes.types.bool;

import aterm.ATermAppl;
import com.clarkparsia.pellet.datatypes.AbstractBaseDatatype;
import com.clarkparsia.pellet.datatypes.Datatype;
import com.clarkparsia.pellet.datatypes.Datatypes;
import com.clarkparsia.pellet.datatypes.RestrictedDatatype;
import com.clarkparsia.pellet.datatypes.exceptions.InvalidLiteralException;
import com.clarkparsia.pellet.datatypes.types.bool.RestrictedBooleanDatatype;
import com.clarkparsia.pellet.utils.TermFactory;

public class XSDBoolean
extends AbstractBaseDatatype<Boolean> {
    private static final ATermAppl CANONICAL_FALSE_TERM;
    private static final ATermAppl CANONICAL_TRUE_TERM;
    private static final XSDBoolean instance;
    private static final ATermAppl NAME;
    private final RestrictedBooleanDatatype dataRange = new RestrictedBooleanDatatype(this);

    static {
        NAME = Datatypes.BOOLEAN;
        CANONICAL_TRUE_TERM = TermFactory.literal(true);
        CANONICAL_FALSE_TERM = TermFactory.literal(false);
        instance = new XSDBoolean();
    }

    public static XSDBoolean getInstance() {
        return instance;
    }

    private XSDBoolean() {
        super(NAME);
    }

    @Override
    public RestrictedDatatype<Boolean> asDataRange() {
        return this.dataRange;
    }

    @Override
    public ATermAppl getCanonicalRepresentation(ATermAppl input) throws InvalidLiteralException {
        if (input == CANONICAL_FALSE_TERM || input == CANONICAL_TRUE_TERM) {
            return input;
        }
        return this.getLiteral(this.getValue(input));
    }

    @Override
    public ATermAppl getLiteral(Object value) {
        if (value instanceof Boolean) {
            return (Boolean)value != false ? CANONICAL_TRUE_TERM : CANONICAL_FALSE_TERM;
        }
        throw new IllegalArgumentException();
    }

    @Override
    public Datatype<?> getPrimitiveDatatype() {
        return this;
    }

    @Override
    public Boolean getValue(ATermAppl literal) throws InvalidLiteralException {
        String lexicalForm = this.getLexicalForm(literal).trim();
        if (lexicalForm.equals("true") || lexicalForm.equals("1")) {
            return Boolean.TRUE;
        }
        if (lexicalForm.equals("false") || lexicalForm.equals("0")) {
            return Boolean.FALSE;
        }
        throw new InvalidLiteralException(this.getName(), lexicalForm);
    }

    @Override
    public boolean isPrimitive() {
        return true;
    }
}

