/*
 * Decompiled with CFR 0.152.
 */
package com.clarkparsia.pellet.datatypes;

import aterm.ATermAppl;
import com.clarkparsia.pellet.datatypes.Datatype;
import com.clarkparsia.pellet.datatypes.IEEEFloatType;
import com.clarkparsia.pellet.datatypes.RestrictedDatatype;
import com.clarkparsia.pellet.datatypes.RestrictedFloatingPointDatatype;
import com.clarkparsia.pellet.datatypes.exceptions.InvalidLiteralException;
import java.util.logging.Logger;
import javax.xml.bind.DatatypeConverter;
import org.mindswap.pellet.utils.ATermUtils;

public class XSDFloat
implements Datatype<Float> {
    private static final XSDFloat instance;
    private static final Logger log;
    private final RestrictedFloatingPointDatatype<Float> dataRange;
    private final int hashCode;
    private final ATermAppl name = ATermUtils.makeTermAppl("http://www.w3.org/2001/XMLSchema#float");

    static {
        log = Logger.getLogger(XSDFloat.class.getCanonicalName());
        instance = new XSDFloat();
    }

    public static XSDFloat getInstance() {
        return instance;
    }

    private XSDFloat() {
        this.hashCode = this.name.hashCode();
        this.dataRange = new RestrictedFloatingPointDatatype<Float>(this, IEEEFloatType.getInstance());
    }

    @Override
    public RestrictedDatatype<Float> asDataRange() {
        return this.dataRange;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        return this.getClass() == obj.getClass();
    }

    @Override
    public ATermAppl getCanonicalRepresentation(ATermAppl input) throws InvalidLiteralException {
        if (!ATermUtils.isLiteral(input)) {
            throw new IllegalArgumentException();
        }
        if (!input.getArgument(2).equals((Object)this.name)) {
            throw new IllegalArgumentException();
        }
        String lexicalForm = ATermUtils.getLiteralValue(input);
        try {
            Float f = Float.valueOf(DatatypeConverter.parseFloat((String)lexicalForm));
            String canonicalForm = DatatypeConverter.printFloat((float)f.floatValue());
            if (canonicalForm.equals(lexicalForm)) {
                return input;
            }
            return ATermUtils.makeTypedLiteral(canonicalForm, this.name);
        }
        catch (NumberFormatException e) {
            log.severe(String.format("Number format exception (%s) cause while parsing float %s", e.getMessage(), lexicalForm));
            throw new InvalidLiteralException(this.name, lexicalForm);
        }
    }

    @Override
    public ATermAppl getLiteral(Object value) {
        if (IEEEFloatType.getInstance().isInstance(value)) {
            return ATermUtils.makeTypedLiteral(DatatypeConverter.printFloat((float)IEEEFloatType.getInstance().cast(value).floatValue()), this.name);
        }
        throw new IllegalArgumentException();
    }

    @Override
    public ATermAppl getName() {
        return this.name;
    }

    @Override
    public Datatype<?> getPrimitiveDatatype() {
        return this;
    }

    @Override
    public Float getValue(ATermAppl literal) throws InvalidLiteralException {
        if (!ATermUtils.isLiteral(literal)) {
            throw new IllegalArgumentException();
        }
        if (!literal.getArgument(2).equals((Object)this.name)) {
            throw new IllegalArgumentException();
        }
        String lexicalForm = ATermUtils.getLiteralValue(literal);
        try {
            return Float.valueOf(DatatypeConverter.parseFloat((String)lexicalForm));
        }
        catch (NumberFormatException e) {
            throw new InvalidLiteralException(this.name, lexicalForm);
        }
    }

    public int hashCode() {
        return this.hashCode;
    }

    @Override
    public boolean isPrimitive() {
        return true;
    }
}

