/*
 * Decompiled with CFR 0.152.
 */
package com.clarkparsia.pellet.datatypes;

import aterm.ATermAppl;
import com.clarkparsia.pellet.datatypes.Datatype;
import com.clarkparsia.pellet.datatypes.RestrictedDatatype;
import com.clarkparsia.pellet.datatypes.exceptions.InvalidLiteralException;
import org.mindswap.pellet.utils.ATermUtils;

class NamedDatatype<T>
implements Datatype<T> {
    private final ATermAppl name;
    private final RestrictedDatatype<T> range;

    NamedDatatype(ATermAppl name, RestrictedDatatype<T> range) {
        if (name == null) {
            throw new NullPointerException();
        }
        if (name.getArity() != 0) {
            throw new IllegalArgumentException();
        }
        this.name = name;
        this.range = range;
    }

    @Override
    public RestrictedDatatype<T> asDataRange() {
        return this.range;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        NamedDatatype other = (NamedDatatype)obj;
        return !(this.name == null ? other.name != null : !this.name.equals((Object)other.name));
    }

    @Override
    public ATermAppl getCanonicalRepresentation(ATermAppl input) throws InvalidLiteralException {
        return this.range.getDatatype().getCanonicalRepresentation(input);
    }

    @Override
    public ATermAppl getLiteral(Object value) {
        ATermAppl a;
        if (value instanceof ATermAppl && ATermUtils.isLiteral(a = (ATermAppl)value) && this.name.equals((Object)a.getArgument(2))) {
            return a;
        }
        throw new IllegalArgumentException();
    }

    @Override
    public ATermAppl getName() {
        return this.name;
    }

    @Override
    public Datatype<?> getPrimitiveDatatype() {
        return this.range.getDatatype().getPrimitiveDatatype();
    }

    @Override
    public T getValue(ATermAppl literal) throws InvalidLiteralException {
        T value = this.range.getDatatype().getValue(literal);
        if (!this.range.contains(value)) {
            throw new InvalidLiteralException(this.name, literal.getArgument(0).toString());
        }
        return value;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.name == null ? 0 : this.name.hashCode());
        return result;
    }

    @Override
    public boolean isPrimitive() {
        return false;
    }

    public String toString() {
        return this.name.getName();
    }
}

