/*
 * Decompiled with CFR 0.152.
 */
package com.clarkparsia.pellet.datatypes;

import aterm.ATermAppl;
import com.clarkparsia.pellet.datatypes.Datatype;
import com.clarkparsia.pellet.datatypes.RestrictedDatatype;
import com.clarkparsia.pellet.datatypes.exceptions.InvalidConstrainingFacetException;
import com.clarkparsia.pellet.datatypes.exceptions.InvalidLiteralException;
import java.lang.ref.WeakReference;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import java.util.WeakHashMap;
import org.mindswap.pellet.utils.ATermUtils;

public class InfiniteNamedDatatype
implements Datatype<ATermAppl> {
    private static final Map<ATermAppl, WeakReference<InfiniteNamedDatatype>> cache = new WeakHashMap<ATermAppl, WeakReference<InfiniteNamedDatatype>>();
    private final ATermAppl name;
    private final RestrictedDatatype<ATermAppl> range;

    public static InfiniteNamedDatatype get(ATermAppl dtName) {
        InfiniteNamedDatatype dt;
        WeakReference<InfiniteNamedDatatype> dtRef = cache.get(dtName);
        InfiniteNamedDatatype infiniteNamedDatatype = dt = dtRef == null ? null : (InfiniteNamedDatatype)dtRef.get();
        if (dt == null) {
            dt = new InfiniteNamedDatatype(dtName);
            cache.put(dtName, new WeakReference<InfiniteNamedDatatype>(dt));
        }
        return dt;
    }

    private InfiniteNamedDatatype(ATermAppl name) {
        if (name == null) {
            throw new NullPointerException();
        }
        if (name.getArity() != 0) {
            throw new IllegalArgumentException();
        }
        this.name = name;
        this.range = new RestrictedDatatype<ATermAppl>(){

            @Override
            public RestrictedDatatype<ATermAppl> applyConstrainingFacet(ATermAppl facet, Object value) throws InvalidConstrainingFacetException {
                throw new UnsupportedOperationException();
            }

            @Override
            public boolean contains(Object value) {
                ATermAppl a;
                if (value instanceof ATermAppl && ATermUtils.isLiteral(a = (ATermAppl)value)) {
                    ATermAppl dt = (ATermAppl)a.getArgument(2);
                    return InfiniteNamedDatatype.this.name.equals((Object)dt);
                }
                return false;
            }

            @Override
            public boolean containsAtLeast(int n) {
                return true;
            }

            @Override
            public RestrictedDatatype<ATermAppl> exclude(Collection<?> values) {
                throw new UnsupportedOperationException();
            }

            @Override
            public Datatype<? extends ATermAppl> getDatatype() {
                return InfiniteNamedDatatype.this;
            }

            @Override
            public ATermAppl getValue(int i) {
                throw new UnsupportedOperationException();
            }

            @Override
            public RestrictedDatatype<ATermAppl> intersect(RestrictedDatatype<?> other, boolean negated) {
                if (other == this) {
                    return this;
                }
                throw new IllegalArgumentException();
            }

            @Override
            public boolean isEmpty() {
                return false;
            }

            @Override
            public boolean isEnumerable() {
                return false;
            }

            @Override
            public boolean isFinite() {
                return false;
            }

            @Override
            public int size() {
                throw new UnsupportedOperationException();
            }

            @Override
            public RestrictedDatatype<ATermAppl> union(RestrictedDatatype<?> other) {
                if (other == this) {
                    return this;
                }
                throw new IllegalArgumentException();
            }

            @Override
            public Iterator<ATermAppl> valueIterator() {
                throw new UnsupportedOperationException();
            }
        };
    }

    @Override
    public RestrictedDatatype<ATermAppl> asDataRange() {
        return this.range;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        InfiniteNamedDatatype other = (InfiniteNamedDatatype)obj;
        return !(this.name == null ? other.name != null : !this.name.equals((Object)other.name));
    }

    @Override
    public ATermAppl getCanonicalRepresentation(ATermAppl input) throws InvalidLiteralException {
        if (!ATermUtils.isLiteral(input)) {
            throw new IllegalArgumentException();
        }
        if (!this.name.equals((Object)input.getArgument(2))) {
            throw new IllegalArgumentException();
        }
        return input;
    }

    @Override
    public ATermAppl getLiteral(Object value) {
        ATermAppl a;
        if (value instanceof ATermAppl && ATermUtils.isLiteral(a = (ATermAppl)value) && this.name.equals((Object)a.getArgument(2))) {
            return a;
        }
        throw new IllegalArgumentException();
    }

    @Override
    public ATermAppl getName() {
        return this.name;
    }

    @Override
    public Datatype<?> getPrimitiveDatatype() {
        return this;
    }

    @Override
    public ATermAppl getValue(ATermAppl literal) throws InvalidLiteralException {
        if (!ATermUtils.isLiteral(literal)) {
            throw new IllegalArgumentException();
        }
        if (!this.name.equals((Object)literal.getArgument(2))) {
            throw new IllegalArgumentException();
        }
        return literal;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.name == null ? 0 : this.name.hashCode());
        return result;
    }

    @Override
    public boolean isPrimitive() {
        return true;
    }

    public String toString() {
        return this.name.getName();
    }
}

