/*
 * Decompiled with CFR 0.152.
 */
package com.clarkparsia.pellet.datatypes;

import aterm.ATermAppl;
import aterm.ATermList;
import com.clarkparsia.pellet.datatypes.DNF;
import com.clarkparsia.pellet.datatypes.DataRange;
import com.clarkparsia.pellet.datatypes.DataValueEnumeration;
import com.clarkparsia.pellet.datatypes.Datatype;
import com.clarkparsia.pellet.datatypes.DatatypeReasoner;
import com.clarkparsia.pellet.datatypes.EmptyDataRange;
import com.clarkparsia.pellet.datatypes.InfiniteNamedDatatype;
import com.clarkparsia.pellet.datatypes.NamedDataRangeExpander;
import com.clarkparsia.pellet.datatypes.NamedDatatype;
import com.clarkparsia.pellet.datatypes.NegatedDataRange;
import com.clarkparsia.pellet.datatypes.RestrictedDatatype;
import com.clarkparsia.pellet.datatypes.UnionDataRange;
import com.clarkparsia.pellet.datatypes.exceptions.InvalidConstrainingFacetException;
import com.clarkparsia.pellet.datatypes.exceptions.InvalidLiteralException;
import com.clarkparsia.pellet.datatypes.exceptions.UnrecognizedDatatypeException;
import com.clarkparsia.pellet.datatypes.types.bool.XSDBoolean;
import com.clarkparsia.pellet.datatypes.types.datetime.XSDDate;
import com.clarkparsia.pellet.datatypes.types.datetime.XSDDateTime;
import com.clarkparsia.pellet.datatypes.types.datetime.XSDDateTimeStamp;
import com.clarkparsia.pellet.datatypes.types.datetime.XSDGDay;
import com.clarkparsia.pellet.datatypes.types.datetime.XSDGMonth;
import com.clarkparsia.pellet.datatypes.types.datetime.XSDGMonthDay;
import com.clarkparsia.pellet.datatypes.types.datetime.XSDGYear;
import com.clarkparsia.pellet.datatypes.types.datetime.XSDGYearMonth;
import com.clarkparsia.pellet.datatypes.types.datetime.XSDTime;
import com.clarkparsia.pellet.datatypes.types.duration.XSDDuration;
import com.clarkparsia.pellet.datatypes.types.floating.XSDDouble;
import com.clarkparsia.pellet.datatypes.types.floating.XSDFloat;
import com.clarkparsia.pellet.datatypes.types.real.OWLRational;
import com.clarkparsia.pellet.datatypes.types.real.OWLReal;
import com.clarkparsia.pellet.datatypes.types.real.XSDByte;
import com.clarkparsia.pellet.datatypes.types.real.XSDDecimal;
import com.clarkparsia.pellet.datatypes.types.real.XSDInt;
import com.clarkparsia.pellet.datatypes.types.real.XSDInteger;
import com.clarkparsia.pellet.datatypes.types.real.XSDLong;
import com.clarkparsia.pellet.datatypes.types.real.XSDNegativeInteger;
import com.clarkparsia.pellet.datatypes.types.real.XSDNonNegativeInteger;
import com.clarkparsia.pellet.datatypes.types.real.XSDNonPositiveInteger;
import com.clarkparsia.pellet.datatypes.types.real.XSDPositiveInteger;
import com.clarkparsia.pellet.datatypes.types.real.XSDShort;
import com.clarkparsia.pellet.datatypes.types.real.XSDUnsignedByte;
import com.clarkparsia.pellet.datatypes.types.real.XSDUnsignedInt;
import com.clarkparsia.pellet.datatypes.types.real.XSDUnsignedLong;
import com.clarkparsia.pellet.datatypes.types.real.XSDUnsignedShort;
import com.clarkparsia.pellet.datatypes.types.text.RDFPlainLiteral;
import com.clarkparsia.pellet.datatypes.types.text.XSDLanguage;
import com.clarkparsia.pellet.datatypes.types.text.XSDNCName;
import com.clarkparsia.pellet.datatypes.types.text.XSDNMToken;
import com.clarkparsia.pellet.datatypes.types.text.XSDName;
import com.clarkparsia.pellet.datatypes.types.text.XSDNormalizedString;
import com.clarkparsia.pellet.datatypes.types.text.XSDString;
import com.clarkparsia.pellet.datatypes.types.text.XSDToken;
import com.clarkparsia.pellet.datatypes.types.uri.XSDAnyURI;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.mindswap.pellet.Literal;
import org.mindswap.pellet.PelletOptions;
import org.mindswap.pellet.utils.ATermUtils;

public class DatatypeReasonerImpl
implements DatatypeReasoner {
    private static final Map<ATermAppl, Datatype<?>> coreDatatypes;
    private static final DataRange<?> EMPTY_RANGE;
    private static final Logger log;
    private static final DataRange<?> TRIVIALLY_SATISFIABLE;
    private final Set<ATermAppl> declaredUndefined = new HashSet<ATermAppl>();
    private final NamedDataRangeExpander expander = new NamedDataRangeExpander();
    private final Map<ATermAppl, ATermAppl> namedDataRanges = new HashMap<ATermAppl, ATermAppl>();

    static {
        log = Logger.getLogger(DatatypeReasonerImpl.class.getCanonicalName());
        coreDatatypes = new HashMap();
        coreDatatypes.put(RDFPlainLiteral.getInstance().getName(), RDFPlainLiteral.getInstance());
        coreDatatypes.put(XSDString.getInstance().getName(), XSDString.getInstance());
        coreDatatypes.put(XSDNormalizedString.getInstance().getName(), XSDNormalizedString.getInstance());
        coreDatatypes.put(XSDToken.getInstance().getName(), XSDToken.getInstance());
        coreDatatypes.put(XSDLanguage.getInstance().getName(), XSDLanguage.getInstance());
        coreDatatypes.put(XSDNMToken.getInstance().getName(), XSDNMToken.getInstance());
        coreDatatypes.put(XSDName.getInstance().getName(), XSDName.getInstance());
        coreDatatypes.put(XSDNCName.getInstance().getName(), XSDNCName.getInstance());
        coreDatatypes.put(XSDBoolean.getInstance().getName(), XSDBoolean.getInstance());
        coreDatatypes.put(OWLReal.getInstance().getName(), OWLReal.getInstance());
        coreDatatypes.put(OWLRational.getInstance().getName(), OWLRational.getInstance());
        coreDatatypes.put(XSDDecimal.getInstance().getName(), XSDDecimal.getInstance());
        coreDatatypes.put(XSDInteger.getInstance().getName(), XSDInteger.getInstance());
        coreDatatypes.put(XSDLong.getInstance().getName(), XSDLong.getInstance());
        coreDatatypes.put(XSDInt.getInstance().getName(), XSDInt.getInstance());
        coreDatatypes.put(XSDShort.getInstance().getName(), XSDShort.getInstance());
        coreDatatypes.put(XSDByte.getInstance().getName(), XSDByte.getInstance());
        coreDatatypes.put(XSDNonNegativeInteger.getInstance().getName(), XSDNonNegativeInteger.getInstance());
        coreDatatypes.put(XSDNonPositiveInteger.getInstance().getName(), XSDNonPositiveInteger.getInstance());
        coreDatatypes.put(XSDNegativeInteger.getInstance().getName(), XSDNegativeInteger.getInstance());
        coreDatatypes.put(XSDPositiveInteger.getInstance().getName(), XSDPositiveInteger.getInstance());
        coreDatatypes.put(XSDUnsignedLong.getInstance().getName(), XSDUnsignedLong.getInstance());
        coreDatatypes.put(XSDUnsignedInt.getInstance().getName(), XSDUnsignedInt.getInstance());
        coreDatatypes.put(XSDUnsignedShort.getInstance().getName(), XSDUnsignedShort.getInstance());
        coreDatatypes.put(XSDUnsignedByte.getInstance().getName(), XSDUnsignedByte.getInstance());
        coreDatatypes.put(XSDDouble.getInstance().getName(), XSDDouble.getInstance());
        coreDatatypes.put(XSDFloat.getInstance().getName(), XSDFloat.getInstance());
        coreDatatypes.put(XSDDateTime.getInstance().getName(), XSDDateTime.getInstance());
        coreDatatypes.put(XSDDateTimeStamp.getInstance().getName(), XSDDateTimeStamp.getInstance());
        coreDatatypes.put(XSDDate.getInstance().getName(), XSDDate.getInstance());
        coreDatatypes.put(XSDGYearMonth.getInstance().getName(), XSDGYearMonth.getInstance());
        coreDatatypes.put(XSDGMonthDay.getInstance().getName(), XSDGMonthDay.getInstance());
        coreDatatypes.put(XSDGYear.getInstance().getName(), XSDGYear.getInstance());
        coreDatatypes.put(XSDGMonth.getInstance().getName(), XSDGMonth.getInstance());
        coreDatatypes.put(XSDGDay.getInstance().getName(), XSDGDay.getInstance());
        coreDatatypes.put(XSDTime.getInstance().getName(), XSDTime.getInstance());
        coreDatatypes.put(XSDDuration.getInstance().getName(), XSDDuration.getInstance());
        coreDatatypes.put(XSDAnyURI.getInstance().getName(), XSDAnyURI.getInstance());
        EMPTY_RANGE = new EmptyDataRange();
        TRIVIALLY_SATISFIABLE = new DataRange<Object>(){

            @Override
            public boolean contains(Object value) {
                return true;
            }

            @Override
            public boolean containsAtLeast(int n) {
                return true;
            }

            public boolean equals(Object obj) {
                return this == obj;
            }

            @Override
            public Object getValue(int i) {
                throw new UnsupportedOperationException();
            }

            public int hashCode() {
                return super.hashCode();
            }

            @Override
            public boolean isEmpty() {
                return false;
            }

            @Override
            public boolean isEnumerable() {
                return false;
            }

            @Override
            public boolean isFinite() {
                return false;
            }

            @Override
            public int size() {
                throw new UnsupportedOperationException();
            }

            @Override
            public Iterator<Object> valueIterator() {
                throw new UnsupportedOperationException();
            }
        };
    }

    private static <T> DataValueEnumeration<? extends T> findSmallestEnumeration(Collection<DataValueEnumeration<? extends T>> ranges) {
        DataValueEnumeration<T> ret = null;
        int best = Integer.MAX_VALUE;
        for (DataValueEnumeration<T> r : ranges) {
            DataValueEnumeration<T> e = r;
            int s = e.size();
            if (s >= best) continue;
            ret = e;
            best = s;
        }
        return ret;
    }

    private static final ATermAppl getDatatypeName(ATermAppl literal) {
        if (!ATermUtils.isLiteral(literal)) {
            String msg = "Method expected an ATermAppl literal as an argument";
            log.severe("Method expected an ATermAppl literal as an argument");
            throw new IllegalArgumentException("Method expected an ATermAppl literal as an argument");
        }
        ATermAppl dtName = (ATermAppl)literal.getArgument(2);
        if (ATermUtils.EMPTY.equals((Object)dtName)) {
            String msg = "Untyped literals not supported by this datatype reasoner";
            log.severe("Untyped literals not supported by this datatype reasoner");
            throw new IllegalArgumentException("Untyped literals not supported by this datatype reasoner");
        }
        return dtName;
    }

    private static int inequalityCount(Set<Integer>[] nes, int xIndex) {
        Set<Integer> others = nes[xIndex];
        return others == null ? 0 : others.size();
    }

    private static <T> void partitionDConjunction(Collection<DataRange<? extends T>> dconjunction, Set<DataValueEnumeration<? extends T>> positiveEnumerations, Set<DataValueEnumeration<? extends T>> negativeEnumerations, Set<RestrictedDatatype<? extends T>> positiveRestrictions, Set<RestrictedDatatype<? extends T>> negativeRestrictions) {
        for (DataRange<T> dataRange : dconjunction) {
            if (dataRange instanceof DataValueEnumeration) {
                positiveEnumerations.add((DataValueEnumeration)dataRange);
                continue;
            }
            if (dataRange instanceof RestrictedDatatype) {
                positiveRestrictions.add((RestrictedDatatype)dataRange);
                continue;
            }
            if (dataRange instanceof NegatedDataRange) {
                DataRange ndr = ((NegatedDataRange)dataRange).getDataRange();
                if (ndr instanceof DataValueEnumeration) {
                    negativeEnumerations.add((DataValueEnumeration)ndr);
                    continue;
                }
                if (ndr instanceof RestrictedDatatype) {
                    negativeRestrictions.add((RestrictedDatatype)ndr);
                    continue;
                }
                if (dataRange == TRIVIALLY_SATISFIABLE) continue;
                log.warning("Unknown datatype: " + dataRange);
                continue;
            }
            if (dataRange == TRIVIALLY_SATISFIABLE) continue;
            log.warning("Unknown datatype: " + dataRange);
        }
    }

    private static boolean removeInequalities(Set<Integer>[] nes, int xIndex) {
        Set<Integer> others = nes[xIndex];
        if (others == null) {
            return false;
        }
        for (Integer yIndex : others) {
            Set<Integer> s = nes[yIndex];
            if (s == null) {
                throw new IllegalStateException();
            }
            if (s.remove(xIndex)) continue;
            throw new IllegalStateException();
        }
        return true;
    }

    private boolean containedIn(Object value, ATermAppl dconjunction) throws InvalidConstrainingFacetException, InvalidLiteralException, UnrecognizedDatatypeException {
        if (ATermUtils.isAnd(dconjunction)) {
            ATermList l = (ATermList)dconjunction.getArgument(0);
            while (!l.isEmpty()) {
                if (!this.getDataRange((ATermAppl)l.getFirst()).contains(value)) {
                    return false;
                }
                l = l.getNext();
            }
            return true;
        }
        return this.getDataRange(dconjunction).contains(value);
    }

    @Override
    public boolean containsAtLeast(int n, Collection<ATermAppl> ranges) throws UnrecognizedDatatypeException, InvalidConstrainingFacetException, InvalidLiteralException {
        ATermAppl and = ATermUtils.makeAnd(ATermUtils.makeList(ranges));
        ATermAppl dnf = DNF.dnf(this.expander.expand(and, this.namedDataRanges));
        if (ATermUtils.isOr(dnf)) {
            ArrayList disjuncts = new ArrayList();
            ATermList l = (ATermList)dnf.getArgument(0);
            while (!l.isEmpty()) {
                DataRange<?> dr = this.normalizeVarRanges((ATermAppl)l.getFirst());
                if (!dr.isEmpty()) {
                    disjuncts.add(dr);
                }
                l = l.getNext();
            }
            DataRange<?> disjunction = this.getDisjunction(disjuncts);
            return disjunction.containsAtLeast(n);
        }
        DataRange<?> dr = this.normalizeVarRanges(dnf);
        return dr.containsAtLeast(n);
    }

    @Override
    public boolean declare(ATermAppl name) {
        if (this.isDeclared(name)) {
            return false;
        }
        this.declaredUndefined.add(name);
        return true;
    }

    @Override
    public ATermAppl getCanonicalRepresentation(ATermAppl literal) throws InvalidLiteralException, UnrecognizedDatatypeException {
        ATermAppl dtName = DatatypeReasonerImpl.getDatatypeName(literal);
        Datatype<?> dt = this.getDatatype(dtName);
        if (dt == null) {
            switch (PelletOptions.UNDEFINED_DATATYPE_HANDLING) {
                case INFINITE_STRING: {
                    return literal;
                }
                case EMPTY: {
                    throw new InvalidLiteralException(dtName, ATermUtils.getLiteralValue(literal));
                }
                case EXCEPTION: {
                    throw new UnrecognizedDatatypeException(dtName);
                }
            }
            throw new IllegalStateException();
        }
        return dt.getCanonicalRepresentation(literal);
    }

    private DataRange<?> getDataRange(ATermAppl a) throws InvalidConstrainingFacetException, InvalidLiteralException, UnrecognizedDatatypeException {
        if (a.equals((Object)ATermUtils.TOP_LIT)) {
            return TRIVIALLY_SATISFIABLE;
        }
        if (a.equals((Object)ATermUtils.BOTTOM_LIT)) {
            return EMPTY_RANGE;
        }
        if (ATermUtils.isPrimitive(a)) {
            InfiniteNamedDatatype dt = this.getDatatype(a);
            if (dt == null) {
                switch (PelletOptions.UNDEFINED_DATATYPE_HANDLING) {
                    case INFINITE_STRING: {
                        dt = InfiniteNamedDatatype.get(a);
                        break;
                    }
                    case EMPTY: {
                        return EMPTY_RANGE;
                    }
                    case EXCEPTION: {
                        throw new UnrecognizedDatatypeException(a);
                    }
                    default: {
                        throw new IllegalStateException();
                    }
                }
            }
            return dt.asDataRange();
        }
        if (ATermUtils.isRestrictedDatatype(a)) {
            ATermList facetValues;
            ATermAppl dtTerm = (ATermAppl)a.getArgument(0);
            DataRange<?> dt = this.getDataRange(dtTerm);
            if (!(dt instanceof RestrictedDatatype)) {
                throw new InvalidConstrainingFacetException(dtTerm, dt);
            }
            RestrictedDatatype dr = (RestrictedDatatype)dt;
            ATermList l = facetValues = (ATermList)a.getArgument(1);
            while (!l.isEmpty()) {
                Object value;
                ATermAppl fv = (ATermAppl)l.getFirst();
                ATermAppl facet = (ATermAppl)fv.getArgument(0);
                ATermAppl valueTerm = (ATermAppl)fv.getArgument(1);
                try {
                    value = this.getValue(valueTerm);
                }
                catch (InvalidLiteralException e) {
                    throw new InvalidConstrainingFacetException(facet, (Object)valueTerm, e);
                }
                dr = dr.applyConstrainingFacet(facet, value);
                l = l.getNext();
            }
            return dr;
        }
        if (ATermUtils.isNot(a)) {
            ATermAppl n = (ATermAppl)a.getArgument(0);
            DataRange<?> ndr = this.getDataRange(n);
            NegatedDataRange dr = new NegatedDataRange(ndr);
            return dr;
        }
        if (ATermUtils.isNominal(a)) {
            ATermAppl literal = (ATermAppl)a.getArgument(0);
            DataValueEnumeration<Object> dr = new DataValueEnumeration<Object>(Collections.singleton(this.getValue(literal)));
            return dr;
        }
        String msg = String.format("Unrecognized input term (%s) for datarange conversion", a);
        log.severe(msg);
        throw new IllegalArgumentException(msg);
    }

    @Override
    public Datatype<?> getDatatype(ATermAppl uri) {
        try {
            ATermAppl definition;
            Datatype<?> dt = coreDatatypes.get(uri);
            if (dt == null && (definition = this.namedDataRanges.get(uri)) != null && ATermUtils.isRestrictedDatatype(definition)) {
                RestrictedDatatype dataRange = (RestrictedDatatype)this.getDataRange(definition);
                NamedDatatype namedDatatype = new NamedDatatype(uri, dataRange);
                dt = namedDatatype;
            }
            return dt;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private DataRange<?> getDisjunction(Collection<DataRange<?>> ranges) {
        if (ranges.size() == 1) {
            return ranges.iterator().next();
        }
        for (DataRange<?> r : ranges) {
            if (r != TRIVIALLY_SATISFIABLE) continue;
            return r;
        }
        Set oneOf = Collections.emptySet();
        HashMap byPrimitive = new HashMap();
        for (DataRange<?> dr : ranges) {
            if (dr instanceof RestrictedDatatype) {
                RestrictedDatatype rd = (RestrictedDatatype)dr;
                Datatype<?> datatype = rd.getDatatype().getPrimitiveDatatype();
                HashSet<RestrictedDatatype> others = (HashSet<RestrictedDatatype>)byPrimitive.get(datatype);
                if (others == null) {
                    others = new HashSet<RestrictedDatatype>();
                    byPrimitive.put(datatype, others);
                }
                others.add(rd);
                continue;
            }
            if (!(dr instanceof DataValueEnumeration)) continue;
            DataValueEnumeration enm = (DataValueEnumeration)dr;
            if (oneOf.isEmpty()) {
                oneOf = new HashSet();
            }
            Iterator iterator = enm.valueIterator();
            while (iterator.hasNext()) {
                oneOf.add(iterator.next());
            }
        }
        HashSet disjointRanges = new HashSet();
        for (Set s : byPrimitive.values()) {
            Iterator iterator = s.iterator();
            RestrictedDatatype merge = (RestrictedDatatype)iterator.next();
            while (iterator.hasNext()) {
                merge = merge.union((RestrictedDatatype)iterator.next());
            }
            disjointRanges.add(merge);
        }
        Iterator it2 = oneOf.iterator();
        while (it2.hasNext()) {
            Object o = it2.next();
            for (RestrictedDatatype restrictedDatatype : disjointRanges) {
                if (!restrictedDatatype.contains(o)) continue;
                it2.remove();
            }
        }
        return new UnionDataRange(disjointRanges, oneOf);
    }

    @Override
    public ATermAppl getLiteral(Object value) {
        for (Datatype<?> dt : coreDatatypes.values()) {
            if (!dt.isPrimitive() || !dt.asDataRange().contains(value)) continue;
            return dt.getLiteral(value);
        }
        String msg = "Value is not in the value space of any recognized datatypes: " + value.toString();
        log.severe(msg);
        throw new IllegalArgumentException(msg);
    }

    @Override
    public Object getValue(ATermAppl literal) throws InvalidLiteralException, UnrecognizedDatatypeException {
        ATermAppl dtName = DatatypeReasonerImpl.getDatatypeName(literal);
        Datatype<?> dt = this.getDatatype(dtName);
        if (dt == null) {
            switch (PelletOptions.UNDEFINED_DATATYPE_HANDLING) {
                case INFINITE_STRING: {
                    return literal;
                }
                case EMPTY: {
                    throw new InvalidLiteralException(dtName, ATermUtils.getLiteralValue(literal));
                }
                case EXCEPTION: {
                    throw new UnrecognizedDatatypeException(dtName);
                }
            }
            throw new IllegalStateException();
        }
        return dt.getValue(literal);
    }

    @Override
    public boolean isDeclared(ATermAppl name) {
        return ATermUtils.TOP_LIT.equals((Object)name) || coreDatatypes.containsKey(name) || this.namedDataRanges.containsKey(name) || this.declaredUndefined.contains(name);
    }

    @Override
    public boolean isDefined(ATermAppl name) {
        if (ATermUtils.TOP_LIT.equals((Object)name)) {
            return true;
        }
        if (coreDatatypes.containsKey(name)) {
            return true;
        }
        return this.namedDataRanges.containsKey(name);
    }

    @Override
    public ATermAppl getDefinition(ATermAppl name) {
        return this.namedDataRanges.get(name);
    }

    @Override
    public boolean isSatisfiable(Collection<ATermAppl> dataranges) throws InvalidConstrainingFacetException, InvalidLiteralException, UnrecognizedDatatypeException {
        return this.isSatisfiable(dataranges, null);
    }

    @Override
    public boolean isSatisfiable(Collection<ATermAppl> dataranges, Object value) throws InvalidConstrainingFacetException, InvalidLiteralException, UnrecognizedDatatypeException {
        Collection<ATermAppl> dnfDisjuncts;
        Set<Integer> vars;
        HashSet<Integer> consts;
        if (value == null) {
            consts = new HashSet();
            vars = new HashSet<Integer>(Collections.singleton(0));
        } else {
            consts = Collections.singleton(0);
            vars = Collections.emptySet();
        }
        ATermAppl and = ATermUtils.makeAnd(ATermUtils.makeList(dataranges));
        ATermAppl dnf = DNF.dnf(this.expander.expand(and, this.namedDataRanges));
        if (ATermUtils.isOr(dnf)) {
            ArrayList<ATermAppl> disjuncts = new ArrayList<ATermAppl>();
            ATermList l = (ATermList)dnf.getArgument(0);
            while (!l.isEmpty()) {
                disjuncts.add((ATermAppl)l.getFirst());
                l = l.getNext();
            }
            dnfDisjuncts = disjuncts;
        } else {
            dnfDisjuncts = Collections.singleton(dnf);
        }
        Collection[] dnfTypes = new Collection[]{dnfDisjuncts};
        Set[] ne = new Set[]{Collections.emptySet()};
        return this.isSatisfiable(consts, vars, dnfTypes, new Object[]{value}, ne);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private boolean isSatisfiable(Set<Integer> consts, Set<Integer> vars, Collection<ATermAppl>[] dnfTypes, Object[] constValues, Set<Integer>[] ne) throws InvalidConstrainingFacetException, InvalidLiteralException, UnrecognizedDatatypeException {
        Iterator<Integer> it;
        Object dr;
        int n = dnfTypes.length;
        int i = 0;
        while (i < n) {
            Collection<ATermAppl> drs = dnfTypes[i];
            Iterator<ATermAppl> it2 = drs.iterator();
            while (it2.hasNext()) {
                dr = it2.next();
                if (!ATermUtils.BOTTOM_LIT.equals(dr)) continue;
                it2.remove();
            }
            if (drs.isEmpty()) {
                return false;
            }
            ++i;
        }
        DataRange[] normalized = new DataRange[n];
        int i2 = 0;
        while (i2 < n) {
            if (consts.contains(i2)) {
                boolean satisfied = false;
                for (ATermAppl a : dnfTypes[i2]) {
                    if (!this.containedIn(constValues[i2], a)) continue;
                    satisfied = true;
                    break;
                }
                if (!satisfied) return false;
                normalized[i2] = TRIVIALLY_SATISFIABLE;
            } else {
                List<DataRange<?>> drs = new ArrayList();
                for (ATermAppl a : dnfTypes[i2]) {
                    DataRange<?> dr2 = this.normalizeVarRanges(a);
                    if (dr2 == TRIVIALLY_SATISFIABLE) {
                        drs = Collections.singletonList(TRIVIALLY_SATISFIABLE);
                        break;
                    }
                    if (dr2.isEmpty()) continue;
                    drs.add(dr2);
                }
                if (drs.isEmpty()) {
                    return false;
                }
                normalized[i2] = this.getDisjunction(drs);
            }
            ++i2;
        }
        Iterator<Integer> it3 = vars.iterator();
        while (it3.hasNext()) {
            Integer i3 = it3.next();
            dr = normalized[i3];
            if (TRIVIALLY_SATISFIABLE == dr) {
                it3.remove();
                DatatypeReasonerImpl.removeInequalities(ne, i3);
                continue;
            }
            if (dr.isEmpty()) {
                return false;
            }
            if (dr.containsAtLeast(DatatypeReasonerImpl.inequalityCount(ne, i3) + 1)) {
                it3.remove();
                DatatypeReasonerImpl.removeInequalities(ne, i3);
                continue;
            }
            if (!dr.isFinite() || !dr.isEnumerable() || dr.containsAtLeast(2)) continue;
            Object c = dr.valueIterator().next();
            it3.remove();
            consts.add(i3);
            constValues[i3.intValue()] = c;
            normalized[i3.intValue()] = TRIVIALLY_SATISFIABLE;
        }
        if (log.isLoggable(Level.FINEST)) {
            log.finest(String.format("After variable data range normalization %d variables and %d constants", vars.size(), consts.size()));
        }
        for (Integer i4 : consts) {
            Set<Integer> diffs = ne[i4];
            if (diffs == null) continue;
            it = diffs.iterator();
            while (it.hasNext()) {
                int j = it.next();
                if (!consts.contains(j)) continue;
                if (constValues[i4].equals(constValues[j])) {
                    return false;
                }
                it.remove();
                ne[j].remove(i4);
            }
        }
        it3 = vars.iterator();
        while (it3.hasNext()) {
            int min;
            int i5 = it3.next();
            dr = normalized[i5];
            Set<Integer> diffs = ne[i5];
            int n2 = min = diffs == null ? 1 : diffs.size() + 1;
            if (!dr.containsAtLeast(min)) continue;
            it3.remove();
            for (int j : diffs) {
                if (ne[j] == null) continue;
                ne[j].remove(i5);
            }
            ne[i5] = null;
            vars.remove(i5);
        }
        if (log.isLoggable(Level.FINEST)) {
            log.finest(String.format("After size check on variable data ranges %d variables", vars.size()));
        }
        if (vars.isEmpty()) {
            return true;
        }
        HashSet<Integer> remaining = new HashSet<Integer>(vars);
        ArrayList<Set<Integer>> partitions = new ArrayList<Set<Integer>>();
        while (!remaining.isEmpty()) {
            Set<Integer> p = new HashSet();
            it = remaining.iterator();
            int i6 = it.next();
            it.remove();
            p.add(i6);
            if (ne[i6] != null) {
                HashSet<Integer> others = new HashSet<Integer>();
                others.addAll(ne[i6]);
                while (!others.isEmpty()) {
                    Iterator jt = others.iterator();
                    int j = (Integer)jt.next();
                    jt.remove();
                    if (!remaining.contains(j)) continue;
                    p.add(j);
                    remaining.remove(j);
                    if (ne[j] == null) continue;
                    others.addAll(ne[j]);
                }
            }
            partitions.add(p);
        }
        if (log.isLoggable(Level.FINEST)) {
            log.finest(String.format("Enumerating to find solutions for %d partitions", partitions.size()));
        }
        for (Set<Integer> p : partitions) {
            int nPart = p.size();
            int[] indices = new int[nPart];
            HashMap<Integer, Integer> revInd = new HashMap<Integer, Integer>();
            DataRange[] drs = new DataRange[nPart];
            int i7 = 0;
            Iterator iterator = p.iterator();
            while (iterator.hasNext()) {
                int j = (Integer)iterator.next();
                drs[i7] = normalized[j];
                indices[i7] = j;
                revInd.put(j, i7);
                ++i7;
            }
            Iterator[] its = new Iterator[nPart];
            i7 = 0;
            while (i7 < nPart) {
                its[i7] = drs[i7].valueIterator();
                ++i7;
            }
            Object[] values = new Object[nPart];
            i7 = 0;
            while (i7 < nPart) {
                values[i7] = its[i7].next();
                ++i7;
            }
            boolean solutionFound = false;
            while (!solutionFound) {
                solutionFound = true;
                i7 = 0;
                while (i7 < nPart && solutionFound) {
                    Set<Integer> diffs = ne[indices[i7]];
                    if (diffs != null) {
                        Object a = values[i7];
                        for (int j : diffs) {
                            Object b = p.contains(j) ? values[(Integer)revInd.get(j)] : constValues[j];
                            if (!a.equals(b)) continue;
                            solutionFound = false;
                            break;
                        }
                    }
                    ++i7;
                }
                if (solutionFound) continue;
                i7 = nPart - 1;
                while (!its[i7].hasNext()) {
                    if (i7 == 0) {
                        return false;
                    }
                    its[i7] = drs[i7].valueIterator();
                    values[i7] = its[i7].next();
                    --i7;
                }
                values[i7] = its[i7].next();
            }
        }
        return true;
    }

    @Override
    public boolean isSatisfiable(Set<Literal> nodes, Map<Literal, Set<Literal>> neqs) throws InvalidConstrainingFacetException, InvalidLiteralException, UnrecognizedDatatypeException {
        Literal[] literals = nodes.toArray(new Literal[0]);
        HashSet<Integer> vars = new HashSet<Integer>();
        HashSet<Integer> consts = new HashSet<Integer>();
        Object[] constValues = new Object[literals.length];
        HashMap<Literal, Integer> rev = new HashMap<Literal, Integer>();
        int i = 0;
        while (i < literals.length) {
            rev.put(literals[i], i);
            if (literals[i].isNominal()) {
                consts.add(i);
                constValues[i] = literals[i].getValue();
            } else {
                vars.add(i);
            }
            ++i;
        }
        Set[] ne = new Set[literals.length];
        for (Map.Entry<Literal, Set<Literal>> e : neqs.entrySet()) {
            int index = (Integer)rev.get(e.getKey());
            ne[index] = new HashSet();
            for (Literal l : e.getValue()) {
                ne[index].add((Integer)rev.get(l));
            }
        }
        if (log.isLoggable(Level.FINEST)) {
            log.finest(String.format("Checking satisfiability for %d variables and %d constants", vars.size(), consts.size()));
        }
        Collection[] dnfs = new Collection[literals.length];
        int i2 = 0;
        while (i2 < literals.length) {
            ATermAppl and = ATermUtils.makeAnd(ATermUtils.makeList(literals[i2].getTypes()));
            ATermAppl dnf = DNF.dnf(this.expander.expand(and, this.namedDataRanges));
            if (ATermUtils.isOr(dnf)) {
                ArrayList<ATermAppl> disjuncts = new ArrayList<ATermAppl>();
                ATermList l = (ATermList)dnf.getArgument(0);
                while (!l.isEmpty()) {
                    disjuncts.add((ATermAppl)l.getFirst());
                    l = l.getNext();
                }
                dnfs[i2] = disjuncts;
            } else {
                dnfs[i2] = Collections.singleton(dnf);
            }
            ++i2;
        }
        return this.isSatisfiable(consts, vars, dnfs, constValues, ne);
    }

    @Override
    public boolean define(ATermAppl name, ATermAppl datarange) {
        if (name.equals((Object)datarange)) {
            throw new IllegalArgumentException();
        }
        if (this.namedDataRanges.containsKey(name)) {
            return false;
        }
        this.namedDataRanges.put(name, datarange);
        this.declaredUndefined.remove(name);
        return true;
    }

    private DataRange<?> normalizeVarRanges(ATermAppl dconjunction) throws InvalidConstrainingFacetException, InvalidLiteralException, UnrecognizedDatatypeException {
        DataRange<?> ret;
        if (ATermUtils.isAnd(dconjunction)) {
            LinkedHashSet ranges = new LinkedHashSet();
            ATermList l = (ATermList)dconjunction.getArgument(0);
            while (!l.isEmpty()) {
                DataRange<?> dr = this.getDataRange((ATermAppl)l.getFirst());
                if (dr.isEmpty()) {
                    return EMPTY_RANGE;
                }
                ranges.add(dr);
                l = l.getNext();
            }
            HashSet positiveEnumerations = new HashSet();
            HashSet negativeEnumerations = new HashSet();
            HashSet positiveRestrictions = new HashSet();
            HashSet negativeRestrictions = new HashSet();
            DatatypeReasonerImpl.partitionDConjunction(ranges, positiveEnumerations, negativeEnumerations, positiveRestrictions, negativeRestrictions);
            if (!positiveEnumerations.isEmpty()) {
                boolean bl;
                DataValueEnumeration enumeration = DatatypeReasonerImpl.findSmallestEnumeration(positiveEnumerations);
                HashSet hashSet = new HashSet();
                Iterator it = enumeration.valueIterator();
                boolean bl2 = true;
                while (it.hasNext()) {
                    Object t = it.next();
                    boolean permit = true;
                    for (DataRange dataRange : ranges) {
                        if (dataRange == enumeration || dataRange.contains(t)) continue;
                        permit = false;
                        bl = false;
                        break;
                    }
                    if (!permit) continue;
                    hashSet.add(t);
                }
                if (bl) {
                    return enumeration;
                }
                if (hashSet.isEmpty()) {
                    return EMPTY_RANGE;
                }
                return new DataValueEnumeration(hashSet);
            }
            if (positiveRestrictions.isEmpty()) {
                return TRIVIALLY_SATISFIABLE;
            }
            Datatype<?> rootDt = null;
            for (RestrictedDatatype restrictedDatatype : positiveRestrictions) {
                Datatype<?> datatype = restrictedDatatype.getDatatype().getPrimitiveDatatype();
                if (rootDt == null) {
                    rootDt = datatype;
                    continue;
                }
                if (rootDt.equals(datatype)) continue;
                return EMPTY_RANGE;
            }
            Iterator iterator = positiveRestrictions.iterator();
            RestrictedDatatype rd = (RestrictedDatatype)iterator.next();
            while (iterator.hasNext()) {
                RestrictedDatatype restrictedDatatype = (RestrictedDatatype)iterator.next();
                rd = rd.intersect(restrictedDatatype, false);
            }
            for (RestrictedDatatype restrictedDatatype : negativeRestrictions) {
                Datatype<?> dt;
                if (restrictedDatatype.isEmpty() || !rootDt.equals(dt = restrictedDatatype.getDatatype().getPrimitiveDatatype())) continue;
                rd = rd.intersect(restrictedDatatype, true);
            }
            if (!negativeEnumerations.isEmpty()) {
                HashSet hashSet = new HashSet();
                for (DataValueEnumeration dataValueEnumeration : negativeEnumerations) {
                    Iterator iterator2 = dataValueEnumeration.valueIterator();
                    while (iterator2.hasNext()) {
                        hashSet.add(iterator2.next());
                    }
                }
                rd = rd.exclude(hashSet);
            }
            ret = rd;
        } else {
            ret = this.getDataRange(dconjunction);
        }
        if (!ret.isFinite()) {
            return TRIVIALLY_SATISFIABLE;
        }
        return ret;
    }

    @Override
    public Collection<ATermAppl> listDataRanges() {
        HashSet<ATermAppl> dataRanges = new HashSet<ATermAppl>(coreDatatypes.keySet());
        dataRanges.addAll(this.declaredUndefined);
        dataRanges.addAll(this.namedDataRanges.keySet());
        return dataRanges;
    }

    @Override
    public boolean validLiteral(ATermAppl typedLiteral) throws UnrecognizedDatatypeException {
        if (!ATermUtils.isLiteral(typedLiteral)) {
            throw new IllegalArgumentException();
        }
        ATermAppl dtTerm = (ATermAppl)typedLiteral.getArgument(2);
        if (dtTerm == null) {
            throw new IllegalArgumentException();
        }
        Datatype<?> dt = this.getDatatype(dtTerm);
        if (dt == null) {
            throw new UnrecognizedDatatypeException(dtTerm);
        }
        try {
            dt.getValue(typedLiteral);
        }
        catch (InvalidLiteralException e) {
            return false;
        }
        return true;
    }

    @Override
    public Iterator<?> valueIterator(Collection<ATermAppl> dataranges) throws InvalidConstrainingFacetException, InvalidLiteralException, UnrecognizedDatatypeException {
        ATermAppl and = ATermUtils.makeAnd(ATermUtils.makeList(dataranges));
        ATermAppl dnf = DNF.dnf(this.expander.expand(and, this.namedDataRanges));
        if (ATermUtils.isOr(dnf)) {
            ArrayList disjuncts = new ArrayList();
            ATermList l = (ATermList)dnf.getArgument(0);
            while (!l.isEmpty()) {
                DataRange<?> dr = this.normalizeVarRanges((ATermAppl)l.getFirst());
                disjuncts.add(dr);
                l = l.getNext();
            }
            DataRange<?> disjunction = this.getDisjunction(disjuncts);
            if (!disjunction.isEnumerable()) {
                throw new IllegalArgumentException();
            }
            return disjunction.valueIterator();
        }
        DataRange<?> dr = this.normalizeVarRanges(dnf);
        if (!dr.isEnumerable()) {
            throw new IllegalArgumentException();
        }
        return dr.valueIterator();
    }
}

