/*
 * Decompiled with CFR 0.152.
 */
package org.mindswap.pellet.tableau.completion.rule;

import aterm.ATerm;
import aterm.ATermAppl;
import java.util.List;
import java.util.logging.Level;
import org.mindswap.pellet.Clash;
import org.mindswap.pellet.DependencySet;
import org.mindswap.pellet.Individual;
import org.mindswap.pellet.PelletOptions;
import org.mindswap.pellet.exceptions.InternalReasonerException;
import org.mindswap.pellet.tableau.completion.CompletionStrategy;
import org.mindswap.pellet.tableau.completion.queue.NodeSelector;
import org.mindswap.pellet.tableau.completion.rule.AbstractTableauRule;
import org.mindswap.pellet.utils.ATermUtils;

public class NominalRule
extends AbstractTableauRule {
    public NominalRule(CompletionStrategy strategy) {
        super(strategy, NodeSelector.NOMINAL, AbstractTableauRule.BlockingType.NONE);
    }

    @Override
    public void apply(Individual y) {
        List<ATermAppl> types = y.getTypes(6);
        int size = types.size();
        for (int j = 0; j < size; ++j) {
            ATermAppl nc = types.get(j);
            DependencySet ds = y.getDepends((ATerm)nc);
            if (!PelletOptions.MAINTAIN_COMPLETION_QUEUE && ds == null) continue;
            this.applyNominalRule(y, nc, ds);
            if (this.strategy.getABox().isClosed()) {
                return;
            }
            if (!y.isMerged()) continue;
            this.apply(y.getSame());
            return;
        }
    }

    void applyNominalRule(Individual y, ATermAppl nc, DependencySet ds) {
        this.strategy.getABox().copyOnWrite();
        ATermAppl nominal = (ATermAppl)nc.getArgument(0);
        Individual z = this.strategy.getABox().getIndividual((ATerm)nominal);
        if (z == null) {
            if (ATermUtils.isAnonNominal(nominal)) {
                z = this.strategy.getABox().addIndividual(nominal, ds);
            } else {
                throw new InternalReasonerException("Nominal " + nominal + " not found in KB!");
            }
        }
        if (z.isMerged()) {
            ds = ds.union(z.getMergeDependency(true), this.strategy.getABox().doExplanation());
            z = z.getSame();
        }
        if (y.isSame(z)) {
            return;
        }
        if (y.isDifferent(z)) {
            ds = ds.union(y.getDifferenceDependency(z), this.strategy.getABox().doExplanation());
            if (this.strategy.getABox().doExplanation()) {
                this.strategy.getABox().setClash(Clash.nominal(y, ds, z.getName()));
            } else {
                this.strategy.getABox().setClash(Clash.nominal(y, ds));
            }
            return;
        }
        if (log.isLoggable(Level.FINE)) {
            log.fine("NOM:  " + y + " -> " + z);
        }
        this.strategy.mergeTo(y, z, ds);
    }
}

