/*
 * Decompiled with CFR 0.152.
 */
package com.clarkparsia.pellet.rules.rete;

import com.clarkparsia.pellet.rules.model.DifferentIndividualsAtom;
import com.clarkparsia.pellet.rules.model.RuleAtom;
import com.clarkparsia.pellet.rules.rete.AlphaNode;
import com.clarkparsia.pellet.rules.rete.WME;
import java.util.Iterator;
import org.mindswap.pellet.ABox;
import org.mindswap.pellet.DependencySet;
import org.mindswap.pellet.Individual;
import org.mindswap.pellet.Node;
import org.mindswap.pellet.utils.iterator.MapIterator;
import org.mindswap.pellet.utils.iterator.NestedIterator;

public class AlphaDiffFromNode
extends AlphaNode {
    public AlphaDiffFromNode(ABox abox) {
        super(abox);
    }

    public boolean activate(Individual s, Individual o, DependencySet ds) {
        this.activate(WME.createDiffFrom(s, o, ds));
        return true;
    }

    @Override
    public Iterator<WME> getMatches(int argIndex, Node arg) {
        if (argIndex != 0 && argIndex != 1) {
            throw new IndexOutOfBoundsException();
        }
        if (!(arg instanceof Individual)) {
            throw new IllegalArgumentException();
        }
        return this.toWMEs(arg);
    }

    private Iterator<WME> toWMEs(final Node arg) {
        return new MapIterator<Node, WME>(arg.getDifferents().iterator()){

            @Override
            public WME map(Node node) {
                return WME.createDiffFrom((Individual)arg, (Individual)node, arg.getDifferenceDependency(node));
            }
        };
    }

    @Override
    public Iterator<WME> getMatches() {
        return new NestedIterator<Individual, WME>((Iterator)this.abox.getIndIterator()){

            @Override
            public Iterator<WME> getInnerIterator(Individual ind) {
                return AlphaDiffFromNode.this.toWMEs(ind);
            }
        };
    }

    @Override
    public boolean matches(RuleAtom atom) {
        return atom instanceof DifferentIndividualsAtom;
    }

    public String toString() {
        return "DiffFrom(0, 1)";
    }
}

