/*
 * Decompiled with CFR 0.152.
 */
package com.clarkparsia.pellet.el;

import aterm.AFun;
import aterm.ATerm;
import aterm.ATermAppl;
import aterm.ATermList;
import com.clarkparsia.pellet.el.ELSyntaxUtils;
import com.clarkparsia.pellet.el.GenericTaxonomyBuilder;
import com.clarkparsia.pellet.el.RoleRestrictionCache;
import java.util.Collection;
import java.util.Map;
import java.util.Set;
import java.util.logging.Logger;
import org.mindswap.pellet.Role;
import org.mindswap.pellet.taxonomy.CDOptimizedTaxonomyBuilder;
import org.mindswap.pellet.taxonomy.TaxonomyBuilder;
import org.mindswap.pellet.utils.ATermUtils;
import org.mindswap.pellet.utils.MultiValueMap;
import org.mindswap.pellet.utils.Timer;
import org.mindswap.pellet.utils.Timers;

public abstract class RuleBasedELClassifier
extends CDOptimizedTaxonomyBuilder
implements TaxonomyBuilder {
    public static final Logger logger = Logger.getLogger(RuleBasedELClassifier.class.getName());
    protected Timers timers = new Timers();

    protected abstract void addSubclassRule(ATermAppl var1, ATermAppl var2);

    protected abstract void addRoleDomainRule(ATermAppl var1, ATermAppl var2);

    protected abstract void addRoleRangeRule(ATermAppl var1, ATermAppl var2);

    protected abstract void addRoleChainRule(ATerm[] var1, ATermAppl var2);

    protected abstract void addRoleHierarchyRule(ATermAppl var1, ATermAppl var2);

    protected abstract MultiValueMap<ATermAppl, ATermAppl> run(Collection<ATermAppl> var1);

    @Override
    public boolean classify() {
        this.reset();
        this.monitor.setProgressTitle("Classifiying");
        this.monitor.setProgressLength(this.classes.size());
        this.monitor.taskStarted();
        this.monitor.setProgress(0);
        logger.info("Creating structures");
        Timer t = this.timers.startTimer("createConcepts");
        this.processAxioms();
        t.stop();
        logger.info("Running rules");
        MultiValueMap<ATermAppl, ATermAppl> subsumers = this.run(this.kb.getAllClasses());
        this.monitor.setProgress(this.classes.size());
        logger.info("Building hierarchy");
        t = this.timers.startTimer("buildHierarchy");
        this.buildTaxonomy(subsumers);
        t.stop();
        this.monitor.setProgress(this.classes.size());
        this.monitor.taskFinished();
        return true;
    }

    protected void buildTaxonomy(MultiValueMap<ATermAppl, ATermAppl> subsumers) {
        this.taxonomy = new GenericTaxonomyBuilder().build(subsumers);
    }

    private void toELSubClassAxioms(ATermAppl axiom) {
        AFun fun = axiom.getAFun();
        ATermAppl sub = (ATermAppl)axiom.getArgument(0);
        ATermAppl sup = (ATermAppl)axiom.getArgument(1);
        ATermAppl subEL = ELSyntaxUtils.simplify(sub);
        if (fun.equals(ATermUtils.SUBFUN)) {
            if (ATermUtils.isPrimitive(sup) || ATermUtils.isBottom(sup)) {
                this.addSubclassRule(subEL, sup);
                return;
            }
            ATermAppl supEL = ELSyntaxUtils.simplify(sup);
            this.addSubclassRule(subEL, supEL);
        } else if (fun.equals(ATermUtils.EQCLASSFUN)) {
            ATermAppl supEL = ELSyntaxUtils.simplify(sup);
            this.addSubclassRule(subEL, supEL);
            this.addSubclassRule(supEL, subEL);
        } else {
            throw new IllegalArgumentException("Axiom " + axiom + " is not EL.");
        }
    }

    private void processAxioms() {
        Collection<ATermAppl> assertedAxioms = this.kb.getTBox().getAssertedAxioms();
        for (ATermAppl assertedAxiom : assertedAxioms) {
            this.toELSubClassAxioms(assertedAxiom);
        }
        for (Role r : this.kb.getRBox().getRoles()) {
            ATermAppl aTermAppl = r.getName();
            for (Set<ATermAppl> supers : this.kb.getSuperProperties(aTermAppl)) {
                for (ATermAppl sup : supers) {
                    this.addRoleHierarchyRule(aTermAppl, sup);
                }
            }
        }
        for (Role supRole : this.kb.getRBox().getRoles()) {
            for (ATermList chainList : supRole.getSubRoleChains()) {
                ATermAppl[] chain = ATermUtils.toArray(chainList);
                this.addRoleChainRule((ATerm[])chain, supRole.getName());
            }
        }
        RoleRestrictionCache roleRestrictions = new RoleRestrictionCache(this.kb.getRBox());
        for (Map.Entry<ATermAppl, ATermAppl> entry : roleRestrictions.getDomains().entrySet()) {
            this.addRoleDomainRule(entry.getKey(), entry.getValue());
        }
        for (Map.Entry<ATermAppl, ATermAppl> entry : roleRestrictions.getRanges().entrySet()) {
            this.addRoleRangeRule(entry.getKey(), entry.getValue());
        }
        for (Role role : this.kb.getRBox().getRoles()) {
            ATermAppl range;
            if (!role.isReflexive() || (range = roleRestrictions.getRange(role.getName())) == null) continue;
            this.addSubclassRule(ATermUtils.TOP, range);
        }
    }
}

