/*
 * Decompiled with CFR 0.152.
 */
package com.clarkparsia.pellet.datatypes.types.real;

import com.clarkparsia.pellet.datatypes.OWLRealUtils;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.math.MathContext;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.xml.bind.DatatypeConverter;

public class Rational
extends Number
implements Comparable<Rational> {
    private static final long serialVersionUID = 1L;
    private static final Pattern lexicalPattern;
    private final Number denominator;
    private final boolean exact;
    private final Number numerator;
    private final Number quotient;

    public static int compare(Rational a, Rational b) {
        int bs;
        int as = a.signum();
        if (as == (bs = b.signum())) {
            Number qb;
            if (OWLRealUtils.compare(a.getDenominator(), b.getDenominator()) == 0) {
                return OWLRealUtils.compare(a.getNumerator(), b.getNumerator());
            }
            Number qa = a.getQuotient();
            int qCmp = OWLRealUtils.compare(qa, qb = b.getQuotient());
            if (qCmp == 0) {
                if (a.isQuotientExact() && b.isQuotientExact()) {
                    return 0;
                }
                BigInteger aprod = OWLRealUtils.bigInteger(a.getNumerator()).multiply(OWLRealUtils.bigInteger(b.getDenominator()));
                BigInteger bprod = OWLRealUtils.bigInteger(b.getNumerator()).multiply(OWLRealUtils.bigInteger(a.getDenominator()));
                return aprod.compareTo(bprod);
            }
            return qCmp;
        }
        return as > bs ? 1 : -1;
    }

    public static Rational valueOf(String s) throws NumberFormatException {
        if (s == null) {
            throw new NullPointerException();
        }
        Matcher m = lexicalPattern.matcher(s);
        if (!m.matches()) {
            throw new NumberFormatException(s);
        }
        String sLex = m.group(1);
        String nLex = m.group(2);
        String dLex = m.group(3);
        Number n = OWLRealUtils.getCanonicalObject(DatatypeConverter.parseInteger((String)(sLex == null ? nLex : sLex + nLex)));
        Number d = OWLRealUtils.getCanonicalObject(DatatypeConverter.parseInteger((String)dLex));
        if (OWLRealUtils.signum(d) != 1) {
            throw new NumberFormatException(s);
        }
        return new Rational(n, d);
    }

    public static Rational simplify(Rational r) {
        BigInteger n = OWLRealUtils.bigInteger(r.getNumerator());
        BigInteger d = OWLRealUtils.bigInteger(r.getDenominator());
        BigInteger gcd = n.gcd(d);
        while (!gcd.equals(BigInteger.ONE)) {
            n = n.divide(gcd);
            d = d.divide(gcd);
            gcd = n.gcd(d);
        }
        Number canonicalNum = OWLRealUtils.getCanonicalObject(n);
        Number canonicalDenom = OWLRealUtils.getCanonicalObject(d);
        if (canonicalNum.equals(r.getNumerator()) && canonicalDenom.equals(r.getDenominator())) {
            return r;
        }
        return new Rational(canonicalNum, canonicalDenom);
    }

    public String toString() {
        StringBuffer buf = new StringBuffer();
        buf.append(DatatypeConverter.printInteger((BigInteger)OWLRealUtils.bigInteger(this.numerator)));
        buf.append(" / ");
        buf.append(DatatypeConverter.printInteger((BigInteger)OWLRealUtils.bigInteger(this.denominator)));
        return buf.toString();
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.denominator == null ? 0 : this.denominator.hashCode());
        result = 31 * result + (this.numerator == null ? 0 : this.numerator.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Rational other = (Rational)obj;
        if (this.denominator == null ? other.denominator != null : !this.denominator.equals(other.denominator)) {
            return false;
        }
        return !(this.numerator == null ? other.numerator != null : !this.numerator.equals(other.numerator));
    }

    public Rational(Number numerator, Number denominator) {
        boolean ex;
        BigDecimal q;
        if (numerator == null) {
            throw new NullPointerException();
        }
        if (!OWLRealUtils.isInteger(numerator)) {
            throw new IllegalArgumentException();
        }
        if (denominator == null) {
            throw new NullPointerException();
        }
        if (OWLRealUtils.signum(denominator) <= 0) {
            throw new IllegalArgumentException();
        }
        if (!OWLRealUtils.isInteger(denominator)) {
            throw new IllegalArgumentException();
        }
        this.numerator = numerator;
        this.denominator = denominator;
        BigDecimal n = OWLRealUtils.bigDecimal(numerator);
        BigDecimal d = OWLRealUtils.bigDecimal(denominator);
        try {
            q = n.divide(d);
            ex = true;
        }
        catch (ArithmeticException e) {
            q = n.divide(d, MathContext.DECIMAL32);
            ex = false;
        }
        this.quotient = q;
        this.exact = ex;
    }

    @Override
    public int compareTo(Rational that) {
        return Rational.compare(this, that);
    }

    @Override
    public double doubleValue() {
        return this.quotient.doubleValue();
    }

    @Override
    public float floatValue() {
        return this.quotient.floatValue();
    }

    public Number getDenominator() {
        return this.denominator;
    }

    public Number getNumerator() {
        return this.numerator;
    }

    public Number getQuotient() {
        return this.quotient;
    }

    @Override
    public int intValue() {
        return this.quotient.intValue();
    }

    public boolean isQuotientExact() {
        return this.exact;
    }

    @Override
    public long longValue() {
        return this.quotient.longValue();
    }

    public int signum() {
        return OWLRealUtils.signum(this.numerator);
    }

    static {
        String regex = "\\s*([+-])?\\s*(\\d+)\\s*/\\s*(\\d+)\\s*";
        lexicalPattern = Pattern.compile(regex);
    }
}

