/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.sparql.lang.rdql;

import com.hp.hpl.jena.graph.Node;
import com.hp.hpl.jena.graph.impl.LiteralLabel;
import com.hp.hpl.jena.graph.query.IndexValues;
import com.hp.hpl.jena.query.Query;
import com.hp.hpl.jena.sparql.lang.rdql.ExprNodeRDQL;
import com.hp.hpl.jena.sparql.lang.rdql.ExprRDQL;
import com.hp.hpl.jena.sparql.lang.rdql.RDQLEvalFailureException;
import com.hp.hpl.jena.sparql.lang.rdql.RDQLEvalTypeException;
import com.hp.hpl.jena.sparql.lang.rdql.RDQLParser;
import com.hp.hpl.jena.sparql.lang.rdql.RDQL_NodeValue;
import com.hp.hpl.jena.sparql.util.IndentedWriter;

public class ParsedLiteral
extends ExprNodeRDQL
implements ExprRDQL,
RDQL_NodeValue {
    protected boolean isSet = false;
    private boolean isInt = false;
    private boolean isBoolean = false;
    private boolean isDouble = false;
    private boolean isURI = false;
    private boolean isString = false;
    private boolean isGraphNode = false;
    private long valInt;
    private boolean valBoolean;
    private double valDouble;
    private String valString;
    private String valURI;
    private Node valGraphNode;

    ParsedLiteral(int id) {
        super(id);
    }

    ParsedLiteral(RDQLParser p, int id) {
        super(p, id);
    }

    public ParsedLiteral() {
        super(-1);
        this.unset();
    }

    protected ParsedLiteral(RDQL_NodeValue v) {
        super(-1);
        if (v.isBoolean()) {
            this._setBoolean(v.getBoolean());
            return;
        }
        if (v.isInt()) {
            this._setInt(v.getInt());
            return;
        }
        if (v.isDouble()) {
            this._setDouble(v.getDouble());
            return;
        }
        if (v.isURI()) {
            this._setURI(v.getURI());
            return;
        }
        if (v.isNode()) {
            this._setNode(v.getNode());
            return;
        }
        if (v.isString()) {
            this._setString(v.getString());
            return;
        }
    }

    protected void unset() {
        this.isSet = false;
        this.valString = null;
        this.valGraphNode = null;
        this.valInt = 0L;
        this.valBoolean = false;
        this.valDouble = 0.0;
        this.valURI = null;
        this.valGraphNode = null;
        this.isInt = false;
        this.isBoolean = false;
        this.isDouble = false;
        this.isURI = false;
        this.isString = false;
    }

    public RDQL_NodeValue evalRDQL(Query q, IndexValues env) {
        if (!this.isSet) {
            throw new RDQLEvalFailureException("Literal value not set");
        }
        return this;
    }

    public boolean isSet() {
        return this.isSet;
    }

    public boolean isNumber() {
        this.forceNumber();
        return this.isSet && (this.isInt || this.isDouble);
    }

    public boolean isInt() {
        this.forceInt();
        return this.isSet && this.isInt;
    }

    public boolean isDouble() {
        this.forceDouble();
        return this.isSet && this.isDouble;
    }

    public boolean isBoolean() {
        return this.isSet && this.isBoolean;
    }

    public boolean isString() {
        return this.isSet && this.isString;
    }

    public boolean isURI() {
        return this.isSet && this.isURI;
    }

    public boolean isNode() {
        return this.isSet && this.isGraphNode;
    }

    protected void _setInt(long i) {
        this.unset();
        this.isSet = true;
        this.isInt = true;
        this.valInt = i;
    }

    protected void _setDouble(double d) {
        this.unset();
        this.isSet = true;
        this.isDouble = true;
        this.valDouble = d;
    }

    protected void _setBoolean(boolean b) {
        this.unset();
        this.isSet = true;
        this.isBoolean = true;
        this.valBoolean = b;
    }

    protected void _setString(String s) {
        this.unset();
        this.isSet = true;
        this.isString = true;
        this.valString = s;
    }

    protected void _setURI(String uri) {
        this.unset();
        this.isSet = true;
        this.isURI = true;
        this.isString = true;
        this.valURI = uri;
        this.valString = uri;
    }

    protected void _setNode(Node n) {
        this.unset();
        this.isSet = true;
        this.isGraphNode = true;
        this.valGraphNode = n;
        this.isString = false;
        this.valString = null;
        if (n.isLiteral()) {
            this.valString = n.getLiteralLexicalForm();
        }
        if (n.isURI()) {
            this.valString = n.getURI();
            this.valURI = n.getURI();
            this.isURI = true;
        }
        if (n.isBlank()) {
            this.valString = n.getBlankNodeId().getLabelString();
        }
        if (this.valString != null) {
            this.isString = true;
        }
    }

    private void forceInt() {
        if (!this.isSet || this.isInt || !this.isString) {
            return;
        }
        try {
            this.valInt = Long.parseLong(this.valString);
            this.isInt = true;
            this.isDouble = true;
            this.valDouble = this.valInt;
        }
        catch (NumberFormatException e2) {
            return;
        }
    }

    private void forceDouble() {
        if (!this.isSet || this.isDouble || !this.isString) {
            return;
        }
        try {
            this.valDouble = Double.parseDouble(this.valString);
            this.isDouble = true;
        }
        catch (NumberFormatException e2) {
            return;
        }
    }

    private void forceNumber() {
        if (!this.isSet || this.isInt || this.isDouble || !this.isString) {
            return;
        }
        this.forceInt();
        if (!this.isInt) {
            this.forceDouble();
        }
    }

    public long getInt() {
        if (!this.isSet || !this.isInt) {
            throw new RDQLEvalTypeException("Not an int: " + this);
        }
        return this.valInt;
    }

    public double getDouble() {
        if (!this.isSet || !this.isDouble && !this.isInt) {
            throw new RDQLEvalTypeException("Not a double: " + this);
        }
        if (this.isInt) {
            return this.valInt;
        }
        return this.valDouble;
    }

    public boolean getBoolean() {
        if (!this.isSet || !this.isBoolean) {
            throw new RDQLEvalTypeException("Not a boolean: " + this);
        }
        return this.valBoolean;
    }

    public String getString() {
        if (!this.isSet || !this.isString) {
            throw new RDQLEvalTypeException("Not a string: " + this);
        }
        return this.valString;
    }

    public String getURI() {
        if (!this.isSet || !this.isURI) {
            throw new RDQLEvalTypeException("Not a URI: " + this);
        }
        return this.valURI;
    }

    public Node getNode() {
        if (!this.isSet) {
            throw new RDQLEvalTypeException("Not a graph node: " + this);
        }
        return this.valGraphNode;
    }

    public boolean isConstant() {
        return true;
    }

    public Object getValue() {
        return this.getNode();
    }

    public String asQuotedString() {
        if (!this.isSet) {
            return "literal:unset";
        }
        if (this.isInt) {
            return Long.toString(this.valInt);
        }
        if (this.isDouble) {
            return Double.toString(this.valDouble);
        }
        if (this.isBoolean) {
            return this.valBoolean ? "true" : "false";
        }
        if (this.isGraphNode) {
            if (this.valGraphNode.isLiteral()) {
                String lang;
                StringBuffer sBuff = new StringBuffer();
                LiteralLabel l = this.valGraphNode.getLiteral();
                sBuff.append('\"');
                sBuff.append(l.getLexicalForm());
                sBuff.append('\"');
                String dt = l.getDatatypeURI();
                if (dt != null) {
                    sBuff.append("^^");
                    sBuff.append(dt);
                }
                if ((lang = l.language()) != null) {
                    sBuff.append("@");
                    sBuff.append(lang);
                }
            }
            if (this.valGraphNode.isURI()) {
                this.valString = "<" + this.valGraphNode.getURI() + ">";
            }
            if (this.valGraphNode.isBlank()) {
                this.valString = this.valGraphNode.getBlankNodeId().getLabelString();
            }
        }
        if (this.isURI) {
            return "<" + this.valURI + ">";
        }
        if (this.isString) {
            return "\"" + this.valString + "\"";
        }
        return "literal:unknown";
    }

    public String asUnquotedString() {
        if (!this.isSet) {
            return "literal:unset";
        }
        if (this.isInt) {
            return Long.toString(this.valInt);
        }
        if (this.isDouble) {
            return Double.toString(this.valDouble);
        }
        if (this.isBoolean) {
            return this.valBoolean ? "true" : "false";
        }
        if (this.isURI) {
            return this.valURI;
        }
        if (this.isString) {
            return this.valString;
        }
        if (this.isGraphNode) {
            return this.valGraphNode.toString();
        }
        return "literal:unknown";
    }

    public String asInfixString() {
        return this.asQuotedString();
    }

    public String asPrefixString() {
        if (!this.isSet) {
            return "literal:unset";
        }
        if (this.isInt) {
            return "int:" + Long.toString(this.valInt);
        }
        if (this.isDouble) {
            return "double:" + Double.toString(this.valDouble);
        }
        if (this.isBoolean) {
            return "boolean:" + (this.valBoolean ? "true" : "false");
        }
        if (this.isURI) {
            return "URI:" + this.valURI;
        }
        if (this.isString) {
            return "string:" + this.valString;
        }
        if (this.isGraphNode) {
            return "node:" + this.valGraphNode;
        }
        return "literal:unknown";
    }

    public void format(IndentedWriter writer) {
        writer.print(this.asQuotedString());
    }

    public String valueString() {
        return this.asUnquotedString();
    }

    public String toString() {
        return this.asUnquotedString();
    }
}

