/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.sparql.engine.main;

import com.hp.hpl.jena.sparql.algebra.Op;
import com.hp.hpl.jena.sparql.algebra.OpVisitor;
import com.hp.hpl.jena.sparql.algebra.op.OpAssign;
import com.hp.hpl.jena.sparql.algebra.op.OpBGP;
import com.hp.hpl.jena.sparql.algebra.op.OpConditional;
import com.hp.hpl.jena.sparql.algebra.op.OpDatasetNames;
import com.hp.hpl.jena.sparql.algebra.op.OpDiff;
import com.hp.hpl.jena.sparql.algebra.op.OpDisjunction;
import com.hp.hpl.jena.sparql.algebra.op.OpDistinct;
import com.hp.hpl.jena.sparql.algebra.op.OpExt;
import com.hp.hpl.jena.sparql.algebra.op.OpFilter;
import com.hp.hpl.jena.sparql.algebra.op.OpGraph;
import com.hp.hpl.jena.sparql.algebra.op.OpGroupAgg;
import com.hp.hpl.jena.sparql.algebra.op.OpJoin;
import com.hp.hpl.jena.sparql.algebra.op.OpLabel;
import com.hp.hpl.jena.sparql.algebra.op.OpLeftJoin;
import com.hp.hpl.jena.sparql.algebra.op.OpList;
import com.hp.hpl.jena.sparql.algebra.op.OpMinus;
import com.hp.hpl.jena.sparql.algebra.op.OpNull;
import com.hp.hpl.jena.sparql.algebra.op.OpOrder;
import com.hp.hpl.jena.sparql.algebra.op.OpPath;
import com.hp.hpl.jena.sparql.algebra.op.OpProcedure;
import com.hp.hpl.jena.sparql.algebra.op.OpProject;
import com.hp.hpl.jena.sparql.algebra.op.OpPropFunc;
import com.hp.hpl.jena.sparql.algebra.op.OpQuadPattern;
import com.hp.hpl.jena.sparql.algebra.op.OpReduced;
import com.hp.hpl.jena.sparql.algebra.op.OpSequence;
import com.hp.hpl.jena.sparql.algebra.op.OpService;
import com.hp.hpl.jena.sparql.algebra.op.OpSlice;
import com.hp.hpl.jena.sparql.algebra.op.OpTable;
import com.hp.hpl.jena.sparql.algebra.op.OpTriple;
import com.hp.hpl.jena.sparql.algebra.op.OpUnion;
import com.hp.hpl.jena.sparql.engine.QueryIterator;
import com.hp.hpl.jena.sparql.engine.main.OpExecutor;
import com.hp.hpl.jena.sparql.util.ALog;
import java.util.Stack;

class ExecutionDispatch
implements OpVisitor {
    private Stack<QueryIterator> stack = new Stack();
    private OpExecutor opExecutor;

    ExecutionDispatch(OpExecutor exec) {
        this.opExecutor = exec;
    }

    QueryIterator exec(Op op, QueryIterator input) {
        this.push(input);
        int x = this.stack.size();
        op.visit(this);
        int y = this.stack.size();
        if (x != y) {
            ALog.warn(this, "Possible stack misalignment");
        }
        QueryIterator qIter = this.pop();
        return qIter;
    }

    public void visit(OpBGP opBGP) {
        QueryIterator input = this.pop();
        QueryIterator qIter = this.opExecutor.execute(opBGP, input);
        this.push(qIter);
    }

    public void visit(OpQuadPattern quadPattern) {
        QueryIterator input = this.pop();
        QueryIterator qIter = this.opExecutor.execute(quadPattern, input);
        this.push(qIter);
    }

    public void visit(OpTriple opTriple) {
        QueryIterator input = this.pop();
        QueryIterator qIter = this.opExecutor.execute(opTriple, input);
        this.push(qIter);
    }

    public void visit(OpPath opPath) {
        QueryIterator input = this.pop();
        QueryIterator qIter = this.opExecutor.execute(opPath, input);
        this.push(qIter);
    }

    public void visit(OpProcedure opProc) {
        QueryIterator input = this.pop();
        QueryIterator qIter = this.opExecutor.execute(opProc, input);
        this.push(qIter);
    }

    public void visit(OpPropFunc opPropFunc) {
        QueryIterator input = this.pop();
        QueryIterator qIter = this.opExecutor.execute(opPropFunc, input);
        this.push(qIter);
    }

    public void visit(OpJoin opJoin) {
        QueryIterator input = this.pop();
        QueryIterator qIter = this.opExecutor.execute(opJoin, input);
        this.push(qIter);
    }

    public void visit(OpSequence opSequence) {
        QueryIterator input = this.pop();
        QueryIterator qIter = this.opExecutor.execute(opSequence, input);
        this.push(qIter);
    }

    public void visit(OpDisjunction opDisjunction) {
        QueryIterator input = this.pop();
        QueryIterator qIter = this.opExecutor.execute(opDisjunction, input);
        this.push(qIter);
    }

    public void visit(OpLeftJoin opLeftJoin) {
        QueryIterator input = this.pop();
        QueryIterator qIter = this.opExecutor.execute(opLeftJoin, input);
        this.push(qIter);
    }

    public void visit(OpDiff opDiff) {
        QueryIterator input = this.pop();
        QueryIterator qIter = this.opExecutor.execute(opDiff, input);
        this.push(qIter);
    }

    public void visit(OpMinus opMinus) {
        QueryIterator input = this.pop();
        QueryIterator qIter = this.opExecutor.execute(opMinus, input);
        this.push(qIter);
    }

    public void visit(OpUnion opUnion) {
        QueryIterator input = this.pop();
        QueryIterator qIter = this.opExecutor.execute(opUnion, input);
        this.push(qIter);
    }

    public void visit(OpConditional opCondition) {
        QueryIterator input = this.pop();
        QueryIterator qIter = this.opExecutor.execute(opCondition, input);
        this.push(qIter);
    }

    public void visit(OpFilter opFilter) {
        QueryIterator input = this.pop();
        QueryIterator qIter = this.opExecutor.execute(opFilter, input);
        this.push(qIter);
    }

    public void visit(OpGraph opGraph) {
        QueryIterator input = this.pop();
        QueryIterator qIter = this.opExecutor.execute(opGraph, input);
        this.push(qIter);
    }

    public void visit(OpService opService) {
        QueryIterator input = this.pop();
        QueryIterator qIter = this.opExecutor.execute(opService, input);
        this.push(qIter);
    }

    public void visit(OpDatasetNames dsNames) {
        QueryIterator input = this.pop();
        QueryIterator qIter = this.opExecutor.execute(dsNames, input);
        this.push(qIter);
    }

    public void visit(OpTable opTable) {
        QueryIterator input = this.pop();
        QueryIterator qIter = this.opExecutor.execute(opTable, input);
        this.push(qIter);
    }

    public void visit(OpExt opExt) {
        QueryIterator input = this.pop();
        QueryIterator qIter = this.opExecutor.execute(opExt, input);
        this.push(qIter);
    }

    public void visit(OpNull opNull) {
        QueryIterator input = this.pop();
        QueryIterator qIter = this.opExecutor.execute(opNull, input);
        this.push(qIter);
    }

    public void visit(OpLabel opLabel) {
        QueryIterator input = this.pop();
        QueryIterator qIter = this.opExecutor.execute(opLabel, input);
        this.push(qIter);
    }

    public void visit(OpList opList) {
        QueryIterator input = this.pop();
        QueryIterator qIter = this.opExecutor.execute(opList, input);
        this.push(qIter);
    }

    public void visit(OpOrder opOrder) {
        QueryIterator input = this.pop();
        QueryIterator qIter = this.opExecutor.execute(opOrder, input);
        this.push(qIter);
    }

    public void visit(OpProject opProject) {
        QueryIterator input = this.pop();
        QueryIterator qIter = this.opExecutor.execute(opProject, input);
        this.push(qIter);
    }

    public void visit(OpDistinct opDistinct) {
        QueryIterator input = this.pop();
        QueryIterator qIter = this.opExecutor.execute(opDistinct, input);
        this.push(qIter);
    }

    public void visit(OpReduced opReduced) {
        QueryIterator input = this.pop();
        QueryIterator qIter = this.opExecutor.execute(opReduced, input);
        this.push(qIter);
    }

    public void visit(OpAssign opAssign) {
        QueryIterator input = this.pop();
        QueryIterator qIter = this.opExecutor.execute(opAssign, input);
        this.push(qIter);
    }

    public void visit(OpSlice opSlice) {
        QueryIterator input = this.pop();
        QueryIterator qIter = this.opExecutor.execute(opSlice, input);
        this.push(qIter);
    }

    public void visit(OpGroupAgg opGroupAgg) {
        QueryIterator input = this.pop();
        QueryIterator qIter = this.opExecutor.execute(opGroupAgg, input);
        this.push(qIter);
    }

    private void push(QueryIterator qIter) {
        this.stack.push(qIter);
    }

    private QueryIterator pop() {
        if (this.stack.size() == 0) {
            ALog.warn(this, "Warning: pop: empty stack");
        }
        return this.stack.pop();
    }
}

